package customimagesearch

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v1.0/customimagesearch"

// BasicAnswer defines an answer.
type BasicAnswer interface {
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
}

// Answer defines an answer.
type Answer struct {
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicAnswer(body []byte) (BasicAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	default:
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAnswerArray(body []byte) ([]BasicAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Answer.
func (a Answer) MarshalJSON() ([]byte, error) {
	a.Type = TypeAnswer
	objectMap := make(map[string]interface{})
	if a.Type != "" {
		objectMap["_type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Answer.
func (a Answer) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsAnswer() (*Answer, bool) {
	return &a, true
}

// AsBasicAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicAnswer() (BasicAnswer, bool) {
	return &a, true
}

// AsMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Answer.
func (a Answer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// BasicCreativeWork the most generic kind of creative work, including books, movies, photographs, software programs,
// etc.
type BasicCreativeWork interface {
	AsImageObject() (*ImageObject, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsWebPage() (*WebPage, bool)
	AsCreativeWork() (*CreativeWork, bool)
}

// CreativeWork the most generic kind of creative work, including books, movies, photographs, software
// programs, etc.
type CreativeWork struct {
	// ThumbnailURL - READ-ONLY; The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - READ-ONLY; The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// Text - READ-ONLY; Text content of this creative work
	Text *string `json:"text,omitempty"`
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - READ-ONLY; An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - READ-ONLY; A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - READ-ONLY; An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - READ-ONLY; An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicCreativeWork(body []byte) (BasicCreativeWork, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	default:
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	}
}
func unmarshalBasicCreativeWorkArray(body []byte) ([]BasicCreativeWork, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cwArray := make([]BasicCreativeWork, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cw, err := unmarshalBasicCreativeWork(*rawMessage)
		if err != nil {
			return nil, err
		}
		cwArray[index] = cw
	}
	return cwArray, nil
}

// MarshalJSON is the custom marshaler for CreativeWork.
func (cw CreativeWork) MarshalJSON() ([]byte, error) {
	cw.Type = TypeCreativeWork
	objectMap := make(map[string]interface{})
	if cw.Type != "" {
		objectMap["_type"] = cw.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponse() (BasicResponse, bool) {
	return &cw, true
}

// AsThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicThing() (BasicThing, bool) {
	return &cw, true
}

// AsCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCreativeWork() (*CreativeWork, bool) {
	return &cw, true
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &cw, true
}

// AsIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cw, true
}

// AsErrorResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cw, true
}

// UnmarshalJSON is the custom unmarshaler for CreativeWork struct.
func (cw *CreativeWork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				cw.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				cw.Provider = &provider
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				cw.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cw.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				cw.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				cw.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				cw.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				cw.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				cw.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				cw.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				cw.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cw.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cw.Type = typeVar
			}
		}
	}

	return nil
}

// Error defines the error that occurred.
type Error struct {
	// Code - The error code that identifies the category of error. Possible values include: 'None', 'ServerError', 'InvalidRequest', 'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'
	Code ErrorCode `json:"code,omitempty"`
	// SubCode - READ-ONLY; The error code that further helps to identify the error. Possible values include: 'UnexpectedError', 'ResourceError', 'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue', 'HTTPNotAllowed', 'Blocked', 'AuthorizationMissing', 'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
	SubCode ErrorSubCode `json:"subCode,omitempty"`
	// Message - A description of the error.
	Message *string `json:"message,omitempty"`
	// MoreDetails - READ-ONLY; A description that provides additional information about the error.
	MoreDetails *string `json:"moreDetails,omitempty"`
	// Parameter - READ-ONLY; The parameter in the request that caused the error.
	Parameter *string `json:"parameter,omitempty"`
	// Value - READ-ONLY; The parameter's value in the request that was not valid.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.Code != "" {
		objectMap["code"] = e.Code
	}
	if e.Message != nil {
		objectMap["message"] = e.Message
	}
	return json.Marshal(objectMap)
}

// ErrorResponse the top-level response that represents a failed request.
type ErrorResponse struct {
	// Errors - A list of errors that describe the reasons why the request failed.
	Errors *[]Error `json:"errors,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	er.Type = TypeErrorResponse
	objectMap := make(map[string]interface{})
	if er.Errors != nil {
		objectMap["errors"] = er.Errors
	}
	if er.Type != "" {
		objectMap["_type"] = er.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponse() (BasicResponse, bool) {
	return &er, true
}

// AsThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &er, true
}

// AsErrorResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return &er, true
}

// AsWebPage is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &er, true
}

// BasicIdentifiable defines the identity of a resource.
type BasicIdentifiable interface {
	AsImageObject() (*ImageObject, bool)
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsWebPage() (*WebPage, bool)
	AsIdentifiable() (*Identifiable, bool)
}

// Identifiable defines the identity of a resource.
type Identifiable struct {
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicIdentifiable(body []byte) (BasicIdentifiable, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	default:
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIdentifiableArray(body []byte) ([]BasicIdentifiable, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIdentifiable, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIdentifiable(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Identifiable.
func (i Identifiable) MarshalJSON() ([]byte, error) {
	i.Type = TypeIdentifiable
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["_type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIdentifiable() (*Identifiable, bool) {
	return &i, true
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// ImageObject defines an image
type ImageObject struct {
	// Thumbnail - READ-ONLY; The URL to a thumbnail of the image
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
	// ImageInsightsToken - READ-ONLY; The token that you use in a subsequent call to the Image Search API to get additional information about the image. For information about using this token, see the insightsToken query parameter.
	ImageInsightsToken *string `json:"imageInsightsToken,omitempty"`
	// ImageID - READ-ONLY; Unique Id for the image
	ImageID *string `json:"imageId,omitempty"`
	// AccentColor - READ-ONLY; A three-byte hexadecimal number that represents the color that dominates the image. Use the color as the temporary background in your client until the image is loaded.
	AccentColor *string `json:"accentColor,omitempty"`
	// VisualWords - READ-ONLY; Visual representation of the image. Used for getting more sizes
	VisualWords *string `json:"visualWords,omitempty"`
	// ContentURL - READ-ONLY; Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - READ-ONLY; URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// ContentSize - READ-ONLY; Size of the media object content (use format "value unit" e.g "1024 B").
	ContentSize *string `json:"contentSize,omitempty"`
	// EncodingFormat - READ-ONLY; Encoding format (e.g mp3, mp4, jpeg, etc).
	EncodingFormat *string `json:"encodingFormat,omitempty"`
	// HostPageDisplayURL - READ-ONLY; Display URL of the page that hosts the media object.
	HostPageDisplayURL *string `json:"hostPageDisplayUrl,omitempty"`
	// Width - READ-ONLY; The width of the media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - READ-ONLY; The height of the media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// ThumbnailURL - READ-ONLY; The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - READ-ONLY; The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// Text - READ-ONLY; Text content of this creative work
	Text *string `json:"text,omitempty"`
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - READ-ONLY; An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - READ-ONLY; A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - READ-ONLY; An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - READ-ONLY; An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageObject.
func (ioVar ImageObject) MarshalJSON() ([]byte, error) {
	ioVar.Type = TypeImageObject
	objectMap := make(map[string]interface{})
	if ioVar.Type != "" {
		objectMap["_type"] = ioVar.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageObject() (*ImageObject, bool) {
	return &ioVar, true
}

// AsImages is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &ioVar, true
}

// AsResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponse() (BasicResponse, bool) {
	return &ioVar, true
}

// AsThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicThing() (BasicThing, bool) {
	return &ioVar, true
}

// AsCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &ioVar, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ioVar, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ioVar, true
}

// UnmarshalJSON is the custom unmarshaler for ImageObject struct.
func (ioVar *ImageObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thumbnail":
			if v != nil {
				var thumbnail ImageObject
				err = json.Unmarshal(*v, &thumbnail)
				if err != nil {
					return err
				}
				ioVar.Thumbnail = &thumbnail
			}
		case "imageInsightsToken":
			if v != nil {
				var imageInsightsToken string
				err = json.Unmarshal(*v, &imageInsightsToken)
				if err != nil {
					return err
				}
				ioVar.ImageInsightsToken = &imageInsightsToken
			}
		case "imageId":
			if v != nil {
				var imageID string
				err = json.Unmarshal(*v, &imageID)
				if err != nil {
					return err
				}
				ioVar.ImageID = &imageID
			}
		case "accentColor":
			if v != nil {
				var accentColor string
				err = json.Unmarshal(*v, &accentColor)
				if err != nil {
					return err
				}
				ioVar.AccentColor = &accentColor
			}
		case "visualWords":
			if v != nil {
				var visualWords string
				err = json.Unmarshal(*v, &visualWords)
				if err != nil {
					return err
				}
				ioVar.VisualWords = &visualWords
			}
		case "contentUrl":
			if v != nil {
				var contentURL string
				err = json.Unmarshal(*v, &contentURL)
				if err != nil {
					return err
				}
				ioVar.ContentURL = &contentURL
			}
		case "hostPageUrl":
			if v != nil {
				var hostPageURL string
				err = json.Unmarshal(*v, &hostPageURL)
				if err != nil {
					return err
				}
				ioVar.HostPageURL = &hostPageURL
			}
		case "contentSize":
			if v != nil {
				var contentSize string
				err = json.Unmarshal(*v, &contentSize)
				if err != nil {
					return err
				}
				ioVar.ContentSize = &contentSize
			}
		case "encodingFormat":
			if v != nil {
				var encodingFormat string
				err = json.Unmarshal(*v, &encodingFormat)
				if err != nil {
					return err
				}
				ioVar.EncodingFormat = &encodingFormat
			}
		case "hostPageDisplayUrl":
			if v != nil {
				var hostPageDisplayURL string
				err = json.Unmarshal(*v, &hostPageDisplayURL)
				if err != nil {
					return err
				}
				ioVar.HostPageDisplayURL = &hostPageDisplayURL
			}
		case "width":
			if v != nil {
				var width int32
				err = json.Unmarshal(*v, &width)
				if err != nil {
					return err
				}
				ioVar.Width = &width
			}
		case "height":
			if v != nil {
				var height int32
				err = json.Unmarshal(*v, &height)
				if err != nil {
					return err
				}
				ioVar.Height = &height
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				ioVar.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				ioVar.Provider = &provider
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				ioVar.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ioVar.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				ioVar.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				ioVar.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ioVar.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				ioVar.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				ioVar.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				ioVar.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				ioVar.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ioVar.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ioVar.Type = typeVar
			}
		}
	}

	return nil
}

// Images defines an image answer
type Images struct {
	autorest.Response `json:"-"`
	// NextOffset - READ-ONLY; Used as part of deduping. Tells client the next offset that client should use in the next pagination request
	NextOffset *int32 `json:"nextOffset,omitempty"`
	// Value - A list of image objects that are relevant to the query. If there are no results, the List is empty.
	Value *[]ImageObject `json:"value,omitempty"`
	// TotalEstimatedMatches - READ-ONLY; The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for Images.
func (i Images) MarshalJSON() ([]byte, error) {
	i.Type = TypeImages
	objectMap := make(map[string]interface{})
	if i.Value != nil {
		objectMap["value"] = i.Value
	}
	if i.Type != "" {
		objectMap["_type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for Images.
func (i Images) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Images.
func (i Images) AsImages() (*Images, bool) {
	return &i, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &i, true
}

// AsAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsBasicAnswer() (BasicAnswer, bool) {
	return &i, true
}

// AsMediaObject is the BasicResponseBase implementation for Images.
func (i Images) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Images.
func (i Images) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Images.
func (i Images) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Images.
func (i Images) AsBasicResponse() (BasicResponse, bool) {
	return &i, true
}

// AsThing is the BasicResponseBase implementation for Images.
func (i Images) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Images.
func (i Images) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Images.
func (i Images) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Images.
func (i Images) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Images.
func (i Images) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Images.
func (i Images) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Images.
func (i Images) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Images.
func (i Images) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Images.
func (i Images) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Images.
func (i Images) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// BasicMediaObject defines a media object.
type BasicMediaObject interface {
	AsImageObject() (*ImageObject, bool)
	AsMediaObject() (*MediaObject, bool)
}

// MediaObject defines a media object.
type MediaObject struct {
	// ContentURL - READ-ONLY; Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - READ-ONLY; URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// ContentSize - READ-ONLY; Size of the media object content (use format "value unit" e.g "1024 B").
	ContentSize *string `json:"contentSize,omitempty"`
	// EncodingFormat - READ-ONLY; Encoding format (e.g mp3, mp4, jpeg, etc).
	EncodingFormat *string `json:"encodingFormat,omitempty"`
	// HostPageDisplayURL - READ-ONLY; Display URL of the page that hosts the media object.
	HostPageDisplayURL *string `json:"hostPageDisplayUrl,omitempty"`
	// Width - READ-ONLY; The width of the media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - READ-ONLY; The height of the media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// ThumbnailURL - READ-ONLY; The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - READ-ONLY; The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// Text - READ-ONLY; Text content of this creative work
	Text *string `json:"text,omitempty"`
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - READ-ONLY; An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - READ-ONLY; A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - READ-ONLY; An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - READ-ONLY; An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicMediaObject(body []byte) (BasicMediaObject, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	default:
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	}
}
func unmarshalBasicMediaObjectArray(body []byte) ([]BasicMediaObject, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	moArray := make([]BasicMediaObject, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mo, err := unmarshalBasicMediaObject(*rawMessage)
		if err != nil {
			return nil, err
		}
		moArray[index] = mo
	}
	return moArray, nil
}

// MarshalJSON is the custom marshaler for MediaObject.
func (mo MediaObject) MarshalJSON() ([]byte, error) {
	mo.Type = TypeMediaObject
	objectMap := make(map[string]interface{})
	if mo.Type != "" {
		objectMap["_type"] = mo.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsMediaObject() (*MediaObject, bool) {
	return &mo, true
}

// AsBasicMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &mo, true
}

// AsResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponse() (BasicResponse, bool) {
	return &mo, true
}

// AsThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicThing() (BasicThing, bool) {
	return &mo, true
}

// AsCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &mo, true
}

// AsIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &mo, true
}

// AsErrorResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &mo, true
}

// UnmarshalJSON is the custom unmarshaler for MediaObject struct.
func (mo *MediaObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "contentUrl":
			if v != nil {
				var contentURL string
				err = json.Unmarshal(*v, &contentURL)
				if err != nil {
					return err
				}
				mo.ContentURL = &contentURL
			}
		case "hostPageUrl":
			if v != nil {
				var hostPageURL string
				err = json.Unmarshal(*v, &hostPageURL)
				if err != nil {
					return err
				}
				mo.HostPageURL = &hostPageURL
			}
		case "contentSize":
			if v != nil {
				var contentSize string
				err = json.Unmarshal(*v, &contentSize)
				if err != nil {
					return err
				}
				mo.ContentSize = &contentSize
			}
		case "encodingFormat":
			if v != nil {
				var encodingFormat string
				err = json.Unmarshal(*v, &encodingFormat)
				if err != nil {
					return err
				}
				mo.EncodingFormat = &encodingFormat
			}
		case "hostPageDisplayUrl":
			if v != nil {
				var hostPageDisplayURL string
				err = json.Unmarshal(*v, &hostPageDisplayURL)
				if err != nil {
					return err
				}
				mo.HostPageDisplayURL = &hostPageDisplayURL
			}
		case "width":
			if v != nil {
				var width int32
				err = json.Unmarshal(*v, &width)
				if err != nil {
					return err
				}
				mo.Width = &width
			}
		case "height":
			if v != nil {
				var height int32
				err = json.Unmarshal(*v, &height)
				if err != nil {
					return err
				}
				mo.Height = &height
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				mo.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				mo.Provider = &provider
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				mo.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mo.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				mo.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				mo.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				mo.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				mo.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				mo.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				mo.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				mo.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mo.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mo.Type = typeVar
			}
		}
	}

	return nil
}

// Query defines a search query.
type Query struct {
	// Text - The query string. Use this string as the query term in a new search request.
	Text *string `json:"text,omitempty"`
	// DisplayText - READ-ONLY; The display version of the query term. This version of the query term may contain special characters that highlight the search term found in the query string. The string contains the highlighting characters only if the query enabled hit highlighting
	DisplayText *string `json:"displayText,omitempty"`
	// WebSearchURL - READ-ONLY; The URL that takes the user to the Bing search results page for the query.Only related search results include this field.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// SearchLink - READ-ONLY; The URL that you use to get the results of the related search. Before using the URL, you must append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header. Use this URL if you're displaying the results in your own user interface. Otherwise, use the webSearchUrl URL.
	SearchLink *string `json:"searchLink,omitempty"`
	// Thumbnail - READ-ONLY; The URL to a thumbnail of a related image.
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
}

// MarshalJSON is the custom marshaler for Query.
func (q Query) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if q.Text != nil {
		objectMap["text"] = q.Text
	}
	return json.Marshal(objectMap)
}

// BasicResponse defines a response. All schemas that could be returned at the root of a response should inherit from
// this
type BasicResponse interface {
	AsImageObject() (*ImageObject, bool)
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsWebPage() (*WebPage, bool)
	AsResponse() (*Response, bool)
}

// Response defines a response. All schemas that could be returned at the root of a response should inherit
// from this
type Response struct {
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicResponse(body []byte) (BasicResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	default:
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicResponseArray(body []byte) ([]BasicResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Response.
func (r Response) MarshalJSON() ([]byte, error) {
	r.Type = TypeResponse
	objectMap := make(map[string]interface{})
	if r.Type != "" {
		objectMap["_type"] = r.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for Response.
func (r Response) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Response.
func (r Response) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Response.
func (r Response) AsResponse() (*Response, bool) {
	return &r, true
}

// AsBasicResponse is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsThing is the BasicResponseBase implementation for Response.
func (r Response) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Response.
func (r Response) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsErrorResponse is the BasicResponseBase implementation for Response.
func (r Response) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Response.
func (r Response) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// BasicResponseBase response base
type BasicResponseBase interface {
	AsImageObject() (*ImageObject, bool)
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIdentifiable() (*Identifiable, bool)
	AsBasicIdentifiable() (BasicIdentifiable, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsWebPage() (*WebPage, bool)
	AsResponseBase() (*ResponseBase, bool)
}

// ResponseBase response base
type ResponseBase struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicResponseBase(body []byte) (BasicResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIdentifiable):
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	default:
		var rb ResponseBase
		err := json.Unmarshal(body, &rb)
		return rb, err
	}
}
func unmarshalBasicResponseBaseArray(body []byte) ([]BasicResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rbArray := make([]BasicResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rb, err := unmarshalBasicResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rbArray[index] = rb
	}
	return rbArray, nil
}

// MarshalJSON is the custom marshaler for ResponseBase.
func (rb ResponseBase) MarshalJSON() ([]byte, error) {
	rb.Type = TypeResponseBase
	objectMap := make(map[string]interface{})
	if rb.Type != "" {
		objectMap["_type"] = rb.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponseBase() (*ResponseBase, bool) {
	return &rb, true
}

// AsBasicResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rb, true
}

// BasicSearchResultsAnswer defines a search result answer.
type BasicSearchResultsAnswer interface {
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
}

// SearchResultsAnswer defines a search result answer.
type SearchResultsAnswer struct {
	// TotalEstimatedMatches - READ-ONLY; The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicSearchResultsAnswer(body []byte) (BasicSearchResultsAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	default:
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	}
}
func unmarshalBasicSearchResultsAnswerArray(body []byte) ([]BasicSearchResultsAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sraArray := make([]BasicSearchResultsAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sra, err := unmarshalBasicSearchResultsAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		sraArray[index] = sra
	}
	return sraArray, nil
}

// MarshalJSON is the custom marshaler for SearchResultsAnswer.
func (sra SearchResultsAnswer) MarshalJSON() ([]byte, error) {
	sra.Type = TypeSearchResultsAnswer
	objectMap := make(map[string]interface{})
	if sra.Type != "" {
		objectMap["_type"] = sra.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return &sra, true
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &sra, true
}

// AsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &sra, true
}

// AsMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &sra, true
}

// AsThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sra, true
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sra, true
}

// BasicThing defines a thing.
type BasicThing interface {
	AsImageObject() (*ImageObject, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsWebPage() (*WebPage, bool)
	AsThing() (*Thing, bool)
}

// Thing defines a thing.
type Thing struct {
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - READ-ONLY; An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - READ-ONLY; A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - READ-ONLY; An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - READ-ONLY; An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicThing(body []byte) (BasicThing, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	default:
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicThingArray(body []byte) ([]BasicThing, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicThing, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicThing(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Thing.
func (t Thing) MarshalJSON() ([]byte, error) {
	t.Type = TypeThing
	objectMap := make(map[string]interface{})
	if t.Type != "" {
		objectMap["_type"] = t.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Thing.
func (t Thing) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponse() (BasicResponse, bool) {
	return &t, true
}

// AsThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsThing() (*Thing, bool) {
	return &t, true
}

// AsBasicThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicThing() (BasicThing, bool) {
	return &t, true
}

// AsCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &t, true
}

// AsErrorResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Thing.
func (t Thing) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &t, true
}

// WebPage defines a webpage that is relevant to the query.
type WebPage struct {
	// ThumbnailURL - READ-ONLY; The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - READ-ONLY; The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// Text - READ-ONLY; Text content of this creative work
	Text *string `json:"text,omitempty"`
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - READ-ONLY; An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - READ-ONLY; A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - READ-ONLY; An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - READ-ONLY; An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for WebPage.
func (wp WebPage) MarshalJSON() ([]byte, error) {
	wp.Type = TypeWebPage
	objectMap := make(map[string]interface{})
	if wp.Type != "" {
		objectMap["_type"] = wp.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicResponse() (BasicResponse, bool) {
	return &wp, true
}

// AsThing is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicThing() (BasicThing, bool) {
	return &wp, true
}

// AsCreativeWork is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &wp, true
}

// AsIdentifiable is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &wp, true
}

// AsErrorResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsWebPage() (*WebPage, bool) {
	return &wp, true
}

// AsResponseBase is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &wp, true
}

// UnmarshalJSON is the custom unmarshaler for WebPage struct.
func (wp *WebPage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				wp.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				wp.Provider = &provider
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				wp.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wp.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				wp.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				wp.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				wp.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				wp.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				wp.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				wp.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				wp.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wp.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wp.Type = typeVar
			}
		}
	}

	return nil
}
