package cognitiveservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/cognitiveservices/mgmt/2022-03-01/cognitiveservices"

// Account cognitive Services account is an Azure resource representing the provisioned account, it's type,
// location and SKU.
type Account struct {
	autorest.Response `json:"-"`
	// Kind - The Kind of the resource.
	Kind     *string   `json:"kind,omitempty"`
	Sku      *Sku      `json:"sku,omitempty"`
	Identity *Identity `json:"identity,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Properties - Properties of Cognitive Services account.
	Properties *AccountProperties `json:"properties,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Kind != nil {
		objectMap["kind"] = a.Kind
	}
	if a.Sku != nil {
		objectMap["sku"] = a.Sku
	}
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.Properties != nil {
		objectMap["properties"] = a.Properties
	}
	return json.Marshal(objectMap)
}

// AccountListResult the list of cognitive services accounts operation response.
type AccountListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of accounts.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; Gets the list of Cognitive Services accounts and their properties.
	Value *[]Account `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountListResult.
func (alr AccountListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if alr.NextLink != nil {
		objectMap["nextLink"] = alr.NextLink
	}
	return json.Marshal(objectMap)
}

// AccountListResultIterator provides access to a complete listing of Account values.
type AccountListResultIterator struct {
	i    int
	page AccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListResultIterator) Response() AccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListResultIterator) Value() Account {
	if !iter.page.NotDone() {
		return Account{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountListResultIterator type.
func NewAccountListResultIterator(page AccountListResultPage) AccountListResultIterator {
	return AccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AccountListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AccountListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// accountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AccountListResult) accountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AccountListResultPage contains a page of Account values.
type AccountListResultPage struct {
	fn  func(context.Context, AccountListResult) (AccountListResult, error)
	alr AccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListResultPage) Response() AccountListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListResultPage) Values() []Account {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AccountListResultPage type.
func NewAccountListResultPage(cur AccountListResult, getNextPage func(context.Context, AccountListResult) (AccountListResult, error)) AccountListResultPage {
	return AccountListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// AccountModel cognitive Services account Model.
type AccountModel struct {
	// BaseModel - Base Model Identifier.
	BaseModel *DeploymentModel `json:"baseModel,omitempty"`
	// MaxCapacity - The max capacity.
	MaxCapacity *int32 `json:"maxCapacity,omitempty"`
	// Capabilities - The capabilities.
	Capabilities map[string]*string    `json:"capabilities"`
	Deprecation  *ModelDeprecationInfo `json:"deprecation,omitempty"`
	SystemData   *SystemData           `json:"systemData,omitempty"`
	// Format - Deployment model format.
	Format *string `json:"format,omitempty"`
	// Name - Deployment model name.
	Name *string `json:"name,omitempty"`
	// Version - Deployment model version.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountModel.
func (am AccountModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if am.BaseModel != nil {
		objectMap["baseModel"] = am.BaseModel
	}
	if am.MaxCapacity != nil {
		objectMap["maxCapacity"] = am.MaxCapacity
	}
	if am.Capabilities != nil {
		objectMap["capabilities"] = am.Capabilities
	}
	if am.Deprecation != nil {
		objectMap["deprecation"] = am.Deprecation
	}
	if am.SystemData != nil {
		objectMap["systemData"] = am.SystemData
	}
	if am.Format != nil {
		objectMap["format"] = am.Format
	}
	if am.Name != nil {
		objectMap["name"] = am.Name
	}
	if am.Version != nil {
		objectMap["version"] = am.Version
	}
	return json.Marshal(objectMap)
}

// AccountModelListResult the list of cognitive services accounts operation response.
type AccountModelListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of Model.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Gets the list of Cognitive Services accounts Model and their properties.
	Value *[]AccountModel `json:"value,omitempty"`
}

// AccountModelListResultIterator provides access to a complete listing of AccountModel values.
type AccountModelListResultIterator struct {
	i    int
	page AccountModelListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountModelListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountModelListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountModelListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountModelListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountModelListResultIterator) Response() AccountModelListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountModelListResultIterator) Value() AccountModel {
	if !iter.page.NotDone() {
		return AccountModel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountModelListResultIterator type.
func NewAccountModelListResultIterator(page AccountModelListResultPage) AccountModelListResultIterator {
	return AccountModelListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (amlr AccountModelListResult) IsEmpty() bool {
	return amlr.Value == nil || len(*amlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (amlr AccountModelListResult) hasNextLink() bool {
	return amlr.NextLink != nil && len(*amlr.NextLink) != 0
}

// accountModelListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (amlr AccountModelListResult) accountModelListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !amlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(amlr.NextLink)))
}

// AccountModelListResultPage contains a page of AccountModel values.
type AccountModelListResultPage struct {
	fn   func(context.Context, AccountModelListResult) (AccountModelListResult, error)
	amlr AccountModelListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountModelListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountModelListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.amlr)
		if err != nil {
			return err
		}
		page.amlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountModelListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountModelListResultPage) NotDone() bool {
	return !page.amlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountModelListResultPage) Response() AccountModelListResult {
	return page.amlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountModelListResultPage) Values() []AccountModel {
	if page.amlr.IsEmpty() {
		return nil
	}
	return *page.amlr.Value
}

// Creates a new instance of the AccountModelListResultPage type.
func NewAccountModelListResultPage(cur AccountModelListResult, getNextPage func(context.Context, AccountModelListResult) (AccountModelListResult, error)) AccountModelListResultPage {
	return AccountModelListResultPage{
		fn:   getNextPage,
		amlr: cur,
	}
}

// AccountProperties properties of Cognitive Services account.
type AccountProperties struct {
	// ProvisioningState - READ-ONLY; Gets the status of the cognitive services account at the time the operation was called. Possible values include: 'ProvisioningStateAccepted', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateMoving', 'ProvisioningStateFailed', 'ProvisioningStateSucceeded', 'ProvisioningStateResolvingDNS'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Endpoint - READ-ONLY; Endpoint of the created account.
	Endpoint *string `json:"endpoint,omitempty"`
	// InternalID - READ-ONLY; The internal identifier (deprecated, do not use this property).
	InternalID *string `json:"internalId,omitempty"`
	// Capabilities - READ-ONLY; Gets the capabilities of the cognitive services account. Each item indicates the capability of a specific feature. The values are read-only and for reference only.
	Capabilities *[]SkuCapability `json:"capabilities,omitempty"`
	// IsMigrated - READ-ONLY; If the resource is migrated from an existing key.
	IsMigrated *bool `json:"isMigrated,omitempty"`
	// MigrationToken - Resource migration token.
	MigrationToken *string `json:"migrationToken,omitempty"`
	// SkuChangeInfo - READ-ONLY; Sku change info of account.
	SkuChangeInfo *SkuChangeInfo `json:"skuChangeInfo,omitempty"`
	// CustomSubDomainName - Optional subdomain name used for token-based authentication.
	CustomSubDomainName *string `json:"customSubDomainName,omitempty"`
	// NetworkAcls - A collection of rules governing the accessibility from specific network locations.
	NetworkAcls *NetworkRuleSet `json:"networkAcls,omitempty"`
	// Encryption - The encryption properties for this resource.
	Encryption *Encryption `json:"encryption,omitempty"`
	// UserOwnedStorage - The storage accounts for this resource.
	UserOwnedStorage *[]UserOwnedStorage `json:"userOwnedStorage,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; The private endpoint connection associated with the Cognitive Services account.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// PublicNetworkAccess - Whether or not public endpoint access is allowed for this account. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// APIProperties - The api properties for special APIs.
	APIProperties *APIProperties `json:"apiProperties,omitempty"`
	// DateCreated - READ-ONLY; Gets the date of cognitive services account creation.
	DateCreated *string `json:"dateCreated,omitempty"`
	// CallRateLimit - READ-ONLY
	CallRateLimit *CallRateLimit `json:"callRateLimit,omitempty"`
	// DynamicThrottlingEnabled - The flag to enable dynamic throttling.
	DynamicThrottlingEnabled *bool `json:"dynamicThrottlingEnabled,omitempty"`
	// QuotaLimit - READ-ONLY
	QuotaLimit                    *QuotaLimit `json:"quotaLimit,omitempty"`
	RestrictOutboundNetworkAccess *bool       `json:"restrictOutboundNetworkAccess,omitempty"`
	AllowedFqdnList               *[]string   `json:"allowedFqdnList,omitempty"`
	DisableLocalAuth              *bool       `json:"disableLocalAuth,omitempty"`
	// Endpoints - READ-ONLY
	Endpoints map[string]*string `json:"endpoints"`
	Restore   *bool              `json:"restore,omitempty"`
	// DeletionDate - READ-ONLY; The deletion date, only available for deleted account.
	DeletionDate *string `json:"deletionDate,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The scheduled purge date, only available for deleted account.
	ScheduledPurgeDate *string `json:"scheduledPurgeDate,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountProperties.
func (ap AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.MigrationToken != nil {
		objectMap["migrationToken"] = ap.MigrationToken
	}
	if ap.CustomSubDomainName != nil {
		objectMap["customSubDomainName"] = ap.CustomSubDomainName
	}
	if ap.NetworkAcls != nil {
		objectMap["networkAcls"] = ap.NetworkAcls
	}
	if ap.Encryption != nil {
		objectMap["encryption"] = ap.Encryption
	}
	if ap.UserOwnedStorage != nil {
		objectMap["userOwnedStorage"] = ap.UserOwnedStorage
	}
	if ap.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = ap.PublicNetworkAccess
	}
	if ap.APIProperties != nil {
		objectMap["apiProperties"] = ap.APIProperties
	}
	if ap.DynamicThrottlingEnabled != nil {
		objectMap["dynamicThrottlingEnabled"] = ap.DynamicThrottlingEnabled
	}
	if ap.RestrictOutboundNetworkAccess != nil {
		objectMap["restrictOutboundNetworkAccess"] = ap.RestrictOutboundNetworkAccess
	}
	if ap.AllowedFqdnList != nil {
		objectMap["allowedFqdnList"] = ap.AllowedFqdnList
	}
	if ap.DisableLocalAuth != nil {
		objectMap["disableLocalAuth"] = ap.DisableLocalAuth
	}
	if ap.Restore != nil {
		objectMap["restore"] = ap.Restore
	}
	return json.Marshal(objectMap)
}

// AccountsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (Account, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsCreateFuture.Result.
func (future *AccountsCreateFuture) result(client AccountsClient) (a Account, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cognitiveservices.AccountsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cognitiveservices.AccountsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cognitiveservices.AccountsCreateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsDeleteFuture.Result.
func (future *AccountsDeleteFuture) result(client AccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cognitiveservices.AccountsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cognitiveservices.AccountsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AccountSku cognitive Services resource type and SKU.
type AccountSku struct {
	// ResourceType - Resource Namespace and Type
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - The SKU of Cognitive Services account.
	Sku *Sku `json:"sku,omitempty"`
}

// AccountSkuListResult the list of cognitive services accounts operation response.
type AccountSkuListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets the list of Cognitive Services accounts and their properties.
	Value *[]AccountSku `json:"value,omitempty"`
}

// AccountsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (Account, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountsUpdateFuture.Result.
func (future *AccountsUpdateFuture) result(client AccountsClient) (a Account, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cognitiveservices.AccountsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cognitiveservices.AccountsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.UpdateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cognitiveservices.AccountsUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// APIKeys the access keys for the cognitive services account.
type APIKeys struct {
	autorest.Response `json:"-"`
	// Key1 - Gets the value of key 1.
	Key1 *string `json:"key1,omitempty"`
	// Key2 - Gets the value of key 2.
	Key2 *string `json:"key2,omitempty"`
}

// APIProperties the api properties for special APIs.
type APIProperties struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// QnaRuntimeEndpoint - (QnAMaker Only) The runtime endpoint of QnAMaker.
	QnaRuntimeEndpoint *string `json:"qnaRuntimeEndpoint,omitempty"`
	// QnaAzureSearchEndpointKey - (QnAMaker Only) The Azure Search endpoint key of QnAMaker.
	QnaAzureSearchEndpointKey *string `json:"qnaAzureSearchEndpointKey,omitempty"`
	// QnaAzureSearchEndpointID - (QnAMaker Only) The Azure Search endpoint id of QnAMaker.
	QnaAzureSearchEndpointID *string `json:"qnaAzureSearchEndpointId,omitempty"`
	// StatisticsEnabled - (Bing Search Only) The flag to enable statistics of Bing Search.
	StatisticsEnabled *bool `json:"statisticsEnabled,omitempty"`
	// EventHubConnectionString - (Personalization Only) The flag to enable statistics of Bing Search.
	EventHubConnectionString *string `json:"eventHubConnectionString,omitempty"`
	// StorageAccountConnectionString - (Personalization Only) The storage account connection string.
	StorageAccountConnectionString *string `json:"storageAccountConnectionString,omitempty"`
	// AadClientID - (Metrics Advisor Only) The Azure AD Client Id (Application Id).
	AadClientID *string `json:"aadClientId,omitempty"`
	// AadTenantID - (Metrics Advisor Only) The Azure AD Tenant Id.
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// SuperUser - (Metrics Advisor Only) The super user of Metrics Advisor.
	SuperUser *string `json:"superUser,omitempty"`
	// WebsiteName - (Metrics Advisor Only) The website name of Metrics Advisor.
	WebsiteName *string `json:"websiteName,omitempty"`
}

// MarshalJSON is the custom marshaler for APIProperties.
func (ap APIProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.QnaRuntimeEndpoint != nil {
		objectMap["qnaRuntimeEndpoint"] = ap.QnaRuntimeEndpoint
	}
	if ap.QnaAzureSearchEndpointKey != nil {
		objectMap["qnaAzureSearchEndpointKey"] = ap.QnaAzureSearchEndpointKey
	}
	if ap.QnaAzureSearchEndpointID != nil {
		objectMap["qnaAzureSearchEndpointId"] = ap.QnaAzureSearchEndpointID
	}
	if ap.StatisticsEnabled != nil {
		objectMap["statisticsEnabled"] = ap.StatisticsEnabled
	}
	if ap.EventHubConnectionString != nil {
		objectMap["eventHubConnectionString"] = ap.EventHubConnectionString
	}
	if ap.StorageAccountConnectionString != nil {
		objectMap["storageAccountConnectionString"] = ap.StorageAccountConnectionString
	}
	if ap.AadClientID != nil {
		objectMap["aadClientId"] = ap.AadClientID
	}
	if ap.AadTenantID != nil {
		objectMap["aadTenantId"] = ap.AadTenantID
	}
	if ap.SuperUser != nil {
		objectMap["superUser"] = ap.SuperUser
	}
	if ap.WebsiteName != nil {
		objectMap["websiteName"] = ap.WebsiteName
	}
	for k, v := range ap.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for APIProperties struct.
func (ap *APIProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ap.AdditionalProperties == nil {
					ap.AdditionalProperties = make(map[string]interface{})
				}
				ap.AdditionalProperties[k] = additionalProperties
			}
		case "qnaRuntimeEndpoint":
			if v != nil {
				var qnaRuntimeEndpoint string
				err = json.Unmarshal(*v, &qnaRuntimeEndpoint)
				if err != nil {
					return err
				}
				ap.QnaRuntimeEndpoint = &qnaRuntimeEndpoint
			}
		case "qnaAzureSearchEndpointKey":
			if v != nil {
				var qnaAzureSearchEndpointKey string
				err = json.Unmarshal(*v, &qnaAzureSearchEndpointKey)
				if err != nil {
					return err
				}
				ap.QnaAzureSearchEndpointKey = &qnaAzureSearchEndpointKey
			}
		case "qnaAzureSearchEndpointId":
			if v != nil {
				var qnaAzureSearchEndpointID string
				err = json.Unmarshal(*v, &qnaAzureSearchEndpointID)
				if err != nil {
					return err
				}
				ap.QnaAzureSearchEndpointID = &qnaAzureSearchEndpointID
			}
		case "statisticsEnabled":
			if v != nil {
				var statisticsEnabled bool
				err = json.Unmarshal(*v, &statisticsEnabled)
				if err != nil {
					return err
				}
				ap.StatisticsEnabled = &statisticsEnabled
			}
		case "eventHubConnectionString":
			if v != nil {
				var eventHubConnectionString string
				err = json.Unmarshal(*v, &eventHubConnectionString)
				if err != nil {
					return err
				}
				ap.EventHubConnectionString = &eventHubConnectionString
			}
		case "storageAccountConnectionString":
			if v != nil {
				var storageAccountConnectionString string
				err = json.Unmarshal(*v, &storageAccountConnectionString)
				if err != nil {
					return err
				}
				ap.StorageAccountConnectionString = &storageAccountConnectionString
			}
		case "aadClientId":
			if v != nil {
				var aadClientID string
				err = json.Unmarshal(*v, &aadClientID)
				if err != nil {
					return err
				}
				ap.AadClientID = &aadClientID
			}
		case "aadTenantId":
			if v != nil {
				var aadTenantID string
				err = json.Unmarshal(*v, &aadTenantID)
				if err != nil {
					return err
				}
				ap.AadTenantID = &aadTenantID
			}
		case "superUser":
			if v != nil {
				var superUser string
				err = json.Unmarshal(*v, &superUser)
				if err != nil {
					return err
				}
				ap.SuperUser = &superUser
			}
		case "websiteName":
			if v != nil {
				var websiteName string
				err = json.Unmarshal(*v, &websiteName)
				if err != nil {
					return err
				}
				ap.WebsiteName = &websiteName
			}
		}
	}

	return nil
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CallRateLimit the call rate limit Cognitive Services account.
type CallRateLimit struct {
	// Count - The count value of Call Rate Limit.
	Count *float64 `json:"count,omitempty"`
	// RenewalPeriod - The renewal period in seconds of Call Rate Limit.
	RenewalPeriod *float64          `json:"renewalPeriod,omitempty"`
	Rules         *[]ThrottlingRule `json:"rules,omitempty"`
}

// CheckDomainAvailabilityParameter check Domain availability parameter.
type CheckDomainAvailabilityParameter struct {
	// SubdomainName - The subdomain name to use.
	SubdomainName *string `json:"subdomainName,omitempty"`
	// Type - The Type of the resource.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the resource.
	Kind *string `json:"kind,omitempty"`
}

// CheckSkuAvailabilityParameter check SKU availability parameter.
type CheckSkuAvailabilityParameter struct {
	// Skus - The SKU of the resource.
	Skus *[]string `json:"skus,omitempty"`
	// Kind - The Kind of the resource.
	Kind *string `json:"kind,omitempty"`
	// Type - The Type of the resource.
	Type *string `json:"type,omitempty"`
}

// CommitmentCost cognitive Services account commitment cost.
type CommitmentCost struct {
	// CommitmentMeterID - Commitment meter Id.
	CommitmentMeterID *string `json:"commitmentMeterId,omitempty"`
	// OverageMeterID - Overage meter Id.
	OverageMeterID *string `json:"overageMeterId,omitempty"`
}

// CommitmentPeriod cognitive Services account commitment period.
type CommitmentPeriod struct {
	// Tier - Commitment period commitment tier.
	Tier *string `json:"tier,omitempty"`
	// Count - Commitment period commitment count.
	Count *int32 `json:"count,omitempty"`
	// Quota - READ-ONLY
	Quota *CommitmentQuota `json:"quota,omitempty"`
	// StartDate - READ-ONLY; Commitment period start date.
	StartDate *string `json:"startDate,omitempty"`
	// EndDate - READ-ONLY; Commitment period end date.
	EndDate *string `json:"endDate,omitempty"`
}

// MarshalJSON is the custom marshaler for CommitmentPeriod.
func (cp CommitmentPeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Tier != nil {
		objectMap["tier"] = cp.Tier
	}
	if cp.Count != nil {
		objectMap["count"] = cp.Count
	}
	return json.Marshal(objectMap)
}

// CommitmentPlan cognitive Services account commitment plan.
type CommitmentPlan struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// Properties - Properties of Cognitive Services account commitment plan.
	Properties *CommitmentPlanProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CommitmentPlan.
func (cp CommitmentPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Properties != nil {
		objectMap["properties"] = cp.Properties
	}
	return json.Marshal(objectMap)
}

// CommitmentPlanListResult the list of cognitive services accounts operation response.
type CommitmentPlanListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of CommitmentPlan.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; Gets the list of Cognitive Services accounts CommitmentPlan and their properties.
	Value *[]CommitmentPlan `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for CommitmentPlanListResult.
func (cplr CommitmentPlanListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cplr.NextLink != nil {
		objectMap["nextLink"] = cplr.NextLink
	}
	return json.Marshal(objectMap)
}

// CommitmentPlanListResultIterator provides access to a complete listing of CommitmentPlan values.
type CommitmentPlanListResultIterator struct {
	i    int
	page CommitmentPlanListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CommitmentPlanListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CommitmentPlanListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CommitmentPlanListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CommitmentPlanListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CommitmentPlanListResultIterator) Response() CommitmentPlanListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CommitmentPlanListResultIterator) Value() CommitmentPlan {
	if !iter.page.NotDone() {
		return CommitmentPlan{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CommitmentPlanListResultIterator type.
func NewCommitmentPlanListResultIterator(page CommitmentPlanListResultPage) CommitmentPlanListResultIterator {
	return CommitmentPlanListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cplr CommitmentPlanListResult) IsEmpty() bool {
	return cplr.Value == nil || len(*cplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cplr CommitmentPlanListResult) hasNextLink() bool {
	return cplr.NextLink != nil && len(*cplr.NextLink) != 0
}

// commitmentPlanListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cplr CommitmentPlanListResult) commitmentPlanListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cplr.NextLink)))
}

// CommitmentPlanListResultPage contains a page of CommitmentPlan values.
type CommitmentPlanListResultPage struct {
	fn   func(context.Context, CommitmentPlanListResult) (CommitmentPlanListResult, error)
	cplr CommitmentPlanListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CommitmentPlanListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CommitmentPlanListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cplr)
		if err != nil {
			return err
		}
		page.cplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CommitmentPlanListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CommitmentPlanListResultPage) NotDone() bool {
	return !page.cplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CommitmentPlanListResultPage) Response() CommitmentPlanListResult {
	return page.cplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CommitmentPlanListResultPage) Values() []CommitmentPlan {
	if page.cplr.IsEmpty() {
		return nil
	}
	return *page.cplr.Value
}

// Creates a new instance of the CommitmentPlanListResultPage type.
func NewCommitmentPlanListResultPage(cur CommitmentPlanListResult, getNextPage func(context.Context, CommitmentPlanListResult) (CommitmentPlanListResult, error)) CommitmentPlanListResultPage {
	return CommitmentPlanListResultPage{
		fn:   getNextPage,
		cplr: cur,
	}
}

// CommitmentPlanProperties properties of Cognitive Services account commitment plan.
type CommitmentPlanProperties struct {
	// HostingModel - Account hosting model. Possible values include: 'HostingModelWeb', 'HostingModelConnectedContainer', 'HostingModelDisconnectedContainer'
	HostingModel HostingModel `json:"hostingModel,omitempty"`
	// PlanType - Commitment plan type.
	PlanType *string           `json:"planType,omitempty"`
	Current  *CommitmentPeriod `json:"current,omitempty"`
	// AutoRenew - AutoRenew commitment plan.
	AutoRenew *bool             `json:"autoRenew,omitempty"`
	Next      *CommitmentPeriod `json:"next,omitempty"`
	// Last - READ-ONLY
	Last *CommitmentPeriod `json:"last,omitempty"`
}

// MarshalJSON is the custom marshaler for CommitmentPlanProperties.
func (cpp CommitmentPlanProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpp.HostingModel != "" {
		objectMap["hostingModel"] = cpp.HostingModel
	}
	if cpp.PlanType != nil {
		objectMap["planType"] = cpp.PlanType
	}
	if cpp.Current != nil {
		objectMap["current"] = cpp.Current
	}
	if cpp.AutoRenew != nil {
		objectMap["autoRenew"] = cpp.AutoRenew
	}
	if cpp.Next != nil {
		objectMap["next"] = cpp.Next
	}
	return json.Marshal(objectMap)
}

// CommitmentPlansDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CommitmentPlansDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CommitmentPlansClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CommitmentPlansDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CommitmentPlansDeleteFuture.Result.
func (future *CommitmentPlansDeleteFuture) result(client CommitmentPlansClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cognitiveservices.CommitmentPlansDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cognitiveservices.CommitmentPlansDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CommitmentQuota cognitive Services account commitment quota.
type CommitmentQuota struct {
	// Quantity - Commitment quota quantity.
	Quantity *int64 `json:"quantity,omitempty"`
	// Unit - Commitment quota unit.
	Unit *string `json:"unit,omitempty"`
}

// CommitmentTier cognitive Services account commitment tier.
type CommitmentTier struct {
	// Kind - The Kind of the resource.
	Kind *string `json:"kind,omitempty"`
	// SkuName - The name of the SKU. Ex - P3. It is typically a letter+number code
	SkuName *string `json:"skuName,omitempty"`
	// HostingModel - Account hosting model. Possible values include: 'HostingModelWeb', 'HostingModelConnectedContainer', 'HostingModelDisconnectedContainer'
	HostingModel HostingModel `json:"hostingModel,omitempty"`
	// PlanType - Commitment plan type.
	PlanType *string `json:"planType,omitempty"`
	// Tier - Commitment period commitment tier.
	Tier *string `json:"tier,omitempty"`
	// MaxCount - Commitment period commitment max count.
	MaxCount *int32           `json:"maxCount,omitempty"`
	Quota    *CommitmentQuota `json:"quota,omitempty"`
	Cost     *CommitmentCost  `json:"cost,omitempty"`
}

// CommitmentTierListResult the list of cognitive services accounts operation response.
type CommitmentTierListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of CommitmentTier.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; Gets the list of Cognitive Services accounts CommitmentTier and their properties.
	Value *[]CommitmentTier `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for CommitmentTierListResult.
func (ctlr CommitmentTierListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctlr.NextLink != nil {
		objectMap["nextLink"] = ctlr.NextLink
	}
	return json.Marshal(objectMap)
}

// CommitmentTierListResultIterator provides access to a complete listing of CommitmentTier values.
type CommitmentTierListResultIterator struct {
	i    int
	page CommitmentTierListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CommitmentTierListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CommitmentTierListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CommitmentTierListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CommitmentTierListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CommitmentTierListResultIterator) Response() CommitmentTierListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CommitmentTierListResultIterator) Value() CommitmentTier {
	if !iter.page.NotDone() {
		return CommitmentTier{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CommitmentTierListResultIterator type.
func NewCommitmentTierListResultIterator(page CommitmentTierListResultPage) CommitmentTierListResultIterator {
	return CommitmentTierListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ctlr CommitmentTierListResult) IsEmpty() bool {
	return ctlr.Value == nil || len(*ctlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ctlr CommitmentTierListResult) hasNextLink() bool {
	return ctlr.NextLink != nil && len(*ctlr.NextLink) != 0
}

// commitmentTierListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ctlr CommitmentTierListResult) commitmentTierListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ctlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ctlr.NextLink)))
}

// CommitmentTierListResultPage contains a page of CommitmentTier values.
type CommitmentTierListResultPage struct {
	fn   func(context.Context, CommitmentTierListResult) (CommitmentTierListResult, error)
	ctlr CommitmentTierListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CommitmentTierListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CommitmentTierListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ctlr)
		if err != nil {
			return err
		}
		page.ctlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CommitmentTierListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CommitmentTierListResultPage) NotDone() bool {
	return !page.ctlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CommitmentTierListResultPage) Response() CommitmentTierListResult {
	return page.ctlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CommitmentTierListResultPage) Values() []CommitmentTier {
	if page.ctlr.IsEmpty() {
		return nil
	}
	return *page.ctlr.Value
}

// Creates a new instance of the CommitmentTierListResultPage type.
func NewCommitmentTierListResultPage(cur CommitmentTierListResult, getNextPage func(context.Context, CommitmentTierListResult) (CommitmentTierListResult, error)) CommitmentTierListResultPage {
	return CommitmentTierListResultPage{
		fn:   getNextPage,
		ctlr: cur,
	}
}

// DeletedAccountsPurgeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeletedAccountsPurgeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeletedAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeletedAccountsPurgeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeletedAccountsPurgeFuture.Result.
func (future *DeletedAccountsPurgeFuture) result(client DeletedAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cognitiveservices.DeletedAccountsPurgeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cognitiveservices.DeletedAccountsPurgeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Deployment cognitive Services account deployment.
type Deployment struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// Properties - Properties of Cognitive Services account deployment.
	Properties *DeploymentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Deployment.
func (d Deployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Properties != nil {
		objectMap["properties"] = d.Properties
	}
	return json.Marshal(objectMap)
}

// DeploymentListResult the list of cognitive services accounts operation response.
type DeploymentListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of Deployment.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; Gets the list of Cognitive Services accounts Deployment and their properties.
	Value *[]Deployment `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentListResult.
func (dlr DeploymentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dlr.NextLink != nil {
		objectMap["nextLink"] = dlr.NextLink
	}
	return json.Marshal(objectMap)
}

// DeploymentListResultIterator provides access to a complete listing of Deployment values.
type DeploymentListResultIterator struct {
	i    int
	page DeploymentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeploymentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentListResultIterator) Response() DeploymentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentListResultIterator) Value() Deployment {
	if !iter.page.NotDone() {
		return Deployment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeploymentListResultIterator type.
func NewDeploymentListResultIterator(page DeploymentListResultPage) DeploymentListResultIterator {
	return DeploymentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DeploymentListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlr DeploymentListResult) hasNextLink() bool {
	return dlr.NextLink != nil && len(*dlr.NextLink) != 0
}

// deploymentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DeploymentListResult) deploymentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DeploymentListResultPage contains a page of Deployment values.
type DeploymentListResultPage struct {
	fn  func(context.Context, DeploymentListResult) (DeploymentListResult, error)
	dlr DeploymentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlr)
		if err != nil {
			return err
		}
		page.dlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeploymentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentListResultPage) Response() DeploymentListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentListResultPage) Values() []Deployment {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DeploymentListResultPage type.
func NewDeploymentListResultPage(cur DeploymentListResult, getNextPage func(context.Context, DeploymentListResult) (DeploymentListResult, error)) DeploymentListResultPage {
	return DeploymentListResultPage{
		fn:  getNextPage,
		dlr: cur,
	}
}

// DeploymentModel properties of Cognitive Services account deployment model.
type DeploymentModel struct {
	// Format - Deployment model format.
	Format *string `json:"format,omitempty"`
	// Name - Deployment model name.
	Name *string `json:"name,omitempty"`
	// Version - Deployment model version.
	Version *string `json:"version,omitempty"`
}

// DeploymentProperties properties of Cognitive Services account deployment.
type DeploymentProperties struct {
	// ProvisioningState - READ-ONLY; Gets the status of the resource at the time the operation was called. Possible values include: 'DeploymentProvisioningStateAccepted', 'DeploymentProvisioningStateCreating', 'DeploymentProvisioningStateDeleting', 'DeploymentProvisioningStateMoving', 'DeploymentProvisioningStateFailed', 'DeploymentProvisioningStateSucceeded'
	ProvisioningState DeploymentProvisioningState `json:"provisioningState,omitempty"`
	Model             *DeploymentModel            `json:"model,omitempty"`
	ScaleSettings     *DeploymentScaleSettings    `json:"scaleSettings,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentProperties.
func (dp DeploymentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.Model != nil {
		objectMap["model"] = dp.Model
	}
	if dp.ScaleSettings != nil {
		objectMap["scaleSettings"] = dp.ScaleSettings
	}
	return json.Marshal(objectMap)
}

// DeploymentScaleSettings properties of Cognitive Services account deployment model.
type DeploymentScaleSettings struct {
	// ScaleType - Deployment scale type. Possible values include: 'DeploymentScaleTypeManual'
	ScaleType DeploymentScaleType `json:"scaleType,omitempty"`
	// Capacity - Deployment capacity.
	Capacity *int32 `json:"capacity,omitempty"`
	// ActiveCapacity - READ-ONLY; Deployment active capacity. This value might be different from `capacity` if customer recently updated `capacity`.
	ActiveCapacity *int32 `json:"activeCapacity,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentScaleSettings.
func (dss DeploymentScaleSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dss.ScaleType != "" {
		objectMap["scaleType"] = dss.ScaleType
	}
	if dss.Capacity != nil {
		objectMap["capacity"] = dss.Capacity
	}
	return json.Marshal(objectMap)
}

// DeploymentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (Deployment, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsCreateOrUpdateFuture.Result.
func (future *DeploymentsCreateOrUpdateFuture) result(client DeploymentsClient) (d Deployment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cognitiveservices.DeploymentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cognitiveservices.DeploymentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cognitiveservices.DeploymentsCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsDeleteFuture.Result.
func (future *DeploymentsDeleteFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cognitiveservices.DeploymentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cognitiveservices.DeploymentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DomainAvailability domain availability.
type DomainAvailability struct {
	autorest.Response `json:"-"`
	// IsSubdomainAvailable - Indicates the given SKU is available or not.
	IsSubdomainAvailable *bool `json:"isSubdomainAvailable,omitempty"`
	// Reason - Reason why the SKU is not available.
	Reason *string `json:"reason,omitempty"`
	// SubdomainName - The subdomain name to use.
	SubdomainName *string `json:"subdomainName,omitempty"`
	// Type - The Type of the resource.
	Type *string `json:"type,omitempty"`
	// Kind - The Kind of the resource.
	Kind *string `json:"kind,omitempty"`
}

// Encryption properties to configure Encryption
type Encryption struct {
	// KeyVaultProperties - Properties of KeyVault
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
	// KeySource - Enumerates the possible value of keySource for Encryption. Possible values include: 'KeySourceMicrosoftCognitiveServices', 'KeySourceMicrosoftKeyVault'
	KeySource KeySource `json:"keySource,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeNone', 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeSystemAssignedUserAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// UserAssignedIdentities - The list of user assigned identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	if i.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = i.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// IPRule a rule governing the accessibility from a specific ip address or ip range.
type IPRule struct {
	// Value - An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
	Value *string `json:"value,omitempty"`
}

// KeyVaultProperties properties to configure keyVault Properties
type KeyVaultProperties struct {
	// KeyName - Name of the Key from KeyVault
	KeyName *string `json:"keyName,omitempty"`
	// KeyVersion - Version of the Key from KeyVault
	KeyVersion *string `json:"keyVersion,omitempty"`
	// KeyVaultURI - Uri of KeyVault
	KeyVaultURI      *string `json:"keyVaultUri,omitempty"`
	IdentityClientID *string `json:"identityClientId,omitempty"`
}

// MetricName a metric name.
type MetricName struct {
	// Value - The name of the metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - The friendly name of the metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// ModelDeprecationInfo cognitive Services account ModelDeprecationInfo.
type ModelDeprecationInfo struct {
	// FineTune - The datetime of deprecation of the fineTune Model.
	FineTune *string `json:"fineTune,omitempty"`
	// Inference - The datetime of deprecation of the inference Model.
	Inference *string `json:"inference,omitempty"`
}

// NetworkRuleSet a set of rules governing the network accessibility.
type NetworkRuleSet struct {
	// DefaultAction - The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated. Possible values include: 'NetworkRuleActionAllow', 'NetworkRuleActionDeny'
	DefaultAction NetworkRuleAction `json:"defaultAction,omitempty"`
	// IPRules - The list of IP address rules.
	IPRules *[]IPRule `json:"ipRules,omitempty"`
	// VirtualNetworkRules - The list of virtual network rules.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// Operation details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Name - READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty"`
	// IsDataAction - READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane operations.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default value is "user,system". Possible values include: 'OriginUser', 'OriginSystem', 'OriginUsersystem'
	Origin Origin `json:"origin,omitempty"`
	// ActionType - READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs. Possible values include: 'ActionTypeInternal'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay localized display information for this particular operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft Compute".
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job Schedule Collections".
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult a list of REST API operations supported by an Azure Resource Provider. It contains
// an URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations supported by the resource provider
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// Properties - Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY
	SystemData *SystemData `json:"systemData,omitempty"`
	// Location - The location of the private endpoint connection
	Location *string `json:"location,omitempty"`
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.Properties != nil {
		objectMap["properties"] = pec.Properties
	}
	if pec.Location != nil {
		objectMap["location"] = pec.Location
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionListResult a list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
	// GroupIds - The private link resource group ids.
	GroupIds *[]string `json:"groupIds,omitempty"`
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cognitiveservices.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cognitiveservices.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cognitiveservices.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cognitiveservices.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("cognitiveservices.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	// Properties - Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.Properties != nil {
		objectMap["properties"] = plr.Properties
	}
	return json.Marshal(objectMap)
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
	// DisplayName - READ-ONLY; The private link resource display name.
	DisplayName *string `json:"displayName,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'PrivateEndpointServiceConnectionStatusPending', 'PrivateEndpointServiceConnectionStatusApproved', 'PrivateEndpointServiceConnectionStatusRejected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// QuotaLimit ...
type QuotaLimit struct {
	Count         *float64          `json:"count,omitempty"`
	RenewalPeriod *float64          `json:"renewalPeriod,omitempty"`
	Rules         *[]ThrottlingRule `json:"rules,omitempty"`
}

// RegenerateKeyParameters regenerate key parameters.
type RegenerateKeyParameters struct {
	// KeyName - key name to generate (Key1|Key2). Possible values include: 'KeyNameKey1', 'KeyNameKey2'
	KeyName KeyName `json:"keyName,omitempty"`
}

// RequestMatchPattern ...
type RequestMatchPattern struct {
	Path   *string `json:"path,omitempty"`
	Method *string `json:"method,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceSku describes an available Cognitive Services SKU.
type ResourceSku struct {
	// ResourceType - The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - The name of SKU.
	Name *string `json:"name,omitempty"`
	// Tier - Specifies the tier of Cognitive Services account.
	Tier *string `json:"tier,omitempty"`
	// Kind - The Kind of resources that are supported in this SKU.
	Kind *string `json:"kind,omitempty"`
	// Locations - The set of locations that the SKU is available.
	Locations *[]string `json:"locations,omitempty"`
	// Restrictions - The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions *[]ResourceSkuRestrictions `json:"restrictions,omitempty"`
}

// ResourceSkuListResult the Get Skus operation response.
type ResourceSkuListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of skus available for the subscription.
	Value *[]ResourceSku `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of Skus.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceSkuListResultIterator provides access to a complete listing of ResourceSku values.
type ResourceSkuListResultIterator struct {
	i    int
	page ResourceSkuListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceSkuListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkuListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceSkuListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceSkuListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceSkuListResultIterator) Response() ResourceSkuListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceSkuListResultIterator) Value() ResourceSku {
	if !iter.page.NotDone() {
		return ResourceSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceSkuListResultIterator type.
func NewResourceSkuListResultIterator(page ResourceSkuListResultPage) ResourceSkuListResultIterator {
	return ResourceSkuListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rslr ResourceSkuListResult) IsEmpty() bool {
	return rslr.Value == nil || len(*rslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rslr ResourceSkuListResult) hasNextLink() bool {
	return rslr.NextLink != nil && len(*rslr.NextLink) != 0
}

// resourceSkuListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rslr ResourceSkuListResult) resourceSkuListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rslr.NextLink)))
}

// ResourceSkuListResultPage contains a page of ResourceSku values.
type ResourceSkuListResultPage struct {
	fn   func(context.Context, ResourceSkuListResult) (ResourceSkuListResult, error)
	rslr ResourceSkuListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceSkuListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkuListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rslr)
		if err != nil {
			return err
		}
		page.rslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceSkuListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceSkuListResultPage) NotDone() bool {
	return !page.rslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceSkuListResultPage) Response() ResourceSkuListResult {
	return page.rslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceSkuListResultPage) Values() []ResourceSku {
	if page.rslr.IsEmpty() {
		return nil
	}
	return *page.rslr.Value
}

// Creates a new instance of the ResourceSkuListResultPage type.
func NewResourceSkuListResultPage(cur ResourceSkuListResult, getNextPage func(context.Context, ResourceSkuListResult) (ResourceSkuListResult, error)) ResourceSkuListResultPage {
	return ResourceSkuListResultPage{
		fn:   getNextPage,
		rslr: cur,
	}
}

// ResourceSkuRestrictionInfo ...
type ResourceSkuRestrictionInfo struct {
	// Locations - Locations where the SKU is restricted
	Locations *[]string `json:"locations,omitempty"`
	// Zones - List of availability zones where the SKU is restricted.
	Zones *[]string `json:"zones,omitempty"`
}

// ResourceSkuRestrictions describes restrictions of a SKU.
type ResourceSkuRestrictions struct {
	// Type - The type of restrictions. Possible values include: 'ResourceSkuRestrictionsTypeLocation', 'ResourceSkuRestrictionsTypeZone'
	Type ResourceSkuRestrictionsType `json:"type,omitempty"`
	// Values - The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// RestrictionInfo - The information about the restriction where the SKU cannot be used.
	RestrictionInfo *ResourceSkuRestrictionInfo `json:"restrictionInfo,omitempty"`
	// ReasonCode - The reason for restriction. Possible values include: 'ResourceSkuRestrictionsReasonCodeQuotaID', 'ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription'
	ReasonCode ResourceSkuRestrictionsReasonCode `json:"reasonCode,omitempty"`
}

// Sku the resource model definition representing SKU
type Sku struct {
	// Name - The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`
	// Tier - This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT. Possible values include: 'SkuTierFree', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium', 'SkuTierEnterprise'
	Tier SkuTier `json:"tier,omitempty"`
	// Size - The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SkuAvailability SKU availability.
type SkuAvailability struct {
	// Kind - The Kind of the resource.
	Kind *string `json:"kind,omitempty"`
	// Type - The Type of the resource.
	Type *string `json:"type,omitempty"`
	// SkuName - The SKU of Cognitive Services account.
	SkuName *string `json:"skuName,omitempty"`
	// SkuAvailable - Indicates the given SKU is available or not.
	SkuAvailable *bool `json:"skuAvailable,omitempty"`
	// Reason - Reason why the SKU is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - Additional error message.
	Message *string `json:"message,omitempty"`
}

// SkuAvailabilityListResult check SKU availability result list.
type SkuAvailabilityListResult struct {
	autorest.Response `json:"-"`
	// Value - Check SKU availability result list.
	Value *[]SkuAvailability `json:"value,omitempty"`
}

// SkuCapability skuCapability indicates the capability of a certain feature.
type SkuCapability struct {
	// Name - The name of the SkuCapability.
	Name *string `json:"name,omitempty"`
	// Value - The value of the SkuCapability.
	Value *string `json:"value,omitempty"`
}

// SkuChangeInfo sku change info of account.
type SkuChangeInfo struct {
	// CountOfDowngrades - Gets the count of downgrades.
	CountOfDowngrades *float64 `json:"countOfDowngrades,omitempty"`
	// CountOfUpgradesAfterDowngrades - Gets the count of upgrades after downgrades.
	CountOfUpgradesAfterDowngrades *float64 `json:"countOfUpgradesAfterDowngrades,omitempty"`
	// LastChangeDate - Gets the last change date.
	LastChangeDate *string `json:"lastChangeDate,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// ThrottlingRule ...
type ThrottlingRule struct {
	Key                      *string                `json:"key,omitempty"`
	RenewalPeriod            *float64               `json:"renewalPeriod,omitempty"`
	Count                    *float64               `json:"count,omitempty"`
	MinCount                 *float64               `json:"minCount,omitempty"`
	DynamicThrottlingEnabled *bool                  `json:"dynamicThrottlingEnabled,omitempty"`
	MatchPatterns            *[]RequestMatchPattern `json:"matchPatterns,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// Usage the usage data for a usage request.
type Usage struct {
	// Unit - The unit of the metric. Possible values include: 'UnitTypeCount', 'UnitTypeBytes', 'UnitTypeSeconds', 'UnitTypePercent', 'UnitTypeCountPerSecond', 'UnitTypeBytesPerSecond', 'UnitTypeMilliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// QuotaPeriod - The quota period used to summarize the usage values.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// Limit - Maximum value for this metric.
	Limit *float64 `json:"limit,omitempty"`
	// CurrentValue - Current value for this metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// NextResetTime - Next reset time for current quota.
	NextResetTime *string `json:"nextResetTime,omitempty"`
	// Status - Cognitive Services account quota usage status. Possible values include: 'QuotaUsageStatusIncluded', 'QuotaUsageStatusBlocked', 'QuotaUsageStatusInOverage', 'QuotaUsageStatusUnknown'
	Status QuotaUsageStatus `json:"status,omitempty"`
}

// UsageListResult the response to a list usage request.
type UsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of usages for Cognitive Service account.
	Value *[]Usage `json:"value,omitempty"`
}

// UserAssignedIdentity user-assigned managed identity.
type UserAssignedIdentity struct {
	// PrincipalID - READ-ONLY; Azure Active Directory principal ID associated with this Identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; Client App Id associated with this identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserAssignedIdentity.
func (uai UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UserOwnedStorage the user owned storage for Cognitive Services account.
type UserOwnedStorage struct {
	// ResourceID - Full resource id of a Microsoft.Storage resource.
	ResourceID       *string `json:"resourceId,omitempty"`
	IdentityClientID *string `json:"identityClientId,omitempty"`
}

// VirtualNetworkRule a rule governing the accessibility from a specific virtual network.
type VirtualNetworkRule struct {
	// ID - Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
	ID *string `json:"id,omitempty"`
	// State - Gets the state of virtual network rule.
	State *string `json:"state,omitempty"`
	// IgnoreMissingVnetServiceEndpoint - Ignore missing vnet service endpoint or not.
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`
}
