package attestation

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// TeeKind enumerates the values for tee kind.
type TeeKind string

const (
	// CyResComponent IoT Edge validation
	CyResComponent TeeKind = "CyResComponent"
	// OpenEnclave OpenEnclave extensions to SGX
	OpenEnclave TeeKind = "OpenEnclave"
	// SgxEnclave Intel Software Guard eXtensions
	SgxEnclave TeeKind = "SgxEnclave"
	// VSMEnclave VSM Enclave Attestation
	VSMEnclave TeeKind = "VSMEnclave"
)

// PossibleTeeKindValues returns an array of possible values for the TeeKind const type.
func PossibleTeeKindValues() []TeeKind {
	return []TeeKind{CyResComponent, OpenEnclave, SgxEnclave, VSMEnclave}
}
