// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package groundstationiface provides an interface to enable mocking the AWS Ground Station service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package groundstationiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/groundstation"
)

// GroundStationAPI provides an interface to enable mocking the
// groundstation.GroundStation service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Ground Station.
//	func myFunc(svc groundstationiface.GroundStationAPI) bool {
//	    // Make svc.CancelContact request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := groundstation.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockGroundStationClient struct {
//	    groundstationiface.GroundStationAPI
//	}
//	func (m *mockGroundStationClient) CancelContact(input *groundstation.CancelContactInput) (*groundstation.CancelContactOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockGroundStationClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type GroundStationAPI interface {
	CancelContact(*groundstation.CancelContactInput) (*groundstation.CancelContactOutput, error)
	CancelContactWithContext(aws.Context, *groundstation.CancelContactInput, ...request.Option) (*groundstation.CancelContactOutput, error)
	CancelContactRequest(*groundstation.CancelContactInput) (*request.Request, *groundstation.CancelContactOutput)

	CreateConfig(*groundstation.CreateConfigInput) (*groundstation.CreateConfigOutput, error)
	CreateConfigWithContext(aws.Context, *groundstation.CreateConfigInput, ...request.Option) (*groundstation.CreateConfigOutput, error)
	CreateConfigRequest(*groundstation.CreateConfigInput) (*request.Request, *groundstation.CreateConfigOutput)

	CreateDataflowEndpointGroup(*groundstation.CreateDataflowEndpointGroupInput) (*groundstation.CreateDataflowEndpointGroupOutput, error)
	CreateDataflowEndpointGroupWithContext(aws.Context, *groundstation.CreateDataflowEndpointGroupInput, ...request.Option) (*groundstation.CreateDataflowEndpointGroupOutput, error)
	CreateDataflowEndpointGroupRequest(*groundstation.CreateDataflowEndpointGroupInput) (*request.Request, *groundstation.CreateDataflowEndpointGroupOutput)

	CreateMissionProfile(*groundstation.CreateMissionProfileInput) (*groundstation.CreateMissionProfileOutput, error)
	CreateMissionProfileWithContext(aws.Context, *groundstation.CreateMissionProfileInput, ...request.Option) (*groundstation.CreateMissionProfileOutput, error)
	CreateMissionProfileRequest(*groundstation.CreateMissionProfileInput) (*request.Request, *groundstation.CreateMissionProfileOutput)

	DeleteConfig(*groundstation.DeleteConfigInput) (*groundstation.DeleteConfigOutput, error)
	DeleteConfigWithContext(aws.Context, *groundstation.DeleteConfigInput, ...request.Option) (*groundstation.DeleteConfigOutput, error)
	DeleteConfigRequest(*groundstation.DeleteConfigInput) (*request.Request, *groundstation.DeleteConfigOutput)

	DeleteDataflowEndpointGroup(*groundstation.DeleteDataflowEndpointGroupInput) (*groundstation.DeleteDataflowEndpointGroupOutput, error)
	DeleteDataflowEndpointGroupWithContext(aws.Context, *groundstation.DeleteDataflowEndpointGroupInput, ...request.Option) (*groundstation.DeleteDataflowEndpointGroupOutput, error)
	DeleteDataflowEndpointGroupRequest(*groundstation.DeleteDataflowEndpointGroupInput) (*request.Request, *groundstation.DeleteDataflowEndpointGroupOutput)

	DeleteMissionProfile(*groundstation.DeleteMissionProfileInput) (*groundstation.DeleteMissionProfileOutput, error)
	DeleteMissionProfileWithContext(aws.Context, *groundstation.DeleteMissionProfileInput, ...request.Option) (*groundstation.DeleteMissionProfileOutput, error)
	DeleteMissionProfileRequest(*groundstation.DeleteMissionProfileInput) (*request.Request, *groundstation.DeleteMissionProfileOutput)

	DescribeContact(*groundstation.DescribeContactInput) (*groundstation.DescribeContactOutput, error)
	DescribeContactWithContext(aws.Context, *groundstation.DescribeContactInput, ...request.Option) (*groundstation.DescribeContactOutput, error)
	DescribeContactRequest(*groundstation.DescribeContactInput) (*request.Request, *groundstation.DescribeContactOutput)

	GetConfig(*groundstation.GetConfigInput) (*groundstation.GetConfigOutput, error)
	GetConfigWithContext(aws.Context, *groundstation.GetConfigInput, ...request.Option) (*groundstation.GetConfigOutput, error)
	GetConfigRequest(*groundstation.GetConfigInput) (*request.Request, *groundstation.GetConfigOutput)

	GetDataflowEndpointGroup(*groundstation.GetDataflowEndpointGroupInput) (*groundstation.GetDataflowEndpointGroupOutput, error)
	GetDataflowEndpointGroupWithContext(aws.Context, *groundstation.GetDataflowEndpointGroupInput, ...request.Option) (*groundstation.GetDataflowEndpointGroupOutput, error)
	GetDataflowEndpointGroupRequest(*groundstation.GetDataflowEndpointGroupInput) (*request.Request, *groundstation.GetDataflowEndpointGroupOutput)

	GetMinuteUsage(*groundstation.GetMinuteUsageInput) (*groundstation.GetMinuteUsageOutput, error)
	GetMinuteUsageWithContext(aws.Context, *groundstation.GetMinuteUsageInput, ...request.Option) (*groundstation.GetMinuteUsageOutput, error)
	GetMinuteUsageRequest(*groundstation.GetMinuteUsageInput) (*request.Request, *groundstation.GetMinuteUsageOutput)

	GetMissionProfile(*groundstation.GetMissionProfileInput) (*groundstation.GetMissionProfileOutput, error)
	GetMissionProfileWithContext(aws.Context, *groundstation.GetMissionProfileInput, ...request.Option) (*groundstation.GetMissionProfileOutput, error)
	GetMissionProfileRequest(*groundstation.GetMissionProfileInput) (*request.Request, *groundstation.GetMissionProfileOutput)

	GetSatellite(*groundstation.GetSatelliteInput) (*groundstation.GetSatelliteOutput, error)
	GetSatelliteWithContext(aws.Context, *groundstation.GetSatelliteInput, ...request.Option) (*groundstation.GetSatelliteOutput, error)
	GetSatelliteRequest(*groundstation.GetSatelliteInput) (*request.Request, *groundstation.GetSatelliteOutput)

	ListConfigs(*groundstation.ListConfigsInput) (*groundstation.ListConfigsOutput, error)
	ListConfigsWithContext(aws.Context, *groundstation.ListConfigsInput, ...request.Option) (*groundstation.ListConfigsOutput, error)
	ListConfigsRequest(*groundstation.ListConfigsInput) (*request.Request, *groundstation.ListConfigsOutput)

	ListConfigsPages(*groundstation.ListConfigsInput, func(*groundstation.ListConfigsOutput, bool) bool) error
	ListConfigsPagesWithContext(aws.Context, *groundstation.ListConfigsInput, func(*groundstation.ListConfigsOutput, bool) bool, ...request.Option) error

	ListContacts(*groundstation.ListContactsInput) (*groundstation.ListContactsOutput, error)
	ListContactsWithContext(aws.Context, *groundstation.ListContactsInput, ...request.Option) (*groundstation.ListContactsOutput, error)
	ListContactsRequest(*groundstation.ListContactsInput) (*request.Request, *groundstation.ListContactsOutput)

	ListContactsPages(*groundstation.ListContactsInput, func(*groundstation.ListContactsOutput, bool) bool) error
	ListContactsPagesWithContext(aws.Context, *groundstation.ListContactsInput, func(*groundstation.ListContactsOutput, bool) bool, ...request.Option) error

	ListDataflowEndpointGroups(*groundstation.ListDataflowEndpointGroupsInput) (*groundstation.ListDataflowEndpointGroupsOutput, error)
	ListDataflowEndpointGroupsWithContext(aws.Context, *groundstation.ListDataflowEndpointGroupsInput, ...request.Option) (*groundstation.ListDataflowEndpointGroupsOutput, error)
	ListDataflowEndpointGroupsRequest(*groundstation.ListDataflowEndpointGroupsInput) (*request.Request, *groundstation.ListDataflowEndpointGroupsOutput)

	ListDataflowEndpointGroupsPages(*groundstation.ListDataflowEndpointGroupsInput, func(*groundstation.ListDataflowEndpointGroupsOutput, bool) bool) error
	ListDataflowEndpointGroupsPagesWithContext(aws.Context, *groundstation.ListDataflowEndpointGroupsInput, func(*groundstation.ListDataflowEndpointGroupsOutput, bool) bool, ...request.Option) error

	ListGroundStations(*groundstation.ListGroundStationsInput) (*groundstation.ListGroundStationsOutput, error)
	ListGroundStationsWithContext(aws.Context, *groundstation.ListGroundStationsInput, ...request.Option) (*groundstation.ListGroundStationsOutput, error)
	ListGroundStationsRequest(*groundstation.ListGroundStationsInput) (*request.Request, *groundstation.ListGroundStationsOutput)

	ListGroundStationsPages(*groundstation.ListGroundStationsInput, func(*groundstation.ListGroundStationsOutput, bool) bool) error
	ListGroundStationsPagesWithContext(aws.Context, *groundstation.ListGroundStationsInput, func(*groundstation.ListGroundStationsOutput, bool) bool, ...request.Option) error

	ListMissionProfiles(*groundstation.ListMissionProfilesInput) (*groundstation.ListMissionProfilesOutput, error)
	ListMissionProfilesWithContext(aws.Context, *groundstation.ListMissionProfilesInput, ...request.Option) (*groundstation.ListMissionProfilesOutput, error)
	ListMissionProfilesRequest(*groundstation.ListMissionProfilesInput) (*request.Request, *groundstation.ListMissionProfilesOutput)

	ListMissionProfilesPages(*groundstation.ListMissionProfilesInput, func(*groundstation.ListMissionProfilesOutput, bool) bool) error
	ListMissionProfilesPagesWithContext(aws.Context, *groundstation.ListMissionProfilesInput, func(*groundstation.ListMissionProfilesOutput, bool) bool, ...request.Option) error

	ListSatellites(*groundstation.ListSatellitesInput) (*groundstation.ListSatellitesOutput, error)
	ListSatellitesWithContext(aws.Context, *groundstation.ListSatellitesInput, ...request.Option) (*groundstation.ListSatellitesOutput, error)
	ListSatellitesRequest(*groundstation.ListSatellitesInput) (*request.Request, *groundstation.ListSatellitesOutput)

	ListSatellitesPages(*groundstation.ListSatellitesInput, func(*groundstation.ListSatellitesOutput, bool) bool) error
	ListSatellitesPagesWithContext(aws.Context, *groundstation.ListSatellitesInput, func(*groundstation.ListSatellitesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*groundstation.ListTagsForResourceInput) (*groundstation.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *groundstation.ListTagsForResourceInput, ...request.Option) (*groundstation.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*groundstation.ListTagsForResourceInput) (*request.Request, *groundstation.ListTagsForResourceOutput)

	ReserveContact(*groundstation.ReserveContactInput) (*groundstation.ReserveContactOutput, error)
	ReserveContactWithContext(aws.Context, *groundstation.ReserveContactInput, ...request.Option) (*groundstation.ReserveContactOutput, error)
	ReserveContactRequest(*groundstation.ReserveContactInput) (*request.Request, *groundstation.ReserveContactOutput)

	TagResource(*groundstation.TagResourceInput) (*groundstation.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *groundstation.TagResourceInput, ...request.Option) (*groundstation.TagResourceOutput, error)
	TagResourceRequest(*groundstation.TagResourceInput) (*request.Request, *groundstation.TagResourceOutput)

	UntagResource(*groundstation.UntagResourceInput) (*groundstation.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *groundstation.UntagResourceInput, ...request.Option) (*groundstation.UntagResourceOutput, error)
	UntagResourceRequest(*groundstation.UntagResourceInput) (*request.Request, *groundstation.UntagResourceOutput)

	UpdateConfig(*groundstation.UpdateConfigInput) (*groundstation.UpdateConfigOutput, error)
	UpdateConfigWithContext(aws.Context, *groundstation.UpdateConfigInput, ...request.Option) (*groundstation.UpdateConfigOutput, error)
	UpdateConfigRequest(*groundstation.UpdateConfigInput) (*request.Request, *groundstation.UpdateConfigOutput)

	UpdateMissionProfile(*groundstation.UpdateMissionProfileInput) (*groundstation.UpdateMissionProfileOutput, error)
	UpdateMissionProfileWithContext(aws.Context, *groundstation.UpdateMissionProfileInput, ...request.Option) (*groundstation.UpdateMissionProfileOutput, error)
	UpdateMissionProfileRequest(*groundstation.UpdateMissionProfileInput) (*request.Request, *groundstation.UpdateMissionProfileOutput)
}

var _ GroundStationAPI = (*groundstation.GroundStation)(nil)
