// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"time"
)

type awsRestjson1_serializeOpCancelIngestion struct {
}

func (*awsRestjson1_serializeOpCancelIngestion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelIngestion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelIngestionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelIngestionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelIngestionInput(v *CancelIngestionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	if v.IngestionId == nil || len(*v.IngestionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IngestionId must not be empty")}
	}
	if v.IngestionId != nil {
		if err := encoder.SetURI("IngestionId").String(*v.IngestionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateAccountCustomization struct {
}

func (*awsRestjson1_serializeOpCreateAccountCustomization) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAccountCustomization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAccountCustomizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/customizations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateAccountCustomizationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAccountCustomizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAccountCustomizationInput(v *CreateAccountCustomizationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		encoder.SetQuery("namespace").String(*v.Namespace)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAccountCustomizationInput(v *CreateAccountCustomizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountCustomization != nil {
		ok := object.Key("AccountCustomization")
		if err := awsRestjson1_serializeDocumentAccountCustomization(v.AccountCustomization, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateAccountSubscription struct {
}

func (*awsRestjson1_serializeOpCreateAccountSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAccountSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAccountSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/account/{AwsAccountId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateAccountSubscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAccountSubscriptionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAccountSubscriptionInput(v *CreateAccountSubscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAccountSubscriptionInput(v *CreateAccountSubscriptionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountName != nil {
		ok := object.Key("AccountName")
		ok.String(*v.AccountName)
	}

	if v.ActiveDirectoryName != nil {
		ok := object.Key("ActiveDirectoryName")
		ok.String(*v.ActiveDirectoryName)
	}

	if v.AdminGroup != nil {
		ok := object.Key("AdminGroup")
		if err := awsRestjson1_serializeDocumentGroupsList(v.AdminGroup, ok); err != nil {
			return err
		}
	}

	if len(v.AuthenticationMethod) > 0 {
		ok := object.Key("AuthenticationMethod")
		ok.String(string(v.AuthenticationMethod))
	}

	if v.AuthorGroup != nil {
		ok := object.Key("AuthorGroup")
		if err := awsRestjson1_serializeDocumentGroupsList(v.AuthorGroup, ok); err != nil {
			return err
		}
	}

	if v.ContactNumber != nil {
		ok := object.Key("ContactNumber")
		ok.String(*v.ContactNumber)
	}

	if v.DirectoryId != nil {
		ok := object.Key("DirectoryId")
		ok.String(*v.DirectoryId)
	}

	if len(v.Edition) > 0 {
		ok := object.Key("Edition")
		ok.String(string(v.Edition))
	}

	if v.EmailAddress != nil {
		ok := object.Key("EmailAddress")
		ok.String(*v.EmailAddress)
	}

	if v.FirstName != nil {
		ok := object.Key("FirstName")
		ok.String(*v.FirstName)
	}

	if v.LastName != nil {
		ok := object.Key("LastName")
		ok.String(*v.LastName)
	}

	if v.NotificationEmail != nil {
		ok := object.Key("NotificationEmail")
		ok.String(*v.NotificationEmail)
	}

	if v.ReaderGroup != nil {
		ok := object.Key("ReaderGroup")
		if err := awsRestjson1_serializeDocumentGroupsList(v.ReaderGroup, ok); err != nil {
			return err
		}
	}

	if v.Realm != nil {
		ok := object.Key("Realm")
		ok.String(*v.Realm)
	}

	return nil
}

type awsRestjson1_serializeOpCreateAnalysis struct {
}

func (*awsRestjson1_serializeOpCreateAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateAnalysisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAnalysisInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAnalysisInput(v *CreateAnalysisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAnalysisInput(v *CreateAnalysisInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsRestjson1_serializeDocumentParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.SourceEntity != nil {
		ok := object.Key("SourceEntity")
		if err := awsRestjson1_serializeDocumentAnalysisSourceEntity(v.SourceEntity, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.ThemeArn != nil {
		ok := object.Key("ThemeArn")
		ok.String(*v.ThemeArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateDashboard struct {
}

func (*awsRestjson1_serializeOpCreateDashboard) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDashboard) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDashboardInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDashboardInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDashboardInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDashboardInput(v *CreateDashboardInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDashboardInput(v *CreateDashboardInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DashboardPublishOptions != nil {
		ok := object.Key("DashboardPublishOptions")
		if err := awsRestjson1_serializeDocumentDashboardPublishOptions(v.DashboardPublishOptions, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsRestjson1_serializeDocumentParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.SourceEntity != nil {
		ok := object.Key("SourceEntity")
		if err := awsRestjson1_serializeDocumentDashboardSourceEntity(v.SourceEntity, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.ThemeArn != nil {
		ok := object.Key("ThemeArn")
		ok.String(*v.ThemeArn)
	}

	if v.VersionDescription != nil {
		ok := object.Key("VersionDescription")
		ok.String(*v.VersionDescription)
	}

	return nil
}

type awsRestjson1_serializeOpCreateDataSet struct {
}

func (*awsRestjson1_serializeOpCreateDataSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDataSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDataSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDataSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDataSetInput(v *CreateDataSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDataSetInput(v *CreateDataSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnGroups != nil {
		ok := object.Key("ColumnGroups")
		if err := awsRestjson1_serializeDocumentColumnGroupList(v.ColumnGroups, ok); err != nil {
			return err
		}
	}

	if v.ColumnLevelPermissionRules != nil {
		ok := object.Key("ColumnLevelPermissionRules")
		if err := awsRestjson1_serializeDocumentColumnLevelPermissionRuleList(v.ColumnLevelPermissionRules, ok); err != nil {
			return err
		}
	}

	if v.DataSetId != nil {
		ok := object.Key("DataSetId")
		ok.String(*v.DataSetId)
	}

	if v.DataSetUsageConfiguration != nil {
		ok := object.Key("DataSetUsageConfiguration")
		if err := awsRestjson1_serializeDocumentDataSetUsageConfiguration(v.DataSetUsageConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FieldFolders != nil {
		ok := object.Key("FieldFolders")
		if err := awsRestjson1_serializeDocumentFieldFolderMap(v.FieldFolders, ok); err != nil {
			return err
		}
	}

	if len(v.ImportMode) > 0 {
		ok := object.Key("ImportMode")
		ok.String(string(v.ImportMode))
	}

	if v.LogicalTableMap != nil {
		ok := object.Key("LogicalTableMap")
		if err := awsRestjson1_serializeDocumentLogicalTableMap(v.LogicalTableMap, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.PhysicalTableMap != nil {
		ok := object.Key("PhysicalTableMap")
		if err := awsRestjson1_serializeDocumentPhysicalTableMap(v.PhysicalTableMap, ok); err != nil {
			return err
		}
	}

	if v.RowLevelPermissionDataSet != nil {
		ok := object.Key("RowLevelPermissionDataSet")
		if err := awsRestjson1_serializeDocumentRowLevelPermissionDataSet(v.RowLevelPermissionDataSet, ok); err != nil {
			return err
		}
	}

	if v.RowLevelPermissionTagConfiguration != nil {
		ok := object.Key("RowLevelPermissionTagConfiguration")
		if err := awsRestjson1_serializeDocumentRowLevelPermissionTagConfiguration(v.RowLevelPermissionTagConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDataSource struct {
}

func (*awsRestjson1_serializeOpCreateDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDataSourceInput(v *CreateDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDataSourceInput(v *CreateDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentDataSourceCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.DataSourceId != nil {
		ok := object.Key("DataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.DataSourceParameters != nil {
		ok := object.Key("DataSourceParameters")
		if err := awsRestjson1_serializeDocumentDataSourceParameters(v.DataSourceParameters, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.SslProperties != nil {
		ok := object.Key("SslProperties")
		if err := awsRestjson1_serializeDocumentSslProperties(v.SslProperties, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.VpcConnectionProperties != nil {
		ok := object.Key("VpcConnectionProperties")
		if err := awsRestjson1_serializeDocumentVpcConnectionProperties(v.VpcConnectionProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateFolder struct {
}

func (*awsRestjson1_serializeOpCreateFolder) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFolder) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFolderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateFolderInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFolderInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFolderInput(v *CreateFolderInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFolderInput(v *CreateFolderInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FolderType) > 0 {
		ok := object.Key("FolderType")
		ok.String(string(v.FolderType))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ParentFolderArn != nil {
		ok := object.Key("ParentFolderArn")
		ok.String(*v.ParentFolderArn)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateFolderMembership struct {
}

func (*awsRestjson1_serializeOpCreateFolderMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFolderMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFolderMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateFolderMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFolderMembershipInput(v *CreateFolderMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	if v.MemberId == nil || len(*v.MemberId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberId must not be empty")}
	}
	if v.MemberId != nil {
		if err := encoder.SetURI("MemberId").String(*v.MemberId); err != nil {
			return err
		}
	}

	if len(v.MemberType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberType must not be empty")}
	}
	if len(v.MemberType) > 0 {
		if err := encoder.SetURI("MemberType").String(string(v.MemberType)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateGroup struct {
}

func (*awsRestjson1_serializeOpCreateGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGroupInput(v *CreateGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateGroupInput(v *CreateGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateGroupMembership struct {
}

func (*awsRestjson1_serializeOpCreateGroupMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGroupMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGroupMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateGroupMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGroupMembershipInput(v *CreateGroupMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.MemberName == nil || len(*v.MemberName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberName must not be empty")}
	}
	if v.MemberName != nil {
		if err := encoder.SetURI("MemberName").String(*v.MemberName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateIAMPolicyAssignment struct {
}

func (*awsRestjson1_serializeOpCreateIAMPolicyAssignment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateIAMPolicyAssignment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIAMPolicyAssignmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateIAMPolicyAssignmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateIAMPolicyAssignmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateIAMPolicyAssignmentInput(v *CreateIAMPolicyAssignmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateIAMPolicyAssignmentInput(v *CreateIAMPolicyAssignmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssignmentName != nil {
		ok := object.Key("AssignmentName")
		ok.String(*v.AssignmentName)
	}

	if len(v.AssignmentStatus) > 0 {
		ok := object.Key("AssignmentStatus")
		ok.String(string(v.AssignmentStatus))
	}

	if v.Identities != nil {
		ok := object.Key("Identities")
		if err := awsRestjson1_serializeDocumentIdentityMap(v.Identities, ok); err != nil {
			return err
		}
	}

	if v.PolicyArn != nil {
		ok := object.Key("PolicyArn")
		ok.String(*v.PolicyArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateIngestion struct {
}

func (*awsRestjson1_serializeOpCreateIngestion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateIngestion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIngestionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateIngestionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateIngestionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateIngestionInput(v *CreateIngestionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	if v.IngestionId == nil || len(*v.IngestionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IngestionId must not be empty")}
	}
	if v.IngestionId != nil {
		if err := encoder.SetURI("IngestionId").String(*v.IngestionId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateIngestionInput(v *CreateIngestionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.IngestionType) > 0 {
		ok := object.Key("IngestionType")
		ok.String(string(v.IngestionType))
	}

	return nil
}

type awsRestjson1_serializeOpCreateNamespace struct {
}

func (*awsRestjson1_serializeOpCreateNamespace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateNamespace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateNamespaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateNamespaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateNamespaceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateNamespaceInput(v *CreateNamespaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateNamespaceInput(v *CreateNamespaceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.IdentityStore) > 0 {
		ok := object.Key("IdentityStore")
		ok.String(string(v.IdentityStore))
	}

	if v.Namespace != nil {
		ok := object.Key("Namespace")
		ok.String(*v.Namespace)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateTemplate struct {
}

func (*awsRestjson1_serializeOpCreateTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTemplateInput(v *CreateTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTemplateInput(v *CreateTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.SourceEntity != nil {
		ok := object.Key("SourceEntity")
		if err := awsRestjson1_serializeDocumentTemplateSourceEntity(v.SourceEntity, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VersionDescription != nil {
		ok := object.Key("VersionDescription")
		ok.String(*v.VersionDescription)
	}

	return nil
}

type awsRestjson1_serializeOpCreateTemplateAlias struct {
}

func (*awsRestjson1_serializeOpCreateTemplateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTemplateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTemplateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTemplateAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTemplateAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTemplateAliasInput(v *CreateTemplateAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTemplateAliasInput(v *CreateTemplateAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TemplateVersionNumber != nil {
		ok := object.Key("TemplateVersionNumber")
		ok.Long(*v.TemplateVersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpCreateTheme struct {
}

func (*awsRestjson1_serializeOpCreateTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateThemeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateThemeInput(v *CreateThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateThemeInput(v *CreateThemeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseThemeId != nil {
		ok := object.Key("BaseThemeId")
		ok.String(*v.BaseThemeId)
	}

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		if err := awsRestjson1_serializeDocumentThemeConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Permissions != nil {
		ok := object.Key("Permissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.Permissions, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VersionDescription != nil {
		ok := object.Key("VersionDescription")
		ok.String(*v.VersionDescription)
	}

	return nil
}

type awsRestjson1_serializeOpCreateThemeAlias struct {
}

func (*awsRestjson1_serializeOpCreateThemeAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateThemeAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateThemeAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateThemeAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateThemeAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateThemeAliasInput(v *CreateThemeAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateThemeAliasInput(v *CreateThemeAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ThemeVersionNumber != nil {
		ok := object.Key("ThemeVersionNumber")
		ok.Long(*v.ThemeVersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAccountCustomization struct {
}

func (*awsRestjson1_serializeOpDeleteAccountCustomization) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAccountCustomization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAccountCustomizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/customizations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAccountCustomizationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAccountCustomizationInput(v *DeleteAccountCustomizationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		encoder.SetQuery("namespace").String(*v.Namespace)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAnalysis struct {
}

func (*awsRestjson1_serializeOpDeleteAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAnalysisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAnalysisInput(v *DeleteAnalysisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ForceDeleteWithoutRecovery {
		encoder.SetQuery("force-delete-without-recovery").Boolean(v.ForceDeleteWithoutRecovery)
	}

	if v.RecoveryWindowInDays != nil {
		encoder.SetQuery("recovery-window-in-days").Long(*v.RecoveryWindowInDays)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDashboard struct {
}

func (*awsRestjson1_serializeOpDeleteDashboard) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDashboard) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDashboardInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDashboardInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDashboardInput(v *DeleteDashboardInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataSet struct {
}

func (*awsRestjson1_serializeOpDeleteDataSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDataSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDataSetInput(v *DeleteDataSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataSource struct {
}

func (*awsRestjson1_serializeOpDeleteDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources/{DataSourceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDataSourceInput(v *DeleteDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("DataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFolder struct {
}

func (*awsRestjson1_serializeOpDeleteFolder) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFolder) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFolderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFolderInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFolderInput(v *DeleteFolderInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFolderMembership struct {
}

func (*awsRestjson1_serializeOpDeleteFolderMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFolderMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFolderMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFolderMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFolderMembershipInput(v *DeleteFolderMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	if v.MemberId == nil || len(*v.MemberId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberId must not be empty")}
	}
	if v.MemberId != nil {
		if err := encoder.SetURI("MemberId").String(*v.MemberId); err != nil {
			return err
		}
	}

	if len(v.MemberType) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberType must not be empty")}
	}
	if len(v.MemberType) > 0 {
		if err := encoder.SetURI("MemberType").String(string(v.MemberType)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGroup struct {
}

func (*awsRestjson1_serializeOpDeleteGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGroupInput(v *DeleteGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGroupMembership struct {
}

func (*awsRestjson1_serializeOpDeleteGroupMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGroupMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGroupMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGroupMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGroupMembershipInput(v *DeleteGroupMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.MemberName == nil || len(*v.MemberName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberName must not be empty")}
	}
	if v.MemberName != nil {
		if err := encoder.SetURI("MemberName").String(*v.MemberName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteIAMPolicyAssignment struct {
}

func (*awsRestjson1_serializeOpDeleteIAMPolicyAssignment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteIAMPolicyAssignment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIAMPolicyAssignmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespace/{Namespace}/iam-policy-assignments/{AssignmentName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteIAMPolicyAssignmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteIAMPolicyAssignmentInput(v *DeleteIAMPolicyAssignmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssignmentName == nil || len(*v.AssignmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssignmentName must not be empty")}
	}
	if v.AssignmentName != nil {
		if err := encoder.SetURI("AssignmentName").String(*v.AssignmentName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteNamespace struct {
}

func (*awsRestjson1_serializeOpDeleteNamespace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteNamespace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteNamespaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteNamespaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteNamespaceInput(v *DeleteNamespaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTemplate struct {
}

func (*awsRestjson1_serializeOpDeleteTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTemplateInput(v *DeleteTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTemplateAlias struct {
}

func (*awsRestjson1_serializeOpDeleteTemplateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTemplateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTemplateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTemplateAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTemplateAliasInput(v *DeleteTemplateAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTheme struct {
}

func (*awsRestjson1_serializeOpDeleteTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteThemeInput(v *DeleteThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteThemeAlias struct {
}

func (*awsRestjson1_serializeOpDeleteThemeAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteThemeAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteThemeAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteThemeAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteThemeAliasInput(v *DeleteThemeAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteUser struct {
}

func (*awsRestjson1_serializeOpDeleteUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteUserInput(v *DeleteUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.UserName == nil || len(*v.UserName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserName must not be empty")}
	}
	if v.UserName != nil {
		if err := encoder.SetURI("UserName").String(*v.UserName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteUserByPrincipalId struct {
}

func (*awsRestjson1_serializeOpDeleteUserByPrincipalId) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteUserByPrincipalId) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserByPrincipalIdInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/user-principals/{PrincipalId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteUserByPrincipalIdInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteUserByPrincipalIdInput(v *DeleteUserByPrincipalIdInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.PrincipalId == nil || len(*v.PrincipalId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member PrincipalId must not be empty")}
	}
	if v.PrincipalId != nil {
		if err := encoder.SetURI("PrincipalId").String(*v.PrincipalId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAccountCustomization struct {
}

func (*awsRestjson1_serializeOpDescribeAccountCustomization) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAccountCustomization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAccountCustomizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/customizations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAccountCustomizationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAccountCustomizationInput(v *DescribeAccountCustomizationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		encoder.SetQuery("namespace").String(*v.Namespace)
	}

	if v.Resolved {
		encoder.SetQuery("resolved").Boolean(v.Resolved)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAccountSettings struct {
}

func (*awsRestjson1_serializeOpDescribeAccountSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAccountSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAccountSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAccountSettingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAccountSettingsInput(v *DescribeAccountSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAccountSubscription struct {
}

func (*awsRestjson1_serializeOpDescribeAccountSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAccountSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAccountSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/account/{AwsAccountId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAccountSubscriptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAccountSubscriptionInput(v *DescribeAccountSubscriptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAnalysis struct {
}

func (*awsRestjson1_serializeOpDescribeAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAnalysisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAnalysisInput(v *DescribeAnalysisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAnalysisPermissions struct {
}

func (*awsRestjson1_serializeOpDescribeAnalysisPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAnalysisPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAnalysisPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAnalysisPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAnalysisPermissionsInput(v *DescribeAnalysisPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDashboard struct {
}

func (*awsRestjson1_serializeOpDescribeDashboard) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDashboard) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDashboardInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDashboardInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDashboardInput(v *DescribeDashboardInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName != nil {
		encoder.SetQuery("alias-name").String(*v.AliasName)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDashboardPermissions struct {
}

func (*awsRestjson1_serializeOpDescribeDashboardPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDashboardPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDashboardPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDashboardPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDashboardPermissionsInput(v *DescribeDashboardPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDataSet struct {
}

func (*awsRestjson1_serializeOpDescribeDataSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDataSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDataSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDataSetInput(v *DescribeDataSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDataSetPermissions struct {
}

func (*awsRestjson1_serializeOpDescribeDataSetPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDataSetPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSetPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDataSetPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDataSetPermissionsInput(v *DescribeDataSetPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDataSource struct {
}

func (*awsRestjson1_serializeOpDescribeDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources/{DataSourceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDataSourceInput(v *DescribeDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("DataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDataSourcePermissions struct {
}

func (*awsRestjson1_serializeOpDescribeDataSourcePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDataSourcePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataSourcePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDataSourcePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDataSourcePermissionsInput(v *DescribeDataSourcePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("DataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFolder struct {
}

func (*awsRestjson1_serializeOpDescribeFolder) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFolder) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFolderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFolderInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFolderInput(v *DescribeFolderInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFolderPermissions struct {
}

func (*awsRestjson1_serializeOpDescribeFolderPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFolderPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFolderPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFolderPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFolderPermissionsInput(v *DescribeFolderPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFolderResolvedPermissions struct {
}

func (*awsRestjson1_serializeOpDescribeFolderResolvedPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFolderResolvedPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFolderResolvedPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}/resolved-permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFolderResolvedPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFolderResolvedPermissionsInput(v *DescribeFolderResolvedPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeGroup struct {
}

func (*awsRestjson1_serializeOpDescribeGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeGroupInput(v *DescribeGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeGroupMembership struct {
}

func (*awsRestjson1_serializeOpDescribeGroupMembership) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeGroupMembership) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGroupMembershipInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeGroupMembershipInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeGroupMembershipInput(v *DescribeGroupMembershipInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.MemberName == nil || len(*v.MemberName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MemberName must not be empty")}
	}
	if v.MemberName != nil {
		if err := encoder.SetURI("MemberName").String(*v.MemberName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeIAMPolicyAssignment struct {
}

func (*awsRestjson1_serializeOpDescribeIAMPolicyAssignment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeIAMPolicyAssignment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIAMPolicyAssignmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeIAMPolicyAssignmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeIAMPolicyAssignmentInput(v *DescribeIAMPolicyAssignmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssignmentName == nil || len(*v.AssignmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssignmentName must not be empty")}
	}
	if v.AssignmentName != nil {
		if err := encoder.SetURI("AssignmentName").String(*v.AssignmentName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeIngestion struct {
}

func (*awsRestjson1_serializeOpDescribeIngestion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeIngestion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIngestionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeIngestionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeIngestionInput(v *DescribeIngestionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	if v.IngestionId == nil || len(*v.IngestionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IngestionId must not be empty")}
	}
	if v.IngestionId != nil {
		if err := encoder.SetURI("IngestionId").String(*v.IngestionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeIpRestriction struct {
}

func (*awsRestjson1_serializeOpDescribeIpRestriction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeIpRestriction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIpRestrictionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/ip-restriction")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeIpRestrictionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeIpRestrictionInput(v *DescribeIpRestrictionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeNamespace struct {
}

func (*awsRestjson1_serializeOpDescribeNamespace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeNamespace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNamespaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeNamespaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeNamespaceInput(v *DescribeNamespaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTemplate struct {
}

func (*awsRestjson1_serializeOpDescribeTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTemplateInput(v *DescribeTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName != nil {
		encoder.SetQuery("alias-name").String(*v.AliasName)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTemplateAlias struct {
}

func (*awsRestjson1_serializeOpDescribeTemplateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTemplateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTemplateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTemplateAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTemplateAliasInput(v *DescribeTemplateAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTemplatePermissions struct {
}

func (*awsRestjson1_serializeOpDescribeTemplatePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTemplatePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTemplatePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTemplatePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTemplatePermissionsInput(v *DescribeTemplatePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTheme struct {
}

func (*awsRestjson1_serializeOpDescribeTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeThemeInput(v *DescribeThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName != nil {
		encoder.SetQuery("alias-name").String(*v.AliasName)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	if v.VersionNumber != nil {
		encoder.SetQuery("version-number").Long(*v.VersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeThemeAlias struct {
}

func (*awsRestjson1_serializeOpDescribeThemeAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeThemeAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeThemeAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeThemeAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeThemeAliasInput(v *DescribeThemeAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeThemePermissions struct {
}

func (*awsRestjson1_serializeOpDescribeThemePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeThemePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeThemePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeThemePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeThemePermissionsInput(v *DescribeThemePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeUser struct {
}

func (*awsRestjson1_serializeOpDescribeUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeUserInput(v *DescribeUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.UserName == nil || len(*v.UserName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserName must not be empty")}
	}
	if v.UserName != nil {
		if err := encoder.SetURI("UserName").String(*v.UserName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGenerateEmbedUrlForAnonymousUser struct {
}

func (*awsRestjson1_serializeOpGenerateEmbedUrlForAnonymousUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGenerateEmbedUrlForAnonymousUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GenerateEmbedUrlForAnonymousUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/embed-url/anonymous-user")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGenerateEmbedUrlForAnonymousUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGenerateEmbedUrlForAnonymousUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGenerateEmbedUrlForAnonymousUserInput(v *GenerateEmbedUrlForAnonymousUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGenerateEmbedUrlForAnonymousUserInput(v *GenerateEmbedUrlForAnonymousUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedDomains != nil {
		ok := object.Key("AllowedDomains")
		if err := awsRestjson1_serializeDocumentStringList(v.AllowedDomains, ok); err != nil {
			return err
		}
	}

	if v.AuthorizedResourceArns != nil {
		ok := object.Key("AuthorizedResourceArns")
		if err := awsRestjson1_serializeDocumentArnList(v.AuthorizedResourceArns, ok); err != nil {
			return err
		}
	}

	if v.ExperienceConfiguration != nil {
		ok := object.Key("ExperienceConfiguration")
		if err := awsRestjson1_serializeDocumentAnonymousUserEmbeddingExperienceConfiguration(v.ExperienceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		ok := object.Key("Namespace")
		ok.String(*v.Namespace)
	}

	if v.SessionLifetimeInMinutes != nil {
		ok := object.Key("SessionLifetimeInMinutes")
		ok.Long(*v.SessionLifetimeInMinutes)
	}

	if v.SessionTags != nil {
		ok := object.Key("SessionTags")
		if err := awsRestjson1_serializeDocumentSessionTagList(v.SessionTags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGenerateEmbedUrlForRegisteredUser struct {
}

func (*awsRestjson1_serializeOpGenerateEmbedUrlForRegisteredUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGenerateEmbedUrlForRegisteredUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GenerateEmbedUrlForRegisteredUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/embed-url/registered-user")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGenerateEmbedUrlForRegisteredUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGenerateEmbedUrlForRegisteredUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGenerateEmbedUrlForRegisteredUserInput(v *GenerateEmbedUrlForRegisteredUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGenerateEmbedUrlForRegisteredUserInput(v *GenerateEmbedUrlForRegisteredUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedDomains != nil {
		ok := object.Key("AllowedDomains")
		if err := awsRestjson1_serializeDocumentStringList(v.AllowedDomains, ok); err != nil {
			return err
		}
	}

	if v.ExperienceConfiguration != nil {
		ok := object.Key("ExperienceConfiguration")
		if err := awsRestjson1_serializeDocumentRegisteredUserEmbeddingExperienceConfiguration(v.ExperienceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SessionLifetimeInMinutes != nil {
		ok := object.Key("SessionLifetimeInMinutes")
		ok.Long(*v.SessionLifetimeInMinutes)
	}

	if v.UserArn != nil {
		ok := object.Key("UserArn")
		ok.String(*v.UserArn)
	}

	return nil
}

type awsRestjson1_serializeOpGetDashboardEmbedUrl struct {
}

func (*awsRestjson1_serializeOpGetDashboardEmbedUrl) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDashboardEmbedUrl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDashboardEmbedUrlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/embed-url")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDashboardEmbedUrlInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDashboardEmbedUrlInput(v *GetDashboardEmbedUrlInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AdditionalDashboardIds != nil {
		for i := range v.AdditionalDashboardIds {
			encoder.AddQuery("additional-dashboard-ids").String(v.AdditionalDashboardIds[i])
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if len(v.IdentityType) > 0 {
		encoder.SetQuery("creds-type").String(string(v.IdentityType))
	}

	if v.Namespace != nil {
		encoder.SetQuery("namespace").String(*v.Namespace)
	}

	if v.ResetDisabled {
		encoder.SetQuery("reset-disabled").Boolean(v.ResetDisabled)
	}

	if v.SessionLifetimeInMinutes != nil {
		encoder.SetQuery("session-lifetime").Long(*v.SessionLifetimeInMinutes)
	}

	if v.StatePersistenceEnabled {
		encoder.SetQuery("state-persistence-enabled").Boolean(v.StatePersistenceEnabled)
	}

	if v.UndoRedoDisabled {
		encoder.SetQuery("undo-redo-disabled").Boolean(v.UndoRedoDisabled)
	}

	if v.UserArn != nil {
		encoder.SetQuery("user-arn").String(*v.UserArn)
	}

	return nil
}

type awsRestjson1_serializeOpGetSessionEmbedUrl struct {
}

func (*awsRestjson1_serializeOpGetSessionEmbedUrl) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSessionEmbedUrl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSessionEmbedUrlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/session-embed-url")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSessionEmbedUrlInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSessionEmbedUrlInput(v *GetSessionEmbedUrlInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.EntryPoint != nil {
		encoder.SetQuery("entry-point").String(*v.EntryPoint)
	}

	if v.SessionLifetimeInMinutes != nil {
		encoder.SetQuery("session-lifetime").Long(*v.SessionLifetimeInMinutes)
	}

	if v.UserArn != nil {
		encoder.SetQuery("user-arn").String(*v.UserArn)
	}

	return nil
}

type awsRestjson1_serializeOpListAnalyses struct {
}

func (*awsRestjson1_serializeOpListAnalyses) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAnalyses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAnalysesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAnalysesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAnalysesInput(v *ListAnalysesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDashboards struct {
}

func (*awsRestjson1_serializeOpListDashboards) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDashboards) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDashboardsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDashboardsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDashboardsInput(v *ListDashboardsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDashboardVersions struct {
}

func (*awsRestjson1_serializeOpListDashboardVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDashboardVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDashboardVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDashboardVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDashboardVersionsInput(v *ListDashboardVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDataSets struct {
}

func (*awsRestjson1_serializeOpListDataSets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDataSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDataSetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDataSetsInput(v *ListDataSetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDataSources struct {
}

func (*awsRestjson1_serializeOpListDataSources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDataSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDataSourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDataSourcesInput(v *ListDataSourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFolderMembers struct {
}

func (*awsRestjson1_serializeOpListFolderMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFolderMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFolderMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}/members")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFolderMembersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFolderMembersInput(v *ListFolderMembersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFolders struct {
}

func (*awsRestjson1_serializeOpListFolders) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFolders) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFoldersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFoldersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFoldersInput(v *ListFoldersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGroupMemberships struct {
}

func (*awsRestjson1_serializeOpListGroupMemberships) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGroupMemberships) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGroupMembershipsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGroupMembershipsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGroupMembershipsInput(v *ListGroupMembershipsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGroups struct {
}

func (*awsRestjson1_serializeOpListGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGroupsInput(v *ListGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListIAMPolicyAssignments struct {
}

func (*awsRestjson1_serializeOpListIAMPolicyAssignments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIAMPolicyAssignments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIAMPolicyAssignmentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIAMPolicyAssignmentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListIAMPolicyAssignmentsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIAMPolicyAssignmentsInput(v *ListIAMPolicyAssignmentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListIAMPolicyAssignmentsInput(v *ListIAMPolicyAssignmentsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AssignmentStatus) > 0 {
		ok := object.Key("AssignmentStatus")
		ok.String(string(v.AssignmentStatus))
	}

	return nil
}

type awsRestjson1_serializeOpListIAMPolicyAssignmentsForUser struct {
}

func (*awsRestjson1_serializeOpListIAMPolicyAssignmentsForUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIAMPolicyAssignmentsForUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIAMPolicyAssignmentsForUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/iam-policy-assignments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIAMPolicyAssignmentsForUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIAMPolicyAssignmentsForUserInput(v *ListIAMPolicyAssignmentsForUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.UserName == nil || len(*v.UserName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserName must not be empty")}
	}
	if v.UserName != nil {
		if err := encoder.SetURI("UserName").String(*v.UserName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListIngestions struct {
}

func (*awsRestjson1_serializeOpListIngestions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIngestions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIngestionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIngestionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIngestionsInput(v *ListIngestionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListNamespaces struct {
}

func (*awsRestjson1_serializeOpListNamespaces) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListNamespaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListNamespacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListNamespacesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListNamespacesInput(v *ListNamespacesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/resources/{ResourceArn}/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTemplateAliases struct {
}

func (*awsRestjson1_serializeOpListTemplateAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTemplateAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTemplateAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/aliases")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTemplateAliasesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTemplateAliasesInput(v *ListTemplateAliasesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-result").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTemplates struct {
}

func (*awsRestjson1_serializeOpListTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTemplatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTemplatesInput(v *ListTemplatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-result").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTemplateVersions struct {
}

func (*awsRestjson1_serializeOpListTemplateVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTemplateVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTemplateVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTemplateVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTemplateVersionsInput(v *ListTemplateVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListThemeAliases struct {
}

func (*awsRestjson1_serializeOpListThemeAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThemeAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThemeAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/aliases")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThemeAliasesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThemeAliasesInput(v *ListThemeAliasesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-result").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListThemes struct {
}

func (*awsRestjson1_serializeOpListThemes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThemes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThemesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThemesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThemesInput(v *ListThemesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if len(v.Type) > 0 {
		encoder.SetQuery("type").String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpListThemeVersions struct {
}

func (*awsRestjson1_serializeOpListThemeVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThemeVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThemeVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThemeVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThemeVersionsInput(v *ListThemeVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListUserGroups struct {
}

func (*awsRestjson1_serializeOpListUserGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListUserGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUserGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListUserGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListUserGroupsInput(v *ListUserGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.UserName == nil || len(*v.UserName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserName must not be empty")}
	}
	if v.UserName != nil {
		if err := encoder.SetURI("UserName").String(*v.UserName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListUsers struct {
}

func (*awsRestjson1_serializeOpListUsers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListUsers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUsersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListUsersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListUsersInput(v *ListUsersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpRegisterUser struct {
}

func (*awsRestjson1_serializeOpRegisterUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRegisterUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRegisterUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRegisterUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRegisterUserInput(v *RegisterUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRegisterUserInput(v *RegisterUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomFederationProviderUrl != nil {
		ok := object.Key("CustomFederationProviderUrl")
		ok.String(*v.CustomFederationProviderUrl)
	}

	if v.CustomPermissionsName != nil {
		ok := object.Key("CustomPermissionsName")
		ok.String(*v.CustomPermissionsName)
	}

	if v.Email != nil {
		ok := object.Key("Email")
		ok.String(*v.Email)
	}

	if v.ExternalLoginFederationProviderType != nil {
		ok := object.Key("ExternalLoginFederationProviderType")
		ok.String(*v.ExternalLoginFederationProviderType)
	}

	if v.ExternalLoginId != nil {
		ok := object.Key("ExternalLoginId")
		ok.String(*v.ExternalLoginId)
	}

	if v.IamArn != nil {
		ok := object.Key("IamArn")
		ok.String(*v.IamArn)
	}

	if len(v.IdentityType) > 0 {
		ok := object.Key("IdentityType")
		ok.String(string(v.IdentityType))
	}

	if v.SessionName != nil {
		ok := object.Key("SessionName")
		ok.String(*v.SessionName)
	}

	if v.UserName != nil {
		ok := object.Key("UserName")
		ok.String(*v.UserName)
	}

	if len(v.UserRole) > 0 {
		ok := object.Key("UserRole")
		ok.String(string(v.UserRole))
	}

	return nil
}

type awsRestjson1_serializeOpRestoreAnalysis struct {
}

func (*awsRestjson1_serializeOpRestoreAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRestoreAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestoreAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/restore/analyses/{AnalysisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRestoreAnalysisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRestoreAnalysisInput(v *RestoreAnalysisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSearchAnalyses struct {
}

func (*awsRestjson1_serializeOpSearchAnalyses) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchAnalyses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchAnalysesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/search/analyses")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchAnalysesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchAnalysesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchAnalysesInput(v *SearchAnalysesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchAnalysesInput(v *SearchAnalysesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentAnalysisSearchFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpSearchDashboards struct {
}

func (*awsRestjson1_serializeOpSearchDashboards) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchDashboards) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchDashboardsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/search/dashboards")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchDashboardsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchDashboardsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchDashboardsInput(v *SearchDashboardsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchDashboardsInput(v *SearchDashboardsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentDashboardSearchFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpSearchFolders struct {
}

func (*awsRestjson1_serializeOpSearchFolders) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchFolders) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchFoldersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/search/folders")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchFoldersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchFoldersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchFoldersInput(v *SearchFoldersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchFoldersInput(v *SearchFoldersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentFolderSearchFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpSearchGroups struct {
}

func (*awsRestjson1_serializeOpSearchGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups-search")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchGroupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchGroupsInput(v *SearchGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchGroupsInput(v *SearchGroupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentGroupSearchFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/resources/{ResourceArn}/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/resources/{ResourceArn}/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("keys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAccountCustomization struct {
}

func (*awsRestjson1_serializeOpUpdateAccountCustomization) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAccountCustomization) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAccountCustomizationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/customizations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAccountCustomizationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAccountCustomizationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAccountCustomizationInput(v *UpdateAccountCustomizationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace != nil {
		encoder.SetQuery("namespace").String(*v.Namespace)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAccountCustomizationInput(v *UpdateAccountCustomizationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountCustomization != nil {
		ok := object.Key("AccountCustomization")
		if err := awsRestjson1_serializeDocumentAccountCustomization(v.AccountCustomization, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAccountSettings struct {
}

func (*awsRestjson1_serializeOpUpdateAccountSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAccountSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAccountSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAccountSettingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAccountSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAccountSettingsInput(v *UpdateAccountSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAccountSettingsInput(v *UpdateAccountSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultNamespace != nil {
		ok := object.Key("DefaultNamespace")
		ok.String(*v.DefaultNamespace)
	}

	if v.NotificationEmail != nil {
		ok := object.Key("NotificationEmail")
		ok.String(*v.NotificationEmail)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAnalysis struct {
}

func (*awsRestjson1_serializeOpUpdateAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAnalysisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAnalysisInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAnalysisInput(v *UpdateAnalysisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAnalysisInput(v *UpdateAnalysisInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsRestjson1_serializeDocumentParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.SourceEntity != nil {
		ok := object.Key("SourceEntity")
		if err := awsRestjson1_serializeDocumentAnalysisSourceEntity(v.SourceEntity, ok); err != nil {
			return err
		}
	}

	if v.ThemeArn != nil {
		ok := object.Key("ThemeArn")
		ok.String(*v.ThemeArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAnalysisPermissions struct {
}

func (*awsRestjson1_serializeOpUpdateAnalysisPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAnalysisPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAnalysisPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAnalysisPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAnalysisPermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAnalysisPermissionsInput(v *UpdateAnalysisPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AnalysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("AnalysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAnalysisPermissionsInput(v *UpdateAnalysisPermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDashboard struct {
}

func (*awsRestjson1_serializeOpUpdateDashboard) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDashboard) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDashboardInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDashboardInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDashboardInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDashboardInput(v *UpdateDashboardInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDashboardInput(v *UpdateDashboardInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DashboardPublishOptions != nil {
		ok := object.Key("DashboardPublishOptions")
		if err := awsRestjson1_serializeDocumentDashboardPublishOptions(v.DashboardPublishOptions, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsRestjson1_serializeDocumentParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.SourceEntity != nil {
		ok := object.Key("SourceEntity")
		if err := awsRestjson1_serializeDocumentDashboardSourceEntity(v.SourceEntity, ok); err != nil {
			return err
		}
	}

	if v.ThemeArn != nil {
		ok := object.Key("ThemeArn")
		ok.String(*v.ThemeArn)
	}

	if v.VersionDescription != nil {
		ok := object.Key("VersionDescription")
		ok.String(*v.VersionDescription)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDashboardPermissions struct {
}

func (*awsRestjson1_serializeOpUpdateDashboardPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDashboardPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDashboardPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDashboardPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDashboardPermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDashboardPermissionsInput(v *UpdateDashboardPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDashboardPermissionsInput(v *UpdateDashboardPermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantLinkPermissions != nil {
		ok := object.Key("GrantLinkPermissions")
		if err := awsRestjson1_serializeDocumentUpdateLinkPermissionList(v.GrantLinkPermissions, ok); err != nil {
			return err
		}
	}

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokeLinkPermissions != nil {
		ok := object.Key("RevokeLinkPermissions")
		if err := awsRestjson1_serializeDocumentUpdateLinkPermissionList(v.RevokeLinkPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDashboardPublishedVersion struct {
}

func (*awsRestjson1_serializeOpUpdateDashboardPublishedVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDashboardPublishedVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDashboardPublishedVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions/{VersionNumber}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDashboardPublishedVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDashboardPublishedVersionInput(v *UpdateDashboardPublishedVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DashboardId == nil || len(*v.DashboardId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DashboardId must not be empty")}
	}
	if v.DashboardId != nil {
		if err := encoder.SetURI("DashboardId").String(*v.DashboardId); err != nil {
			return err
		}
	}

	if v.VersionNumber == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member VersionNumber must not be empty")}
	}
	if v.VersionNumber != nil {
		if err := encoder.SetURI("VersionNumber").Long(*v.VersionNumber); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataSet struct {
}

func (*awsRestjson1_serializeOpUpdateDataSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataSetInput(v *UpdateDataSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataSetInput(v *UpdateDataSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnGroups != nil {
		ok := object.Key("ColumnGroups")
		if err := awsRestjson1_serializeDocumentColumnGroupList(v.ColumnGroups, ok); err != nil {
			return err
		}
	}

	if v.ColumnLevelPermissionRules != nil {
		ok := object.Key("ColumnLevelPermissionRules")
		if err := awsRestjson1_serializeDocumentColumnLevelPermissionRuleList(v.ColumnLevelPermissionRules, ok); err != nil {
			return err
		}
	}

	if v.DataSetUsageConfiguration != nil {
		ok := object.Key("DataSetUsageConfiguration")
		if err := awsRestjson1_serializeDocumentDataSetUsageConfiguration(v.DataSetUsageConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FieldFolders != nil {
		ok := object.Key("FieldFolders")
		if err := awsRestjson1_serializeDocumentFieldFolderMap(v.FieldFolders, ok); err != nil {
			return err
		}
	}

	if len(v.ImportMode) > 0 {
		ok := object.Key("ImportMode")
		ok.String(string(v.ImportMode))
	}

	if v.LogicalTableMap != nil {
		ok := object.Key("LogicalTableMap")
		if err := awsRestjson1_serializeDocumentLogicalTableMap(v.LogicalTableMap, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PhysicalTableMap != nil {
		ok := object.Key("PhysicalTableMap")
		if err := awsRestjson1_serializeDocumentPhysicalTableMap(v.PhysicalTableMap, ok); err != nil {
			return err
		}
	}

	if v.RowLevelPermissionDataSet != nil {
		ok := object.Key("RowLevelPermissionDataSet")
		if err := awsRestjson1_serializeDocumentRowLevelPermissionDataSet(v.RowLevelPermissionDataSet, ok); err != nil {
			return err
		}
	}

	if v.RowLevelPermissionTagConfiguration != nil {
		ok := object.Key("RowLevelPermissionTagConfiguration")
		if err := awsRestjson1_serializeDocumentRowLevelPermissionTagConfiguration(v.RowLevelPermissionTagConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataSetPermissions struct {
}

func (*awsRestjson1_serializeOpUpdateDataSetPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataSetPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataSetPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataSetPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataSetPermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataSetPermissionsInput(v *UpdateDataSetPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSetId == nil || len(*v.DataSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSetId must not be empty")}
	}
	if v.DataSetId != nil {
		if err := encoder.SetURI("DataSetId").String(*v.DataSetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataSetPermissionsInput(v *UpdateDataSetPermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataSource struct {
}

func (*awsRestjson1_serializeOpUpdateDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources/{DataSourceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataSourceInput(v *UpdateDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("DataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataSourceInput(v *UpdateDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentDataSourceCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.DataSourceParameters != nil {
		ok := object.Key("DataSourceParameters")
		if err := awsRestjson1_serializeDocumentDataSourceParameters(v.DataSourceParameters, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SslProperties != nil {
		ok := object.Key("SslProperties")
		if err := awsRestjson1_serializeDocumentSslProperties(v.SslProperties, ok); err != nil {
			return err
		}
	}

	if v.VpcConnectionProperties != nil {
		ok := object.Key("VpcConnectionProperties")
		if err := awsRestjson1_serializeDocumentVpcConnectionProperties(v.VpcConnectionProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataSourcePermissions struct {
}

func (*awsRestjson1_serializeOpUpdateDataSourcePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataSourcePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataSourcePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataSourcePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataSourcePermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataSourcePermissionsInput(v *UpdateDataSourcePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("DataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataSourcePermissionsInput(v *UpdateDataSourcePermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFolder struct {
}

func (*awsRestjson1_serializeOpUpdateFolder) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFolder) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFolderInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFolderInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFolderInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFolderInput(v *UpdateFolderInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFolderInput(v *UpdateFolderInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFolderPermissions struct {
}

func (*awsRestjson1_serializeOpUpdateFolderPermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFolderPermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFolderPermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/folders/{FolderId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFolderPermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFolderPermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFolderPermissionsInput(v *UpdateFolderPermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.FolderId == nil || len(*v.FolderId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FolderId must not be empty")}
	}
	if v.FolderId != nil {
		if err := encoder.SetURI("FolderId").String(*v.FolderId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFolderPermissionsInput(v *UpdateFolderPermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateGroup struct {
}

func (*awsRestjson1_serializeOpUpdateGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateGroupInput(v *UpdateGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GroupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("GroupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateGroupInput(v *UpdateGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateIAMPolicyAssignment struct {
}

func (*awsRestjson1_serializeOpUpdateIAMPolicyAssignment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateIAMPolicyAssignment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIAMPolicyAssignmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateIAMPolicyAssignmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateIAMPolicyAssignmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateIAMPolicyAssignmentInput(v *UpdateIAMPolicyAssignmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssignmentName == nil || len(*v.AssignmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AssignmentName must not be empty")}
	}
	if v.AssignmentName != nil {
		if err := encoder.SetURI("AssignmentName").String(*v.AssignmentName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateIAMPolicyAssignmentInput(v *UpdateIAMPolicyAssignmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AssignmentStatus) > 0 {
		ok := object.Key("AssignmentStatus")
		ok.String(string(v.AssignmentStatus))
	}

	if v.Identities != nil {
		ok := object.Key("Identities")
		if err := awsRestjson1_serializeDocumentIdentityMap(v.Identities, ok); err != nil {
			return err
		}
	}

	if v.PolicyArn != nil {
		ok := object.Key("PolicyArn")
		ok.String(*v.PolicyArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateIpRestriction struct {
}

func (*awsRestjson1_serializeOpUpdateIpRestriction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateIpRestriction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIpRestrictionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/ip-restriction")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateIpRestrictionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateIpRestrictionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateIpRestrictionInput(v *UpdateIpRestrictionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateIpRestrictionInput(v *UpdateIpRestrictionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.IpRestrictionRuleMap != nil {
		ok := object.Key("IpRestrictionRuleMap")
		if err := awsRestjson1_serializeDocumentIpRestrictionRuleMap(v.IpRestrictionRuleMap, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePublicSharingSettings struct {
}

func (*awsRestjson1_serializeOpUpdatePublicSharingSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePublicSharingSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePublicSharingSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/public-sharing-settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePublicSharingSettingsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePublicSharingSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePublicSharingSettingsInput(v *UpdatePublicSharingSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePublicSharingSettingsInput(v *UpdatePublicSharingSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PublicSharingEnabled {
		ok := object.Key("PublicSharingEnabled")
		ok.Boolean(v.PublicSharingEnabled)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTemplate struct {
}

func (*awsRestjson1_serializeOpUpdateTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTemplateInput(v *UpdateTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTemplateInput(v *UpdateTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SourceEntity != nil {
		ok := object.Key("SourceEntity")
		if err := awsRestjson1_serializeDocumentTemplateSourceEntity(v.SourceEntity, ok); err != nil {
			return err
		}
	}

	if v.VersionDescription != nil {
		ok := object.Key("VersionDescription")
		ok.String(*v.VersionDescription)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTemplateAlias struct {
}

func (*awsRestjson1_serializeOpUpdateTemplateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTemplateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTemplateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTemplateAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTemplateAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTemplateAliasInput(v *UpdateTemplateAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTemplateAliasInput(v *UpdateTemplateAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TemplateVersionNumber != nil {
		ok := object.Key("TemplateVersionNumber")
		ok.Long(*v.TemplateVersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTemplatePermissions struct {
}

func (*awsRestjson1_serializeOpUpdateTemplatePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTemplatePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTemplatePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/templates/{TemplateId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTemplatePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTemplatePermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTemplatePermissionsInput(v *UpdateTemplatePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTemplatePermissionsInput(v *UpdateTemplatePermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTheme struct {
}

func (*awsRestjson1_serializeOpUpdateTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateThemeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateThemeInput(v *UpdateThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateThemeInput(v *UpdateThemeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseThemeId != nil {
		ok := object.Key("BaseThemeId")
		ok.String(*v.BaseThemeId)
	}

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		if err := awsRestjson1_serializeDocumentThemeConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.VersionDescription != nil {
		ok := object.Key("VersionDescription")
		ok.String(*v.VersionDescription)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateThemeAlias struct {
}

func (*awsRestjson1_serializeOpUpdateThemeAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateThemeAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateThemeAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateThemeAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateThemeAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateThemeAliasInput(v *UpdateThemeAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AliasName == nil || len(*v.AliasName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AliasName must not be empty")}
	}
	if v.AliasName != nil {
		if err := encoder.SetURI("AliasName").String(*v.AliasName); err != nil {
			return err
		}
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateThemeAliasInput(v *UpdateThemeAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ThemeVersionNumber != nil {
		ok := object.Key("ThemeVersionNumber")
		ok.Long(*v.ThemeVersionNumber)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateThemePermissions struct {
}

func (*awsRestjson1_serializeOpUpdateThemePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateThemePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateThemePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/themes/{ThemeId}/permissions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateThemePermissionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateThemePermissionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateThemePermissionsInput(v *UpdateThemePermissionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.ThemeId == nil || len(*v.ThemeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ThemeId must not be empty")}
	}
	if v.ThemeId != nil {
		if err := encoder.SetURI("ThemeId").String(*v.ThemeId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateThemePermissionsInput(v *UpdateThemePermissionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrantPermissions != nil {
		ok := object.Key("GrantPermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.GrantPermissions, ok); err != nil {
			return err
		}
	}

	if v.RevokePermissions != nil {
		ok := object.Key("RevokePermissions")
		if err := awsRestjson1_serializeDocumentUpdateResourcePermissionList(v.RevokePermissions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateUser struct {
}

func (*awsRestjson1_serializeOpUpdateUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateUserInput(v *UpdateUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AwsAccountId == nil || len(*v.AwsAccountId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member AwsAccountId must not be empty")}
	}
	if v.AwsAccountId != nil {
		if err := encoder.SetURI("AwsAccountId").String(*v.AwsAccountId); err != nil {
			return err
		}
	}

	if v.Namespace == nil || len(*v.Namespace) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Namespace must not be empty")}
	}
	if v.Namespace != nil {
		if err := encoder.SetURI("Namespace").String(*v.Namespace); err != nil {
			return err
		}
	}

	if v.UserName == nil || len(*v.UserName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member UserName must not be empty")}
	}
	if v.UserName != nil {
		if err := encoder.SetURI("UserName").String(*v.UserName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateUserInput(v *UpdateUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomFederationProviderUrl != nil {
		ok := object.Key("CustomFederationProviderUrl")
		ok.String(*v.CustomFederationProviderUrl)
	}

	if v.CustomPermissionsName != nil {
		ok := object.Key("CustomPermissionsName")
		ok.String(*v.CustomPermissionsName)
	}

	if v.Email != nil {
		ok := object.Key("Email")
		ok.String(*v.Email)
	}

	if v.ExternalLoginFederationProviderType != nil {
		ok := object.Key("ExternalLoginFederationProviderType")
		ok.String(*v.ExternalLoginFederationProviderType)
	}

	if v.ExternalLoginId != nil {
		ok := object.Key("ExternalLoginId")
		ok.String(*v.ExternalLoginId)
	}

	if len(v.Role) > 0 {
		ok := object.Key("Role")
		ok.String(string(v.Role))
	}

	if v.UnapplyCustomPermissions {
		ok := object.Key("UnapplyCustomPermissions")
		ok.Boolean(v.UnapplyCustomPermissions)
	}

	return nil
}

func awsRestjson1_serializeDocumentAccountCustomization(v *types.AccountCustomization, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultEmailCustomizationTemplate != nil {
		ok := object.Key("DefaultEmailCustomizationTemplate")
		ok.String(*v.DefaultEmailCustomizationTemplate)
	}

	if v.DefaultTheme != nil {
		ok := object.Key("DefaultTheme")
		ok.String(*v.DefaultTheme)
	}

	return nil
}

func awsRestjson1_serializeDocumentActionList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAdHocFilteringOption(v *types.AdHocFilteringOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityStatus) > 0 {
		ok := object.Key("AvailabilityStatus")
		ok.String(string(v.AvailabilityStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentAmazonElasticsearchParameters(v *types.AmazonElasticsearchParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	return nil
}

func awsRestjson1_serializeDocumentAmazonOpenSearchParameters(v *types.AmazonOpenSearchParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Domain != nil {
		ok := object.Key("Domain")
		ok.String(*v.Domain)
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalysisSearchFilter(v *types.AnalysisSearchFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("Operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalysisSearchFilterList(v []types.AnalysisSearchFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalysisSearchFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalysisSourceEntity(v *types.AnalysisSourceEntity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourceTemplate != nil {
		ok := object.Key("SourceTemplate")
		if err := awsRestjson1_serializeDocumentAnalysisSourceTemplate(v.SourceTemplate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalysisSourceTemplate(v *types.AnalysisSourceTemplate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.DataSetReferences != nil {
		ok := object.Key("DataSetReferences")
		if err := awsRestjson1_serializeDocumentDataSetReferenceList(v.DataSetReferences, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnonymousUserDashboardEmbeddingConfiguration(v *types.AnonymousUserDashboardEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialDashboardId != nil {
		ok := object.Key("InitialDashboardId")
		ok.String(*v.InitialDashboardId)
	}

	return nil
}

func awsRestjson1_serializeDocumentAnonymousUserDashboardVisualEmbeddingConfiguration(v *types.AnonymousUserDashboardVisualEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialDashboardVisualId != nil {
		ok := object.Key("InitialDashboardVisualId")
		if err := awsRestjson1_serializeDocumentDashboardVisualId(v.InitialDashboardVisualId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnonymousUserEmbeddingExperienceConfiguration(v *types.AnonymousUserEmbeddingExperienceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dashboard != nil {
		ok := object.Key("Dashboard")
		if err := awsRestjson1_serializeDocumentAnonymousUserDashboardEmbeddingConfiguration(v.Dashboard, ok); err != nil {
			return err
		}
	}

	if v.DashboardVisual != nil {
		ok := object.Key("DashboardVisual")
		if err := awsRestjson1_serializeDocumentAnonymousUserDashboardVisualEmbeddingConfiguration(v.DashboardVisual, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAthenaParameters(v *types.AthenaParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WorkGroup != nil {
		ok := object.Key("WorkGroup")
		ok.String(*v.WorkGroup)
	}

	return nil
}

func awsRestjson1_serializeDocumentAuroraParameters(v *types.AuroraParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	{
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentAuroraPostgreSqlParameters(v *types.AuroraPostgreSqlParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	{
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIotAnalyticsParameters(v *types.AwsIotAnalyticsParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetName != nil {
		ok := object.Key("DataSetName")
		ok.String(*v.DataSetName)
	}

	return nil
}

func awsRestjson1_serializeDocumentBorderStyle(v *types.BorderStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Show != nil {
		ok := object.Key("Show")
		ok.Boolean(*v.Show)
	}

	return nil
}

func awsRestjson1_serializeDocumentCalculatedColumn(v *types.CalculatedColumn, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnId != nil {
		ok := object.Key("ColumnId")
		ok.String(*v.ColumnId)
	}

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.Expression != nil {
		ok := object.Key("Expression")
		ok.String(*v.Expression)
	}

	return nil
}

func awsRestjson1_serializeDocumentCalculatedColumnList(v []types.CalculatedColumn, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCalculatedColumn(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCastColumnTypeOperation(v *types.CastColumnTypeOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.Format != nil {
		ok := object.Key("Format")
		ok.String(*v.Format)
	}

	if len(v.NewColumnType) > 0 {
		ok := object.Key("NewColumnType")
		ok.String(string(v.NewColumnType))
	}

	return nil
}

func awsRestjson1_serializeDocumentColorList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnDescription(v *types.ColumnDescription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Text != nil {
		ok := object.Key("Text")
		ok.String(*v.Text)
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnGroup(v *types.ColumnGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GeoSpatialColumnGroup != nil {
		ok := object.Key("GeoSpatialColumnGroup")
		if err := awsRestjson1_serializeDocumentGeoSpatialColumnGroup(v.GeoSpatialColumnGroup, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnGroupList(v []types.ColumnGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnLevelPermissionRule(v *types.ColumnLevelPermissionRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnNames != nil {
		ok := object.Key("ColumnNames")
		if err := awsRestjson1_serializeDocumentColumnNameList(v.ColumnNames, ok); err != nil {
			return err
		}
	}

	if v.Principals != nil {
		ok := object.Key("Principals")
		if err := awsRestjson1_serializeDocumentPrincipalList(v.Principals, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnLevelPermissionRuleList(v []types.ColumnLevelPermissionRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnLevelPermissionRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnTag(v *types.ColumnTag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnDescription != nil {
		ok := object.Key("ColumnDescription")
		if err := awsRestjson1_serializeDocumentColumnDescription(v.ColumnDescription, ok); err != nil {
			return err
		}
	}

	if len(v.ColumnGeographicRole) > 0 {
		ok := object.Key("ColumnGeographicRole")
		ok.String(string(v.ColumnGeographicRole))
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnTagList(v []types.ColumnTag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentColumnTagNames(v []types.ColumnTagName, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentCreateColumnsOperation(v *types.CreateColumnsOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsRestjson1_serializeDocumentCalculatedColumnList(v.Columns, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCredentialPair(v *types.CredentialPair, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AlternateDataSourceParameters != nil {
		ok := object.Key("AlternateDataSourceParameters")
		if err := awsRestjson1_serializeDocumentDataSourceParametersList(v.AlternateDataSourceParameters, ok); err != nil {
			return err
		}
	}

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.Username != nil {
		ok := object.Key("Username")
		ok.String(*v.Username)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomSql(v *types.CustomSql, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsRestjson1_serializeDocumentInputColumnList(v.Columns, ok); err != nil {
			return err
		}
	}

	if v.DataSourceArn != nil {
		ok := object.Key("DataSourceArn")
		ok.String(*v.DataSourceArn)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SqlQuery != nil {
		ok := object.Key("SqlQuery")
		ok.String(*v.SqlQuery)
	}

	return nil
}

func awsRestjson1_serializeDocumentDashboardPublishOptions(v *types.DashboardPublishOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdHocFilteringOption != nil {
		ok := object.Key("AdHocFilteringOption")
		if err := awsRestjson1_serializeDocumentAdHocFilteringOption(v.AdHocFilteringOption, ok); err != nil {
			return err
		}
	}

	if v.ExportToCSVOption != nil {
		ok := object.Key("ExportToCSVOption")
		if err := awsRestjson1_serializeDocumentExportToCSVOption(v.ExportToCSVOption, ok); err != nil {
			return err
		}
	}

	if v.SheetControlsOption != nil {
		ok := object.Key("SheetControlsOption")
		if err := awsRestjson1_serializeDocumentSheetControlsOption(v.SheetControlsOption, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDashboardSearchFilter(v *types.DashboardSearchFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("Operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentDashboardSearchFilterList(v []types.DashboardSearchFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDashboardSearchFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDashboardSourceEntity(v *types.DashboardSourceEntity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourceTemplate != nil {
		ok := object.Key("SourceTemplate")
		if err := awsRestjson1_serializeDocumentDashboardSourceTemplate(v.SourceTemplate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDashboardSourceTemplate(v *types.DashboardSourceTemplate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.DataSetReferences != nil {
		ok := object.Key("DataSetReferences")
		if err := awsRestjson1_serializeDocumentDataSetReferenceList(v.DataSetReferences, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDashboardVisualId(v *types.DashboardVisualId, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DashboardId != nil {
		ok := object.Key("DashboardId")
		ok.String(*v.DashboardId)
	}

	if v.SheetId != nil {
		ok := object.Key("SheetId")
		ok.String(*v.SheetId)
	}

	if v.VisualId != nil {
		ok := object.Key("VisualId")
		ok.String(*v.VisualId)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataColorPalette(v *types.DataColorPalette, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Colors != nil {
		ok := object.Key("Colors")
		if err := awsRestjson1_serializeDocumentColorList(v.Colors, ok); err != nil {
			return err
		}
	}

	if v.EmptyFillColor != nil {
		ok := object.Key("EmptyFillColor")
		ok.String(*v.EmptyFillColor)
	}

	if v.MinMaxGradient != nil {
		ok := object.Key("MinMaxGradient")
		if err := awsRestjson1_serializeDocumentColorList(v.MinMaxGradient, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSetReference(v *types.DataSetReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetArn != nil {
		ok := object.Key("DataSetArn")
		ok.String(*v.DataSetArn)
	}

	if v.DataSetPlaceholder != nil {
		ok := object.Key("DataSetPlaceholder")
		ok.String(*v.DataSetPlaceholder)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSetReferenceList(v []types.DataSetReference, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataSetReference(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataSetUsageConfiguration(v *types.DataSetUsageConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisableUseAsDirectQuerySource {
		ok := object.Key("DisableUseAsDirectQuerySource")
		ok.Boolean(v.DisableUseAsDirectQuerySource)
	}

	if v.DisableUseAsImportedSource {
		ok := object.Key("DisableUseAsImportedSource")
		ok.Boolean(v.DisableUseAsImportedSource)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSourceCredentials(v *types.DataSourceCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CopySourceArn != nil {
		ok := object.Key("CopySourceArn")
		ok.String(*v.CopySourceArn)
	}

	if v.CredentialPair != nil {
		ok := object.Key("CredentialPair")
		if err := awsRestjson1_serializeDocumentCredentialPair(v.CredentialPair, ok); err != nil {
			return err
		}
	}

	if v.SecretArn != nil {
		ok := object.Key("SecretArn")
		ok.String(*v.SecretArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSourceParameters(v types.DataSourceParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DataSourceParametersMemberAmazonElasticsearchParameters:
		av := object.Key("AmazonElasticsearchParameters")
		if err := awsRestjson1_serializeDocumentAmazonElasticsearchParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberAmazonOpenSearchParameters:
		av := object.Key("AmazonOpenSearchParameters")
		if err := awsRestjson1_serializeDocumentAmazonOpenSearchParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberAthenaParameters:
		av := object.Key("AthenaParameters")
		if err := awsRestjson1_serializeDocumentAthenaParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberAuroraParameters:
		av := object.Key("AuroraParameters")
		if err := awsRestjson1_serializeDocumentAuroraParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberAuroraPostgreSqlParameters:
		av := object.Key("AuroraPostgreSqlParameters")
		if err := awsRestjson1_serializeDocumentAuroraPostgreSqlParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberAwsIotAnalyticsParameters:
		av := object.Key("AwsIotAnalyticsParameters")
		if err := awsRestjson1_serializeDocumentAwsIotAnalyticsParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberExasolParameters:
		av := object.Key("ExasolParameters")
		if err := awsRestjson1_serializeDocumentExasolParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberJiraParameters:
		av := object.Key("JiraParameters")
		if err := awsRestjson1_serializeDocumentJiraParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberMariaDbParameters:
		av := object.Key("MariaDbParameters")
		if err := awsRestjson1_serializeDocumentMariaDbParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberMySqlParameters:
		av := object.Key("MySqlParameters")
		if err := awsRestjson1_serializeDocumentMySqlParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberOracleParameters:
		av := object.Key("OracleParameters")
		if err := awsRestjson1_serializeDocumentOracleParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberPostgreSqlParameters:
		av := object.Key("PostgreSqlParameters")
		if err := awsRestjson1_serializeDocumentPostgreSqlParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberPrestoParameters:
		av := object.Key("PrestoParameters")
		if err := awsRestjson1_serializeDocumentPrestoParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberRdsParameters:
		av := object.Key("RdsParameters")
		if err := awsRestjson1_serializeDocumentRdsParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberRedshiftParameters:
		av := object.Key("RedshiftParameters")
		if err := awsRestjson1_serializeDocumentRedshiftParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberS3Parameters:
		av := object.Key("S3Parameters")
		if err := awsRestjson1_serializeDocumentS3Parameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberServiceNowParameters:
		av := object.Key("ServiceNowParameters")
		if err := awsRestjson1_serializeDocumentServiceNowParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberSnowflakeParameters:
		av := object.Key("SnowflakeParameters")
		if err := awsRestjson1_serializeDocumentSnowflakeParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberSparkParameters:
		av := object.Key("SparkParameters")
		if err := awsRestjson1_serializeDocumentSparkParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberSqlServerParameters:
		av := object.Key("SqlServerParameters")
		if err := awsRestjson1_serializeDocumentSqlServerParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberTeradataParameters:
		av := object.Key("TeradataParameters")
		if err := awsRestjson1_serializeDocumentTeradataParameters(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataSourceParametersMemberTwitterParameters:
		av := object.Key("TwitterParameters")
		if err := awsRestjson1_serializeDocumentTwitterParameters(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDataSourceParametersList(v []types.DataSourceParameters, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentDataSourceParameters(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDateTimeParameter(v *types.DateTimeParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentTimestampList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDateTimeParameterList(v []types.DateTimeParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDateTimeParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDecimalParameter(v *types.DecimalParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentDoubleList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDecimalParameterList(v []types.DecimalParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDecimalParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDoubleList(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentExasolParameters(v *types.ExasolParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	{
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentExportToCSVOption(v *types.ExportToCSVOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvailabilityStatus) > 0 {
		ok := object.Key("AvailabilityStatus")
		ok.String(string(v.AvailabilityStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldFolder(v *types.FieldFolder, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("columns")
		if err := awsRestjson1_serializeDocumentFolderColumnList(v.Columns, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldFolderMap(v map[string]types.FieldFolder, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentFieldFolder(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFilterOperation(v *types.FilterOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConditionExpression != nil {
		ok := object.Key("ConditionExpression")
		ok.String(*v.ConditionExpression)
	}

	return nil
}

func awsRestjson1_serializeDocumentFolderColumnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFolderSearchFilter(v *types.FolderSearchFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("Operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentFolderSearchFilterList(v []types.FolderSearchFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFolderSearchFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGeoSpatialColumnGroup(v *types.GeoSpatialColumnGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("Columns")
		if err := awsRestjson1_serializeDocumentColumnList(v.Columns, ok); err != nil {
			return err
		}
	}

	if len(v.CountryCode) > 0 {
		ok := object.Key("CountryCode")
		ok.String(string(v.CountryCode))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentGroupSearchFilter(v *types.GroupSearchFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("Operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentGroupSearchFilterList(v []types.GroupSearchFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentGroupSearchFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGroupsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentGutterStyle(v *types.GutterStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Show != nil {
		ok := object.Key("Show")
		ok.Boolean(*v.Show)
	}

	return nil
}

func awsRestjson1_serializeDocumentIdentityMap(v map[string][]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentIdentityNameList(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIdentityNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentInputColumn(v *types.InputColumn, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentInputColumnList(v []types.InputColumn, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputColumn(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIntegerParameter(v *types.IntegerParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentLongList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIntegerParameterList(v []types.IntegerParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentIntegerParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIpRestrictionRuleMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentJiraParameters(v *types.JiraParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SiteBaseUrl != nil {
		ok := object.Key("SiteBaseUrl")
		ok.String(*v.SiteBaseUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentJoinInstruction(v *types.JoinInstruction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LeftJoinKeyProperties != nil {
		ok := object.Key("LeftJoinKeyProperties")
		if err := awsRestjson1_serializeDocumentJoinKeyProperties(v.LeftJoinKeyProperties, ok); err != nil {
			return err
		}
	}

	if v.LeftOperand != nil {
		ok := object.Key("LeftOperand")
		ok.String(*v.LeftOperand)
	}

	if v.OnClause != nil {
		ok := object.Key("OnClause")
		ok.String(*v.OnClause)
	}

	if v.RightJoinKeyProperties != nil {
		ok := object.Key("RightJoinKeyProperties")
		if err := awsRestjson1_serializeDocumentJoinKeyProperties(v.RightJoinKeyProperties, ok); err != nil {
			return err
		}
	}

	if v.RightOperand != nil {
		ok := object.Key("RightOperand")
		ok.String(*v.RightOperand)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentJoinKeyProperties(v *types.JoinKeyProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UniqueKey != nil {
		ok := object.Key("UniqueKey")
		ok.Boolean(*v.UniqueKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentLogicalTable(v *types.LogicalTable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Alias != nil {
		ok := object.Key("Alias")
		ok.String(*v.Alias)
	}

	if v.DataTransforms != nil {
		ok := object.Key("DataTransforms")
		if err := awsRestjson1_serializeDocumentTransformOperationList(v.DataTransforms, ok); err != nil {
			return err
		}
	}

	if v.Source != nil {
		ok := object.Key("Source")
		if err := awsRestjson1_serializeDocumentLogicalTableSource(v.Source, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLogicalTableMap(v map[string]types.LogicalTable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentLogicalTable(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLogicalTableSource(v *types.LogicalTableSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSetArn != nil {
		ok := object.Key("DataSetArn")
		ok.String(*v.DataSetArn)
	}

	if v.JoinInstruction != nil {
		ok := object.Key("JoinInstruction")
		if err := awsRestjson1_serializeDocumentJoinInstruction(v.JoinInstruction, ok); err != nil {
			return err
		}
	}

	if v.PhysicalTableId != nil {
		ok := object.Key("PhysicalTableId")
		ok.String(*v.PhysicalTableId)
	}

	return nil
}

func awsRestjson1_serializeDocumentLongList(v []int64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Long(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentManifestFileLocation(v *types.ManifestFileLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("Bucket")
		ok.String(*v.Bucket)
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeDocumentMarginStyle(v *types.MarginStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Show != nil {
		ok := object.Key("Show")
		ok.Boolean(*v.Show)
	}

	return nil
}

func awsRestjson1_serializeDocumentMariaDbParameters(v *types.MariaDbParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	{
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentMySqlParameters(v *types.MySqlParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	{
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentOracleParameters(v *types.OracleParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	{
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentParameters(v *types.Parameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateTimeParameters != nil {
		ok := object.Key("DateTimeParameters")
		if err := awsRestjson1_serializeDocumentDateTimeParameterList(v.DateTimeParameters, ok); err != nil {
			return err
		}
	}

	if v.DecimalParameters != nil {
		ok := object.Key("DecimalParameters")
		if err := awsRestjson1_serializeDocumentDecimalParameterList(v.DecimalParameters, ok); err != nil {
			return err
		}
	}

	if v.IntegerParameters != nil {
		ok := object.Key("IntegerParameters")
		if err := awsRestjson1_serializeDocumentIntegerParameterList(v.IntegerParameters, ok); err != nil {
			return err
		}
	}

	if v.StringParameters != nil {
		ok := object.Key("StringParameters")
		if err := awsRestjson1_serializeDocumentStringParameterList(v.StringParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPhysicalTable(v types.PhysicalTable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PhysicalTableMemberCustomSql:
		av := object.Key("CustomSql")
		if err := awsRestjson1_serializeDocumentCustomSql(&uv.Value, av); err != nil {
			return err
		}

	case *types.PhysicalTableMemberRelationalTable:
		av := object.Key("RelationalTable")
		if err := awsRestjson1_serializeDocumentRelationalTable(&uv.Value, av); err != nil {
			return err
		}

	case *types.PhysicalTableMemberS3Source:
		av := object.Key("S3Source")
		if err := awsRestjson1_serializeDocumentS3Source(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentPhysicalTableMap(v map[string]types.PhysicalTable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentPhysicalTable(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPostgreSqlParameters(v *types.PostgreSqlParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	{
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentPrestoParameters(v *types.PrestoParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Catalog != nil {
		ok := object.Key("Catalog")
		ok.String(*v.Catalog)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	{
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentPrincipalList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentProjectedColumnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentProjectOperation(v *types.ProjectOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProjectedColumns != nil {
		ok := object.Key("ProjectedColumns")
		if err := awsRestjson1_serializeDocumentProjectedColumnList(v.ProjectedColumns, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRdsParameters(v *types.RdsParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.InstanceId != nil {
		ok := object.Key("InstanceId")
		ok.String(*v.InstanceId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRedshiftParameters(v *types.RedshiftParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	if v.Port != 0 {
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserDashboardEmbeddingConfiguration(v *types.RegisteredUserDashboardEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialDashboardId != nil {
		ok := object.Key("InitialDashboardId")
		ok.String(*v.InitialDashboardId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserDashboardVisualEmbeddingConfiguration(v *types.RegisteredUserDashboardVisualEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialDashboardVisualId != nil {
		ok := object.Key("InitialDashboardVisualId")
		if err := awsRestjson1_serializeDocumentDashboardVisualId(v.InitialDashboardVisualId, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserEmbeddingExperienceConfiguration(v *types.RegisteredUserEmbeddingExperienceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dashboard != nil {
		ok := object.Key("Dashboard")
		if err := awsRestjson1_serializeDocumentRegisteredUserDashboardEmbeddingConfiguration(v.Dashboard, ok); err != nil {
			return err
		}
	}

	if v.DashboardVisual != nil {
		ok := object.Key("DashboardVisual")
		if err := awsRestjson1_serializeDocumentRegisteredUserDashboardVisualEmbeddingConfiguration(v.DashboardVisual, ok); err != nil {
			return err
		}
	}

	if v.QSearchBar != nil {
		ok := object.Key("QSearchBar")
		if err := awsRestjson1_serializeDocumentRegisteredUserQSearchBarEmbeddingConfiguration(v.QSearchBar, ok); err != nil {
			return err
		}
	}

	if v.QuickSightConsole != nil {
		ok := object.Key("QuickSightConsole")
		if err := awsRestjson1_serializeDocumentRegisteredUserQuickSightConsoleEmbeddingConfiguration(v.QuickSightConsole, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserQSearchBarEmbeddingConfiguration(v *types.RegisteredUserQSearchBarEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialTopicId != nil {
		ok := object.Key("InitialTopicId")
		ok.String(*v.InitialTopicId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRegisteredUserQuickSightConsoleEmbeddingConfiguration(v *types.RegisteredUserQuickSightConsoleEmbeddingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialPath != nil {
		ok := object.Key("InitialPath")
		ok.String(*v.InitialPath)
	}

	return nil
}

func awsRestjson1_serializeDocumentRelationalTable(v *types.RelationalTable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Catalog != nil {
		ok := object.Key("Catalog")
		ok.String(*v.Catalog)
	}

	if v.DataSourceArn != nil {
		ok := object.Key("DataSourceArn")
		ok.String(*v.DataSourceArn)
	}

	if v.InputColumns != nil {
		ok := object.Key("InputColumns")
		if err := awsRestjson1_serializeDocumentInputColumnList(v.InputColumns, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Schema != nil {
		ok := object.Key("Schema")
		ok.String(*v.Schema)
	}

	return nil
}

func awsRestjson1_serializeDocumentRenameColumnOperation(v *types.RenameColumnOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.NewColumnName != nil {
		ok := object.Key("NewColumnName")
		ok.String(*v.NewColumnName)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourcePermission(v *types.ResourcePermission, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsRestjson1_serializeDocumentActionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.Principal != nil {
		ok := object.Key("Principal")
		ok.String(*v.Principal)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourcePermissionList(v []types.ResourcePermission, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentResourcePermission(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRowLevelPermissionDataSet(v *types.RowLevelPermissionDataSet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if len(v.FormatVersion) > 0 {
		ok := object.Key("FormatVersion")
		ok.String(string(v.FormatVersion))
	}

	if v.Namespace != nil {
		ok := object.Key("Namespace")
		ok.String(*v.Namespace)
	}

	if len(v.PermissionPolicy) > 0 {
		ok := object.Key("PermissionPolicy")
		ok.String(string(v.PermissionPolicy))
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocumentRowLevelPermissionTagConfiguration(v *types.RowLevelPermissionTagConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	if v.TagRules != nil {
		ok := object.Key("TagRules")
		if err := awsRestjson1_serializeDocumentRowLevelPermissionTagRuleList(v.TagRules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRowLevelPermissionTagRule(v *types.RowLevelPermissionTagRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.MatchAllValue != nil {
		ok := object.Key("MatchAllValue")
		ok.String(*v.MatchAllValue)
	}

	if v.TagKey != nil {
		ok := object.Key("TagKey")
		ok.String(*v.TagKey)
	}

	if v.TagMultiValueDelimiter != nil {
		ok := object.Key("TagMultiValueDelimiter")
		ok.String(*v.TagMultiValueDelimiter)
	}

	return nil
}

func awsRestjson1_serializeDocumentRowLevelPermissionTagRuleList(v []types.RowLevelPermissionTagRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRowLevelPermissionTagRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentS3Parameters(v *types.S3Parameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManifestFileLocation != nil {
		ok := object.Key("ManifestFileLocation")
		if err := awsRestjson1_serializeDocumentManifestFileLocation(v.ManifestFileLocation, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentS3Source(v *types.S3Source, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceArn != nil {
		ok := object.Key("DataSourceArn")
		ok.String(*v.DataSourceArn)
	}

	if v.InputColumns != nil {
		ok := object.Key("InputColumns")
		if err := awsRestjson1_serializeDocumentInputColumnList(v.InputColumns, ok); err != nil {
			return err
		}
	}

	if v.UploadSettings != nil {
		ok := object.Key("UploadSettings")
		if err := awsRestjson1_serializeDocumentUploadSettings(v.UploadSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentServiceNowParameters(v *types.ServiceNowParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SiteBaseUrl != nil {
		ok := object.Key("SiteBaseUrl")
		ok.String(*v.SiteBaseUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentSessionTag(v *types.SessionTag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentSessionTagList(v []types.SessionTag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSessionTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSheetControlsOption(v *types.SheetControlsOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.VisibilityState) > 0 {
		ok := object.Key("VisibilityState")
		ok.String(string(v.VisibilityState))
	}

	return nil
}

func awsRestjson1_serializeDocumentSheetStyle(v *types.SheetStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tile != nil {
		ok := object.Key("Tile")
		if err := awsRestjson1_serializeDocumentTileStyle(v.Tile, ok); err != nil {
			return err
		}
	}

	if v.TileLayout != nil {
		ok := object.Key("TileLayout")
		if err := awsRestjson1_serializeDocumentTileLayoutStyle(v.TileLayout, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSnowflakeParameters(v *types.SnowflakeParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	if v.Warehouse != nil {
		ok := object.Key("Warehouse")
		ok.String(*v.Warehouse)
	}

	return nil
}

func awsRestjson1_serializeDocumentSparkParameters(v *types.SparkParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	{
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentSqlServerParameters(v *types.SqlServerParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	{
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentSslProperties(v *types.SslProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisableSsl {
		ok := object.Key("DisableSsl")
		ok.Boolean(v.DisableSsl)
	}

	return nil
}

func awsRestjson1_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentStringParameter(v *types.StringParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentStringList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStringParameterList(v []types.StringParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentStringParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagColumnOperation(v *types.TagColumnOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentColumnTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTemplateSourceAnalysis(v *types.TemplateSourceAnalysis, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.DataSetReferences != nil {
		ok := object.Key("DataSetReferences")
		if err := awsRestjson1_serializeDocumentDataSetReferenceList(v.DataSetReferences, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTemplateSourceEntity(v *types.TemplateSourceEntity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourceAnalysis != nil {
		ok := object.Key("SourceAnalysis")
		if err := awsRestjson1_serializeDocumentTemplateSourceAnalysis(v.SourceAnalysis, ok); err != nil {
			return err
		}
	}

	if v.SourceTemplate != nil {
		ok := object.Key("SourceTemplate")
		if err := awsRestjson1_serializeDocumentTemplateSourceTemplate(v.SourceTemplate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTemplateSourceTemplate(v *types.TemplateSourceTemplate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	return nil
}

func awsRestjson1_serializeDocumentTeradataParameters(v *types.TeradataParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.Host != nil {
		ok := object.Key("Host")
		ok.String(*v.Host)
	}

	{
		ok := object.Key("Port")
		ok.Integer(v.Port)
	}

	return nil
}

func awsRestjson1_serializeDocumentThemeConfiguration(v *types.ThemeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataColorPalette != nil {
		ok := object.Key("DataColorPalette")
		if err := awsRestjson1_serializeDocumentDataColorPalette(v.DataColorPalette, ok); err != nil {
			return err
		}
	}

	if v.Sheet != nil {
		ok := object.Key("Sheet")
		if err := awsRestjson1_serializeDocumentSheetStyle(v.Sheet, ok); err != nil {
			return err
		}
	}

	if v.UIColorPalette != nil {
		ok := object.Key("UIColorPalette")
		if err := awsRestjson1_serializeDocumentUIColorPalette(v.UIColorPalette, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTileLayoutStyle(v *types.TileLayoutStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Gutter != nil {
		ok := object.Key("Gutter")
		if err := awsRestjson1_serializeDocumentGutterStyle(v.Gutter, ok); err != nil {
			return err
		}
	}

	if v.Margin != nil {
		ok := object.Key("Margin")
		if err := awsRestjson1_serializeDocumentMarginStyle(v.Margin, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTileStyle(v *types.TileStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Border != nil {
		ok := object.Key("Border")
		if err := awsRestjson1_serializeDocumentBorderStyle(v.Border, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTimestampList(v []time.Time, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Double(smithytime.FormatEpochSeconds(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentTransformOperation(v types.TransformOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.TransformOperationMemberCastColumnTypeOperation:
		av := object.Key("CastColumnTypeOperation")
		if err := awsRestjson1_serializeDocumentCastColumnTypeOperation(&uv.Value, av); err != nil {
			return err
		}

	case *types.TransformOperationMemberCreateColumnsOperation:
		av := object.Key("CreateColumnsOperation")
		if err := awsRestjson1_serializeDocumentCreateColumnsOperation(&uv.Value, av); err != nil {
			return err
		}

	case *types.TransformOperationMemberFilterOperation:
		av := object.Key("FilterOperation")
		if err := awsRestjson1_serializeDocumentFilterOperation(&uv.Value, av); err != nil {
			return err
		}

	case *types.TransformOperationMemberProjectOperation:
		av := object.Key("ProjectOperation")
		if err := awsRestjson1_serializeDocumentProjectOperation(&uv.Value, av); err != nil {
			return err
		}

	case *types.TransformOperationMemberRenameColumnOperation:
		av := object.Key("RenameColumnOperation")
		if err := awsRestjson1_serializeDocumentRenameColumnOperation(&uv.Value, av); err != nil {
			return err
		}

	case *types.TransformOperationMemberTagColumnOperation:
		av := object.Key("TagColumnOperation")
		if err := awsRestjson1_serializeDocumentTagColumnOperation(&uv.Value, av); err != nil {
			return err
		}

	case *types.TransformOperationMemberUntagColumnOperation:
		av := object.Key("UntagColumnOperation")
		if err := awsRestjson1_serializeDocumentUntagColumnOperation(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentTransformOperationList(v []types.TransformOperation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentTransformOperation(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTwitterParameters(v *types.TwitterParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("MaxRows")
		ok.Integer(v.MaxRows)
	}

	if v.Query != nil {
		ok := object.Key("Query")
		ok.String(*v.Query)
	}

	return nil
}

func awsRestjson1_serializeDocumentUIColorPalette(v *types.UIColorPalette, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Accent != nil {
		ok := object.Key("Accent")
		ok.String(*v.Accent)
	}

	if v.AccentForeground != nil {
		ok := object.Key("AccentForeground")
		ok.String(*v.AccentForeground)
	}

	if v.Danger != nil {
		ok := object.Key("Danger")
		ok.String(*v.Danger)
	}

	if v.DangerForeground != nil {
		ok := object.Key("DangerForeground")
		ok.String(*v.DangerForeground)
	}

	if v.Dimension != nil {
		ok := object.Key("Dimension")
		ok.String(*v.Dimension)
	}

	if v.DimensionForeground != nil {
		ok := object.Key("DimensionForeground")
		ok.String(*v.DimensionForeground)
	}

	if v.Measure != nil {
		ok := object.Key("Measure")
		ok.String(*v.Measure)
	}

	if v.MeasureForeground != nil {
		ok := object.Key("MeasureForeground")
		ok.String(*v.MeasureForeground)
	}

	if v.PrimaryBackground != nil {
		ok := object.Key("PrimaryBackground")
		ok.String(*v.PrimaryBackground)
	}

	if v.PrimaryForeground != nil {
		ok := object.Key("PrimaryForeground")
		ok.String(*v.PrimaryForeground)
	}

	if v.SecondaryBackground != nil {
		ok := object.Key("SecondaryBackground")
		ok.String(*v.SecondaryBackground)
	}

	if v.SecondaryForeground != nil {
		ok := object.Key("SecondaryForeground")
		ok.String(*v.SecondaryForeground)
	}

	if v.Success != nil {
		ok := object.Key("Success")
		ok.String(*v.Success)
	}

	if v.SuccessForeground != nil {
		ok := object.Key("SuccessForeground")
		ok.String(*v.SuccessForeground)
	}

	if v.Warning != nil {
		ok := object.Key("Warning")
		ok.String(*v.Warning)
	}

	if v.WarningForeground != nil {
		ok := object.Key("WarningForeground")
		ok.String(*v.WarningForeground)
	}

	return nil
}

func awsRestjson1_serializeDocumentUntagColumnOperation(v *types.UntagColumnOperation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnName != nil {
		ok := object.Key("ColumnName")
		ok.String(*v.ColumnName)
	}

	if v.TagNames != nil {
		ok := object.Key("TagNames")
		if err := awsRestjson1_serializeDocumentColumnTagNames(v.TagNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateLinkPermissionList(v []types.ResourcePermission, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentResourcePermission(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUpdateResourcePermissionList(v []types.ResourcePermission, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentResourcePermission(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUploadSettings(v *types.UploadSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainsHeader != nil {
		ok := object.Key("ContainsHeader")
		ok.Boolean(*v.ContainsHeader)
	}

	if v.Delimiter != nil {
		ok := object.Key("Delimiter")
		ok.String(*v.Delimiter)
	}

	if len(v.Format) > 0 {
		ok := object.Key("Format")
		ok.String(string(v.Format))
	}

	if v.StartFromRow != nil {
		ok := object.Key("StartFromRow")
		ok.Integer(*v.StartFromRow)
	}

	if len(v.TextQualifier) > 0 {
		ok := object.Key("TextQualifier")
		ok.String(string(v.TextQualifier))
	}

	return nil
}

func awsRestjson1_serializeDocumentVpcConnectionProperties(v *types.VpcConnectionProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VpcConnectionArn != nil {
		ok := object.Key("VpcConnectionArn")
		ok.String(*v.VpcConnectionArn)
	}

	return nil
}
