// Code generated by smithy-go-codegen DO NOT EDIT.

package opensearch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/opensearch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune
// action type, description, severity, and scheduled date.
func (c *Client) DescribeDomainAutoTunes(ctx context.Context, params *DescribeDomainAutoTunesInput, optFns ...func(*Options)) (*DescribeDomainAutoTunesOutput, error) {
	if params == nil {
		params = &DescribeDomainAutoTunesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeDomainAutoTunes", params, optFns, c.addOperationDescribeDomainAutoTunesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeDomainAutoTunesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Container for the parameters to the DescribeDomainAutoTunes operation.
type DescribeDomainAutoTunesInput struct {

	// The domain name for which you want Auto-Tune action details.
	//
	// This member is required.
	DomainName *string

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults int32

	// NextToken is sent in case the earlier API call results contain the NextToken.
	// Used for pagination.
	NextToken *string

	noSmithyDocumentSerde
}

// The result of a DescribeDomainAutoTunes request. See  Auto-Tune for Amazon
// OpenSearch Service
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// for more information.
type DescribeDomainAutoTunesOutput struct {

	// The list of setting adjustments that Auto-Tune has made to the domain. See
	// Auto-Tune for Amazon OpenSearch Service
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	AutoTunes []types.AutoTune

	// An identifier to allow retrieval of paginated results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeDomainAutoTunesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeDomainAutoTunes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeDomainAutoTunes{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeDomainAutoTunesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeDomainAutoTunes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeDomainAutoTunesAPIClient is a client that implements the
// DescribeDomainAutoTunes operation.
type DescribeDomainAutoTunesAPIClient interface {
	DescribeDomainAutoTunes(context.Context, *DescribeDomainAutoTunesInput, ...func(*Options)) (*DescribeDomainAutoTunesOutput, error)
}

var _ DescribeDomainAutoTunesAPIClient = (*Client)(nil)

// DescribeDomainAutoTunesPaginatorOptions is the paginator options for
// DescribeDomainAutoTunes
type DescribeDomainAutoTunesPaginatorOptions struct {
	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeDomainAutoTunesPaginator is a paginator for DescribeDomainAutoTunes
type DescribeDomainAutoTunesPaginator struct {
	options   DescribeDomainAutoTunesPaginatorOptions
	client    DescribeDomainAutoTunesAPIClient
	params    *DescribeDomainAutoTunesInput
	nextToken *string
	firstPage bool
}

// NewDescribeDomainAutoTunesPaginator returns a new
// DescribeDomainAutoTunesPaginator
func NewDescribeDomainAutoTunesPaginator(client DescribeDomainAutoTunesAPIClient, params *DescribeDomainAutoTunesInput, optFns ...func(*DescribeDomainAutoTunesPaginatorOptions)) *DescribeDomainAutoTunesPaginator {
	if params == nil {
		params = &DescribeDomainAutoTunesInput{}
	}

	options := DescribeDomainAutoTunesPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeDomainAutoTunesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeDomainAutoTunesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeDomainAutoTunes page.
func (p *DescribeDomainAutoTunesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeDomainAutoTunesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.DescribeDomainAutoTunes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeDomainAutoTunes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "es",
		OperationName: "DescribeDomainAutoTunes",
	}
}
