// Code generated by smithy-go-codegen DO NOT EDIT.

package networkmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/networkmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of core network attachments.
func (c *Client) ListAttachments(ctx context.Context, params *ListAttachmentsInput, optFns ...func(*Options)) (*ListAttachmentsOutput, error) {
	if params == nil {
		params = &ListAttachmentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAttachments", params, optFns, c.addOperationListAttachmentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAttachmentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAttachmentsInput struct {

	// The type of attachment.
	AttachmentType types.AttachmentType

	// The ID of a core network.
	CoreNetworkId *string

	// The Region where the edge is located.
	EdgeLocation *string

	// The maximum number of results to return.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The state of the attachment.
	State types.AttachmentState

	noSmithyDocumentSerde
}

type ListAttachmentsOutput struct {

	// Describes the list of attachments.
	Attachments []types.Attachment

	// The token for the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAttachmentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAttachments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAttachments{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAttachments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAttachmentsAPIClient is a client that implements the ListAttachments
// operation.
type ListAttachmentsAPIClient interface {
	ListAttachments(context.Context, *ListAttachmentsInput, ...func(*Options)) (*ListAttachmentsOutput, error)
}

var _ ListAttachmentsAPIClient = (*Client)(nil)

// ListAttachmentsPaginatorOptions is the paginator options for ListAttachments
type ListAttachmentsPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAttachmentsPaginator is a paginator for ListAttachments
type ListAttachmentsPaginator struct {
	options   ListAttachmentsPaginatorOptions
	client    ListAttachmentsAPIClient
	params    *ListAttachmentsInput
	nextToken *string
	firstPage bool
}

// NewListAttachmentsPaginator returns a new ListAttachmentsPaginator
func NewListAttachmentsPaginator(client ListAttachmentsAPIClient, params *ListAttachmentsInput, optFns ...func(*ListAttachmentsPaginatorOptions)) *ListAttachmentsPaginator {
	if params == nil {
		params = &ListAttachmentsInput{}
	}

	options := ListAttachmentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAttachmentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAttachmentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAttachments page.
func (p *ListAttachmentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAttachmentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListAttachments(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListAttachments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "networkmanager",
		OperationName: "ListAttachments",
	}
}
