// Code generated by smithy-go-codegen DO NOT EDIT.

package mwaa

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/mwaa/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpCreateCliToken struct {
}

func (*awsRestjson1_serializeOpCreateCliToken) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateCliToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCliTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/clitoken/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateCliTokenInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateCliTokenInput(v *CreateCliTokenInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateEnvironment struct {
}

func (*awsRestjson1_serializeOpCreateEnvironment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateEnvironment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateEnvironmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/environments/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateEnvironmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateEnvironmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateEnvironmentInput(v *CreateEnvironmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateEnvironmentInput(v *CreateEnvironmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AirflowConfigurationOptions != nil {
		ok := object.Key("AirflowConfigurationOptions")
		if err := awsRestjson1_serializeDocumentAirflowConfigurationOptions(v.AirflowConfigurationOptions, ok); err != nil {
			return err
		}
	}

	if v.AirflowVersion != nil {
		ok := object.Key("AirflowVersion")
		ok.String(*v.AirflowVersion)
	}

	if v.DagS3Path != nil {
		ok := object.Key("DagS3Path")
		ok.String(*v.DagS3Path)
	}

	if v.EnvironmentClass != nil {
		ok := object.Key("EnvironmentClass")
		ok.String(*v.EnvironmentClass)
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.KmsKey != nil {
		ok := object.Key("KmsKey")
		ok.String(*v.KmsKey)
	}

	if v.LoggingConfiguration != nil {
		ok := object.Key("LoggingConfiguration")
		if err := awsRestjson1_serializeDocumentLoggingConfigurationInput(v.LoggingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MaxWorkers != nil {
		ok := object.Key("MaxWorkers")
		ok.Integer(*v.MaxWorkers)
	}

	if v.MinWorkers != nil {
		ok := object.Key("MinWorkers")
		ok.Integer(*v.MinWorkers)
	}

	if v.NetworkConfiguration != nil {
		ok := object.Key("NetworkConfiguration")
		if err := awsRestjson1_serializeDocumentNetworkConfiguration(v.NetworkConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PluginsS3ObjectVersion != nil {
		ok := object.Key("PluginsS3ObjectVersion")
		ok.String(*v.PluginsS3ObjectVersion)
	}

	if v.PluginsS3Path != nil {
		ok := object.Key("PluginsS3Path")
		ok.String(*v.PluginsS3Path)
	}

	if v.RequirementsS3ObjectVersion != nil {
		ok := object.Key("RequirementsS3ObjectVersion")
		ok.String(*v.RequirementsS3ObjectVersion)
	}

	if v.RequirementsS3Path != nil {
		ok := object.Key("RequirementsS3Path")
		ok.String(*v.RequirementsS3Path)
	}

	if v.Schedulers != nil {
		ok := object.Key("Schedulers")
		ok.Integer(*v.Schedulers)
	}

	if v.SourceBucketArn != nil {
		ok := object.Key("SourceBucketArn")
		ok.String(*v.SourceBucketArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.WebserverAccessMode) > 0 {
		ok := object.Key("WebserverAccessMode")
		ok.String(string(v.WebserverAccessMode))
	}

	if v.WeeklyMaintenanceWindowStart != nil {
		ok := object.Key("WeeklyMaintenanceWindowStart")
		ok.String(*v.WeeklyMaintenanceWindowStart)
	}

	return nil
}

type awsRestjson1_serializeOpCreateWebLoginToken struct {
}

func (*awsRestjson1_serializeOpCreateWebLoginToken) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateWebLoginToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWebLoginTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/webtoken/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateWebLoginTokenInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateWebLoginTokenInput(v *CreateWebLoginTokenInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteEnvironment struct {
}

func (*awsRestjson1_serializeOpDeleteEnvironment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteEnvironment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEnvironmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/environments/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteEnvironmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteEnvironmentInput(v *DeleteEnvironmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetEnvironment struct {
}

func (*awsRestjson1_serializeOpGetEnvironment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEnvironment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEnvironmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/environments/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEnvironmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEnvironmentInput(v *GetEnvironmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListEnvironments struct {
}

func (*awsRestjson1_serializeOpListEnvironments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEnvironments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEnvironmentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/environments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEnvironmentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEnvironmentsInput(v *ListEnvironmentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPublishMetrics struct {
}

func (*awsRestjson1_serializeOpPublishMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPublishMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PublishMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/metrics/environments/{EnvironmentName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPublishMetricsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPublishMetricsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPublishMetricsInput(v *PublishMetricsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member EnvironmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("EnvironmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPublishMetricsInput(v *PublishMetricsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MetricData != nil {
		ok := object.Key("MetricData")
		if err := awsRestjson1_serializeDocumentMetricData(v.MetricData, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateEnvironment struct {
}

func (*awsRestjson1_serializeOpUpdateEnvironment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateEnvironment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateEnvironmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/environments/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateEnvironmentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateEnvironmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateEnvironmentInput(v *UpdateEnvironmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateEnvironmentInput(v *UpdateEnvironmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AirflowConfigurationOptions != nil {
		ok := object.Key("AirflowConfigurationOptions")
		if err := awsRestjson1_serializeDocumentAirflowConfigurationOptions(v.AirflowConfigurationOptions, ok); err != nil {
			return err
		}
	}

	if v.AirflowVersion != nil {
		ok := object.Key("AirflowVersion")
		ok.String(*v.AirflowVersion)
	}

	if v.DagS3Path != nil {
		ok := object.Key("DagS3Path")
		ok.String(*v.DagS3Path)
	}

	if v.EnvironmentClass != nil {
		ok := object.Key("EnvironmentClass")
		ok.String(*v.EnvironmentClass)
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.LoggingConfiguration != nil {
		ok := object.Key("LoggingConfiguration")
		if err := awsRestjson1_serializeDocumentLoggingConfigurationInput(v.LoggingConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MaxWorkers != nil {
		ok := object.Key("MaxWorkers")
		ok.Integer(*v.MaxWorkers)
	}

	if v.MinWorkers != nil {
		ok := object.Key("MinWorkers")
		ok.Integer(*v.MinWorkers)
	}

	if v.NetworkConfiguration != nil {
		ok := object.Key("NetworkConfiguration")
		if err := awsRestjson1_serializeDocumentUpdateNetworkConfigurationInput(v.NetworkConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PluginsS3ObjectVersion != nil {
		ok := object.Key("PluginsS3ObjectVersion")
		ok.String(*v.PluginsS3ObjectVersion)
	}

	if v.PluginsS3Path != nil {
		ok := object.Key("PluginsS3Path")
		ok.String(*v.PluginsS3Path)
	}

	if v.RequirementsS3ObjectVersion != nil {
		ok := object.Key("RequirementsS3ObjectVersion")
		ok.String(*v.RequirementsS3ObjectVersion)
	}

	if v.RequirementsS3Path != nil {
		ok := object.Key("RequirementsS3Path")
		ok.String(*v.RequirementsS3Path)
	}

	if v.Schedulers != nil {
		ok := object.Key("Schedulers")
		ok.Integer(*v.Schedulers)
	}

	if v.SourceBucketArn != nil {
		ok := object.Key("SourceBucketArn")
		ok.String(*v.SourceBucketArn)
	}

	if len(v.WebserverAccessMode) > 0 {
		ok := object.Key("WebserverAccessMode")
		ok.String(string(v.WebserverAccessMode))
	}

	if v.WeeklyMaintenanceWindowStart != nil {
		ok := object.Key("WeeklyMaintenanceWindowStart")
		ok.String(*v.WeeklyMaintenanceWindowStart)
	}

	return nil
}

func awsRestjson1_serializeDocumentAirflowConfigurationOptions(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentDimension(v *types.Dimension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentDimensions(v []types.Dimension, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDimension(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLoggingConfigurationInput(v *types.LoggingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DagProcessingLogs != nil {
		ok := object.Key("DagProcessingLogs")
		if err := awsRestjson1_serializeDocumentModuleLoggingConfigurationInput(v.DagProcessingLogs, ok); err != nil {
			return err
		}
	}

	if v.SchedulerLogs != nil {
		ok := object.Key("SchedulerLogs")
		if err := awsRestjson1_serializeDocumentModuleLoggingConfigurationInput(v.SchedulerLogs, ok); err != nil {
			return err
		}
	}

	if v.TaskLogs != nil {
		ok := object.Key("TaskLogs")
		if err := awsRestjson1_serializeDocumentModuleLoggingConfigurationInput(v.TaskLogs, ok); err != nil {
			return err
		}
	}

	if v.WebserverLogs != nil {
		ok := object.Key("WebserverLogs")
		if err := awsRestjson1_serializeDocumentModuleLoggingConfigurationInput(v.WebserverLogs, ok); err != nil {
			return err
		}
	}

	if v.WorkerLogs != nil {
		ok := object.Key("WorkerLogs")
		if err := awsRestjson1_serializeDocumentModuleLoggingConfigurationInput(v.WorkerLogs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMetricData(v []types.MetricDatum, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMetricDatum(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMetricDatum(v *types.MetricDatum, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dimensions != nil {
		ok := object.Key("Dimensions")
		if err := awsRestjson1_serializeDocumentDimensions(v.Dimensions, ok); err != nil {
			return err
		}
	}

	if v.MetricName != nil {
		ok := object.Key("MetricName")
		ok.String(*v.MetricName)
	}

	if v.StatisticValues != nil {
		ok := object.Key("StatisticValues")
		if err := awsRestjson1_serializeDocumentStatisticSet(v.StatisticValues, ok); err != nil {
			return err
		}
	}

	if v.Timestamp != nil {
		ok := object.Key("Timestamp")
		ok.Double(smithytime.FormatEpochSeconds(*v.Timestamp))
	}

	if len(v.Unit) > 0 {
		ok := object.Key("Unit")
		ok.String(string(v.Unit))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		switch {
		case math.IsNaN(*v.Value):
			ok.String("NaN")

		case math.IsInf(*v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentModuleLoggingConfigurationInput(v *types.ModuleLoggingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if len(v.LogLevel) > 0 {
		ok := object.Key("LogLevel")
		ok.String(string(v.LogLevel))
	}

	return nil
}

func awsRestjson1_serializeDocumentNetworkConfiguration(v *types.NetworkConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsRestjson1_serializeDocumentSubnetList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentStatisticSet(v *types.StatisticSet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Maximum != nil {
		ok := object.Key("Maximum")
		switch {
		case math.IsNaN(*v.Maximum):
			ok.String("NaN")

		case math.IsInf(*v.Maximum, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Maximum, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Maximum)

		}
	}

	if v.Minimum != nil {
		ok := object.Key("Minimum")
		switch {
		case math.IsNaN(*v.Minimum):
			ok.String("NaN")

		case math.IsInf(*v.Minimum, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Minimum, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Minimum)

		}
	}

	if v.SampleCount != nil {
		ok := object.Key("SampleCount")
		ok.Integer(*v.SampleCount)
	}

	if v.Sum != nil {
		ok := object.Key("Sum")
		switch {
		case math.IsNaN(*v.Sum):
			ok.String("NaN")

		case math.IsInf(*v.Sum, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Sum, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Sum)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSubnetList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentUpdateNetworkConfigurationInput(v *types.UpdateNetworkConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	return nil
}
