// Code generated by smithy-go-codegen DO NOT EDIT.

package migrationhubstrategy

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/migrationhubstrategy/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the configuration of an application component.
func (c *Client) UpdateApplicationComponentConfig(ctx context.Context, params *UpdateApplicationComponentConfigInput, optFns ...func(*Options)) (*UpdateApplicationComponentConfigOutput, error) {
	if params == nil {
		params = &UpdateApplicationComponentConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateApplicationComponentConfig", params, optFns, c.addOperationUpdateApplicationComponentConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateApplicationComponentConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateApplicationComponentConfigInput struct {

	// The ID of the application component. The ID is unique within an AWS account.
	//
	// This member is required.
	ApplicationComponentId *string

	// Indicates whether the application component has been included for server
	// recommendation or not.
	InclusionStatus types.InclusionStatus

	// Database credentials.
	SecretsManagerKey *string

	// The list of source code configurations to update for the application component.
	SourceCodeList []types.SourceCode

	// The preferred strategy options for the application component. Use values from
	// the GetApplicationComponentStrategies response.
	StrategyOption *types.StrategyOption

	noSmithyDocumentSerde
}

type UpdateApplicationComponentConfigOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateApplicationComponentConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateApplicationComponentConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateApplicationComponentConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateApplicationComponentConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateApplicationComponentConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateApplicationComponentConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "migrationhub-strategy",
		OperationName: "UpdateApplicationComponentConfig",
	}
}
