// Code generated by smithy-go-codegen DO NOT EDIT.

package lookoutequipment

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lookoutequipment/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Provides a JSON containing the overall information about a specific ML model,
// including model name and ARN, dataset, training and evaluation information,
// status, and so on.
func (c *Client) DescribeModel(ctx context.Context, params *DescribeModelInput, optFns ...func(*Options)) (*DescribeModelOutput, error) {
	if params == nil {
		params = &DescribeModelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeModel", params, optFns, c.addOperationDescribeModelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeModelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeModelInput struct {

	// The name of the ML model to be described.
	//
	// This member is required.
	ModelName *string

	noSmithyDocumentSerde
}

type DescribeModelOutput struct {

	// Indicates the time and date at which the ML model was created.
	CreatedAt *time.Time

	// The configuration is the TargetSamplingRate, which is the sampling rate of the
	// data after post processing by Amazon Lookout for Equipment. For example, if you
	// provide data that has been collected at a 1 second level and you want the system
	// to resample the data at a 1 minute rate before training, the TargetSamplingRate
	// is 1 minute. When providing a value for the TargetSamplingRate, you must attach
	// the prefix "PT" to the rate you want. The value for a 1 second rate is therefore
	// PT1S, the value for a 15 minute rate is PT15M, and the value for a 1 hour rate
	// is PT1H
	DataPreProcessingConfiguration *types.DataPreProcessingConfiguration

	// The Amazon Resouce Name (ARN) of the dataset used to create the ML model being
	// described.
	DatasetArn *string

	// The name of the dataset being used by the ML being described.
	DatasetName *string

	// Indicates the time reference in the dataset that was used to end the subset of
	// evaluation data for the ML model.
	EvaluationDataEndTime *time.Time

	// Indicates the time reference in the dataset that was used to begin the subset of
	// evaluation data for the ML model.
	EvaluationDataStartTime *time.Time

	// If the training of the ML model failed, this indicates the reason for that
	// failure.
	FailedReason *string

	// Specifies configuration information about the labels input, including its S3
	// location.
	LabelsInputConfiguration *types.LabelsInputConfiguration

	// Indicates the last time the ML model was updated. The type of update is not
	// specified.
	LastUpdatedTime *time.Time

	// The Amazon Resource Name (ARN) of the ML model being described.
	ModelArn *string

	// The Model Metrics show an aggregated summary of the model's performance within
	// the evaluation time range. This is the JSON content of the metrics created when
	// evaluating the model.
	//
	// This value conforms to the media type: application/json
	ModelMetrics *string

	// The name of the ML model being described.
	ModelName *string

	// Indicates that the asset associated with this sensor has been shut off. As long
	// as this condition is met, Lookout for Equipment will not use data from this
	// asset for training, evaluation, or inference.
	OffCondition *string

	// The Amazon Resource Name (ARN) of a role with permission to access the data
	// source for the ML model being described.
	RoleArn *string

	// A JSON description of the data that is in each time series dataset, including
	// names, column names, and data types.
	//
	// This value conforms to the media type: application/json
	Schema *string

	// Provides the identifier of the KMS key used to encrypt model data by Amazon
	// Lookout for Equipment.
	ServerSideKmsKeyId *string

	// Specifies the current status of the model being described. Status describes the
	// status of the most recent action of the model.
	Status types.ModelStatus

	// Indicates the time reference in the dataset that was used to end the subset of
	// training data for the ML model.
	TrainingDataEndTime *time.Time

	// Indicates the time reference in the dataset that was used to begin the subset of
	// training data for the ML model.
	TrainingDataStartTime *time.Time

	// Indicates the time at which the training of the ML model was completed.
	TrainingExecutionEndTime *time.Time

	// Indicates the time at which the training of the ML model began.
	TrainingExecutionStartTime *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeModelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeModel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeModel{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeModelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeModel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeModel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "lookoutequipment",
		OperationName: "DescribeModel",
	}
}
