// Code generated by smithy-go-codegen DO NOT EDIT.

package costexplorer

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deletes a Cost Category. Expenses from this month going forward will no longer
// be categorized with this Cost Category.
func (c *Client) DeleteCostCategoryDefinition(ctx context.Context, params *DeleteCostCategoryDefinitionInput, optFns ...func(*Options)) (*DeleteCostCategoryDefinitionOutput, error) {
	if params == nil {
		params = &DeleteCostCategoryDefinitionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteCostCategoryDefinition", params, optFns, c.addOperationDeleteCostCategoryDefinitionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteCostCategoryDefinitionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteCostCategoryDefinitionInput struct {

	// The unique identifier for your Cost Category.
	//
	// This member is required.
	CostCategoryArn *string

	noSmithyDocumentSerde
}

type DeleteCostCategoryDefinitionOutput struct {

	// The unique identifier for your Cost Category.
	CostCategoryArn *string

	// The effective end date of the Cost Category as a result of deleting it. No costs
	// after this date is categorized by the deleted Cost Category.
	EffectiveEnd *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteCostCategoryDefinitionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDeleteCostCategoryDefinition{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDeleteCostCategoryDefinition{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDeleteCostCategoryDefinitionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteCostCategoryDefinition(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteCostCategoryDefinition(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ce",
		OperationName: "DeleteCostCategoryDefinition",
	}
}
