// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Answering Machine Detection config
type AnswerMachineDetectionConfig struct {

	// Enable or disable answering machine detection
	//
	// This member is required.
	EnableAnswerMachineDetection *bool

	noSmithyDocumentSerde
}

// An Amazon Connect campaign.
type Campaign struct {

	// The resource name of an Amazon Connect campaign.
	//
	// This member is required.
	Arn *string

	// Amazon Connect Instance Id
	//
	// This member is required.
	ConnectInstanceId *string

	// The possible types of dialer config parameters
	//
	// This member is required.
	DialerConfig DialerConfig

	// Identifier representing a Campaign
	//
	// This member is required.
	Id *string

	// The name of an Amazon Connect Campaign name.
	//
	// This member is required.
	Name *string

	// The configuration used for outbound calls.
	//
	// This member is required.
	OutboundCallConfig *OutboundCallConfig

	// Tag map with key and value.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Filter model by type
type CampaignFilters struct {

	// Connect instance identifier filter
	InstanceIdFilter *InstanceIdFilter

	noSmithyDocumentSerde
}

// An Amazon Connect campaign summary.
type CampaignSummary struct {

	// The resource name of an Amazon Connect campaign.
	//
	// This member is required.
	Arn *string

	// Amazon Connect Instance Id
	//
	// This member is required.
	ConnectInstanceId *string

	// Identifier representing a Campaign
	//
	// This member is required.
	Id *string

	// The name of an Amazon Connect Campaign name.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The possible types of dialer config parameters
//
// The following types satisfy this interface:
//
//	DialerConfigMemberPredictiveDialerConfig
//	DialerConfigMemberProgressiveDialerConfig
type DialerConfig interface {
	isDialerConfig()
}

// Predictive Dialer config
type DialerConfigMemberPredictiveDialerConfig struct {
	Value PredictiveDialerConfig

	noSmithyDocumentSerde
}

func (*DialerConfigMemberPredictiveDialerConfig) isDialerConfig() {}

// Progressive Dialer config
type DialerConfigMemberProgressiveDialerConfig struct {
	Value ProgressiveDialerConfig

	noSmithyDocumentSerde
}

func (*DialerConfigMemberProgressiveDialerConfig) isDialerConfig() {}

// A dial request for a campaign.
type DialRequest struct {

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in contact flows just like any
	// other contact attributes.
	//
	// This member is required.
	Attributes map[string]string

	// Client provided parameter used for idempotency. Its value must be unique for
	// each request.
	//
	// This member is required.
	ClientToken *string

	// Timestamp with no UTC offset or timezone
	//
	// This member is required.
	ExpirationTime *time.Time

	// The phone number of the customer, in E.164 format.
	//
	// This member is required.
	PhoneNumber *string

	noSmithyDocumentSerde
}

// Encryption config for Connect Instance. Note that sensitive data will always be
// encrypted. If disabled, service will perform encryption with its own key. If
// enabled, a KMS key id needs to be provided and KMS charges will apply. KMS is
// only type supported
type EncryptionConfig struct {

	// Boolean to indicate if custom encryption has been enabled.
	//
	// This member is required.
	Enabled bool

	// Server-side encryption type.
	EncryptionType EncryptionType

	// KMS key id/arn for encryption config.
	KeyArn *string

	noSmithyDocumentSerde
}

// Failed response of campaign state
type FailedCampaignStateResponse struct {

	// Identifier representing a Campaign
	CampaignId *string

	// A predefined code indicating the error that caused the failure in getting state
	// of campaigns
	FailureCode GetCampaignStateBatchFailureCode

	noSmithyDocumentSerde
}

// A failed request identified by the unique client token.
type FailedRequest struct {

	// Client provided parameter used for idempotency. Its value must be unique for
	// each request.
	ClientToken *string

	// A predefined code indicating the error that caused the failure.
	FailureCode FailureCode

	// Identifier representing a Dial request
	Id *string

	noSmithyDocumentSerde
}

// Instance config object
type InstanceConfig struct {

	// Amazon Connect Instance Id
	//
	// This member is required.
	ConnectInstanceId *string

	// Encryption config for Connect Instance. Note that sensitive data will always be
	// encrypted. If disabled, service will perform encryption with its own key. If
	// enabled, a KMS key id needs to be provided and KMS charges will apply. KMS is
	// only type supported
	//
	// This member is required.
	EncryptionConfig *EncryptionConfig

	// Service linked role arn
	//
	// This member is required.
	ServiceLinkedRoleArn *string

	noSmithyDocumentSerde
}

// Connect instance identifier filter
type InstanceIdFilter struct {

	// Operators for Connect instance identifier filter
	//
	// This member is required.
	Operator InstanceIdFilterOperator

	// Amazon Connect Instance Id
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Instance onboarding job status object
type InstanceOnboardingJobStatus struct {

	// Amazon Connect Instance Id
	//
	// This member is required.
	ConnectInstanceId *string

	// Enumeration of the possible states for instance onboarding job
	//
	// This member is required.
	Status InstanceOnboardingJobStatusCode

	// Enumeration of the possible failure codes for instance onboarding job
	FailureCode InstanceOnboardingJobFailureCode

	noSmithyDocumentSerde
}

// The configuration used for outbound calls.
type OutboundCallConfig struct {

	// The identifier of the contact flow for the outbound call.
	//
	// This member is required.
	ConnectContactFlowId *string

	// The queue for the call. If you specify a queue, the phone displayed for caller
	// ID is the phone number specified in the queue. If you do not specify a queue,
	// the queue defined in the contact flow is used. If you do not specify a queue,
	// you must specify a source phone number.
	//
	// This member is required.
	ConnectQueueId *string

	// Answering Machine Detection config
	AnswerMachineDetectionConfig *AnswerMachineDetectionConfig

	// The phone number associated with the Amazon Connect instance, in E.164 format.
	// If you do not specify a source phone number, you must specify a queue.
	ConnectSourcePhoneNumber *string

	noSmithyDocumentSerde
}

// Predictive Dialer config
type PredictiveDialerConfig struct {

	// The bandwidth allocation of a queue resource.
	//
	// This member is required.
	BandwidthAllocation *float64

	noSmithyDocumentSerde
}

// Progressive Dialer config
type ProgressiveDialerConfig struct {

	// The bandwidth allocation of a queue resource.
	//
	// This member is required.
	BandwidthAllocation *float64

	noSmithyDocumentSerde
}

// Successful response of campaign state
type SuccessfulCampaignStateResponse struct {

	// Identifier representing a Campaign
	CampaignId *string

	// State of a campaign
	State CampaignState

	noSmithyDocumentSerde
}

// A successful request identified by the unique client token.
type SuccessfulRequest struct {

	// Client provided parameter used for idempotency. Its value must be unique for
	// each request.
	ClientToken *string

	// Identifier representing a Dial request
	Id *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isDialerConfig() {}
