// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Returns information about an event that has triggered a notification rule.
type EventTypeSummary struct {

	// The system-generated ID of the event. For a complete list of event types and
	// IDs, see Notification concepts
	// (https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api)
	// in the Developer Tools Console User Guide.
	EventTypeId *string

	// The name of the event.
	EventTypeName *string

	// The resource type of the event.
	ResourceType *string

	// The name of the service for which the event applies.
	ServiceName *string

	noSmithyDocumentSerde
}

// Information about a filter to apply to the list of returned event types. You can
// filter by resource type or service name.
type ListEventTypesFilter struct {

	// The system-generated name of the filter type you want to filter by.
	//
	// This member is required.
	Name ListEventTypesFilterName

	// The name of the resource type (for example, pipeline) or service name (for
	// example, CodePipeline) that you want to filter by.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Information about a filter to apply to the list of returned notification rules.
// You can filter by event type, owner, resource, or target.
type ListNotificationRulesFilter struct {

	// The name of the attribute you want to use to filter the returned notification
	// rules.
	//
	// This member is required.
	Name ListNotificationRulesFilterName

	// The value of the attribute you want to use to filter the returned notification
	// rules. For example, if you specify filtering by RESOURCE in Name, you might
	// specify the ARN of a pipeline in CodePipeline for the value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Information about a filter to apply to the list of returned targets. You can
// filter by target type, address, or status. For example, to filter results to
// notification rules that have active Chatbot topics as targets, you could specify
// a ListTargetsFilter Name as TargetType and a Value of SNS, and a Name of
// TARGET_STATUS and a Value of ACTIVE.
type ListTargetsFilter struct {

	// The name of the attribute you want to use to filter the returned targets.
	//
	// This member is required.
	Name ListTargetsFilterName

	// The value of the attribute you want to use to filter the returned targets. For
	// example, if you specify SNS for the Target type, you could specify an Amazon
	// Resource Name (ARN) for a topic as the value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Information about a specified notification rule.
type NotificationRuleSummary struct {

	// The Amazon Resource Name (ARN) of the notification rule.
	Arn *string

	// The unique ID of the notification rule.
	Id *string

	noSmithyDocumentSerde
}

// Information about the Chatbot topics or Chatbot clients associated with a
// notification rule.
type Target struct {

	// The Amazon Resource Name (ARN) of the Chatbot topic or Chatbot client.
	TargetAddress *string

	// The target type. Can be an Chatbot topic or Chatbot client.
	//
	// * Chatbot topics
	// are specified as SNS.
	//
	// * Chatbot clients are specified as AWSChatbotSlack.
	TargetType *string

	noSmithyDocumentSerde
}

// Information about the targets specified for a notification rule.
type TargetSummary struct {

	// The Amazon Resource Name (ARN) of the Chatbot topic or Chatbot client.
	TargetAddress *string

	// The status of the target.
	TargetStatus TargetStatus

	// The type of the target (for example, SNS).
	//
	// * Chatbot topics are specified as
	// SNS.
	//
	// * Chatbot clients are specified as AWSChatbotSlack.
	TargetType *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
