// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about any jobs for AWS CodePipeline to act on. PollForJobs
// is valid only for action types with "Custom" in the owner field. If the action
// type contains "AWS" or "ThirdParty" in the owner field, the PollForJobs action
// returns an error. When this API is called, AWS CodePipeline returns temporary
// credentials for the S3 bucket used to store artifacts for the pipeline, if the
// action requires access to that S3 bucket for input or output artifacts. This API
// also returns any secret values defined for the action.
func (c *Client) PollForJobs(ctx context.Context, params *PollForJobsInput, optFns ...func(*Options)) (*PollForJobsOutput, error) {
	if params == nil {
		params = &PollForJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PollForJobs", params, optFns, c.addOperationPollForJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PollForJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a PollForJobs action.
type PollForJobsInput struct {

	// Represents information about an action type.
	//
	// This member is required.
	ActionTypeId *types.ActionTypeId

	// The maximum number of jobs to return in a poll for jobs call.
	MaxBatchSize *int32

	// A map of property names and values. For an action type with no queryable
	// properties, this value must be null or an empty map. For an action type with a
	// queryable property, you must supply that property as a key in the map. Only jobs
	// whose action configuration matches the mapped value are returned.
	QueryParam map[string]string

	noSmithyDocumentSerde
}

// Represents the output of a PollForJobs action.
type PollForJobsOutput struct {

	// Information about the jobs to take action on.
	Jobs []types.Job

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPollForJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpPollForJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpPollForJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPollForJobsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPollForJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPollForJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "codepipeline",
		OperationName: "PollForJobs",
	}
}
