// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The response of ConfigureAgent
// (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html)
// that specifies if an agent profiles or not and for how long to return profiling
// data.
type AgentConfiguration struct {

	// How long a profiling agent should send profiling data using ConfigureAgent
	// (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html).
	// For example, if this is set to 300, the profiling agent calls ConfigureAgent
	// (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html)
	// every 5 minutes to submit the profiled data collected during that period.
	//
	// This member is required.
	PeriodInSeconds *int32

	// A Boolean that specifies whether the profiling agent collects profiling data or
	// not. Set to true to enable profiling.
	//
	// This member is required.
	ShouldProfile *bool

	// Parameters used by the profiler. The valid parameters are:
	//
	// * MaxStackDepth -
	// The maximum depth of the stacks in the code that is represented in the profile.
	// For example, if CodeGuru Profiler finds a method A, which calls method B, which
	// calls method C, which calls method D, then the depth is 4. If the maxDepth is
	// set to 2, then the profiler evaluates A and B.
	//
	// * MemoryUsageLimitPercent - The
	// percentage of memory that is used by the profiler.
	//
	// *
	// MinimumTimeForReportingInMilliseconds - The minimum time in milliseconds between
	// sending reports.
	//
	// * ReportingIntervalInMilliseconds - The reporting interval in
	// milliseconds used to report profiles.
	//
	// * SamplingIntervalInMilliseconds - The
	// sampling interval in milliseconds that is used to profile samples.
	AgentParameters map[string]string

	noSmithyDocumentSerde
}

// Specifies whether profiling is enabled or disabled for a profiling group. It is
// used by ConfigureAgent
// (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html)
// to enable or disable profiling for a profiling group.
type AgentOrchestrationConfig struct {

	// A Boolean that specifies whether the profiling agent collects profiling data or
	// not. Set to true to enable profiling.
	//
	// This member is required.
	ProfilingEnabled *bool

	noSmithyDocumentSerde
}

// Specifies the aggregation period and aggregation start time for an aggregated
// profile. An aggregated profile is used to collect posted agent profiles during
// an aggregation period. There are three possible aggregation periods (1 day, 1
// hour, or 5 minutes).
type AggregatedProfileTime struct {

	// The aggregation period. This indicates the period during which an aggregation
	// profile collects posted agent profiles for a profiling group. Use one of three
	// valid durations that are specified using the ISO 8601 format.
	//
	// * P1D — 1 day
	//
	// *
	// PT1H — 1 hour
	//
	// * PT5M — 5 minutes
	Period AggregationPeriod

	// The time that aggregation of posted agent profiles for a profiling group starts.
	// The aggregation profile contains profiles posted by the agent starting at this
	// time for an aggregation period specified by the period property of the
	// AggregatedProfileTime object. Specify start using the ISO 8601 format. For
	// example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
	// 1:15:02 PM UTC.
	Start *time.Time

	noSmithyDocumentSerde
}

// Details about an anomaly in a specific metric of application profile. The
// anomaly is detected using analysis of the metric data over a period of time.
type Anomaly struct {

	// A list of the instances of the detected anomalies during the requested period.
	//
	// This member is required.
	Instances []AnomalyInstance

	// Details about the metric that the analysis used when it detected the anomaly.
	// The metric includes the name of the frame that was analyzed with the type and
	// thread states used to derive the metric value for that frame.
	//
	// This member is required.
	Metric *Metric

	// The reason for which metric was flagged as anomalous.
	//
	// This member is required.
	Reason *string

	noSmithyDocumentSerde
}

// The specific duration in which the metric is flagged as anomalous.
type AnomalyInstance struct {

	// The universally unique identifier (UUID) of an instance of an anomaly in a
	// metric.
	//
	// This member is required.
	Id *string

	// The start time of the period during which the metric is flagged as anomalous.
	// This is specified using the ISO 8601 format. For example,
	// 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM
	// UTC.
	//
	// This member is required.
	StartTime *time.Time

	// The end time of the period during which the metric is flagged as anomalous. This
	// is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
	// represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	EndTime *time.Time

	// Feedback type on a specific instance of anomaly submitted by the user.
	UserFeedback *UserFeedback

	noSmithyDocumentSerde
}

// Notification medium for users to get alerted for events that occur in
// application profile. We support SNS topic as a notification channel.
type Channel struct {

	// List of publishers for different type of events that may be detected in an
	// application from the profile. Anomaly detection is the only event publisher in
	// Profiler.
	//
	// This member is required.
	EventPublishers []EventPublisher

	// Unique arn of the resource to be used for notifications. We support a valid SNS
	// topic arn as a channel uri.
	//
	// This member is required.
	Uri *string

	// Unique identifier for each Channel in the notification configuration of a
	// Profiling Group. A random UUID for channelId is used when adding a channel to
	// the notification configuration if not specified in the request.
	Id *string

	noSmithyDocumentSerde
}

// Information about potential recommendations that might be created from the
// analysis of profiling data.
type FindingsReportSummary struct {

	// The universally unique identifier (UUID) of the recommendation report.
	Id *string

	// The end time of the period during which the metric is flagged as anomalous. This
	// is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z
	// represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
	ProfileEndTime *time.Time

	// The start time of the profile the analysis data is about. This is specified
	// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
	// millisecond past June 1, 2020 1:15:02 PM UTC.
	ProfileStartTime *time.Time

	// The name of the profiling group that is associated with the analysis data.
	ProfilingGroupName *string

	// The total number of different recommendations that were found by the analysis.
	TotalNumberOfFindings *int32

	noSmithyDocumentSerde
}

// The frame name, metric type, and thread states. These are used to derive the
// value of the metric for the frame.
type FrameMetric struct {

	// Name of the method common across the multiple occurrences of a frame in an
	// application profile.
	//
	// This member is required.
	FrameName *string

	// List of application runtime thread states used to get the counts for a frame a
	// derive a metric value.
	//
	// This member is required.
	ThreadStates []string

	// A type of aggregation that specifies how a metric for a frame is analyzed. The
	// supported value AggregatedRelativeTotalTime is an aggregation of the metric
	// value for one frame that is calculated across the occurrences of all frames in a
	// profile.
	//
	// This member is required.
	Type MetricType

	noSmithyDocumentSerde
}

// Information about a frame metric and its values.
type FrameMetricDatum struct {

	// The frame name, metric type, and thread states. These are used to derive the
	// value of the metric for the frame.
	//
	// This member is required.
	FrameMetric *FrameMetric

	// A list of values that are associated with a frame metric.
	//
	// This member is required.
	Values []float64

	noSmithyDocumentSerde
}

// The part of a profile that contains a recommendation found during analysis.
type Match struct {

	// The location in the profiling graph that contains a recommendation found during
	// analysis.
	FrameAddress *string

	// The target frame that triggered a match.
	TargetFramesIndex *int32

	// The value in the profile data that exceeded the recommendation threshold.
	ThresholdBreachValue *float64

	noSmithyDocumentSerde
}

// Details about the metric that the analysis used when it detected the anomaly.
// The metric what is analyzed to create recommendations. It includes the name of
// the frame that was analyzed and the type and thread states used to derive the
// metric value for that frame.
type Metric struct {

	// The name of the method that appears as a frame in any stack in a profile.
	//
	// This member is required.
	FrameName *string

	// The list of application runtime thread states that is used to calculate the
	// metric value for the frame.
	//
	// This member is required.
	ThreadStates []string

	// A type that specifies how a metric for a frame is analyzed. The supported value
	// AggregatedRelativeTotalTime is an aggregation of the metric value for one frame
	// that is calculated across the occurences of all frames in a profile.
	//
	// This member is required.
	Type MetricType

	noSmithyDocumentSerde
}

// The configuration for notifications stored for each profiling group. This
// includes up to to two channels and a list of event publishers associated with
// each channel.
type NotificationConfiguration struct {

	// List of up to two channels to be used for sending notifications for events
	// detected from the application profile.
	Channels []Channel

	noSmithyDocumentSerde
}

// A set of rules used to make a recommendation during an analysis.
type Pattern struct {

	// A list of the different counters used to determine if there is a match.
	CountersToAggregate []string

	// The description of the recommendation. This explains a potential inefficiency in
	// a profiled application.
	Description *string

	// The universally unique identifier (UUID) of this pattern.
	Id *string

	// The name for this pattern.
	Name *string

	// A string that contains the steps recommended to address the potential
	// inefficiency.
	ResolutionSteps *string

	// A list of frame names that were searched during the analysis that generated a
	// recommendation.
	TargetFrames [][]string

	// The percentage of time an application spends in one method that triggers a
	// recommendation. The percentage of time is the same as the percentage of the
	// total gathered sample counts during analysis.
	ThresholdPercent float64

	noSmithyDocumentSerde
}

// Contains the start time of a profile.
type ProfileTime struct {

	// The start time of a profile. It is specified using the ISO 8601 format. For
	// example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
	// 1:15:02 PM UTC.
	Start *time.Time

	noSmithyDocumentSerde
}

// Contains information about a profiling group.
type ProfilingGroupDescription struct {

	// An AgentOrchestrationConfig
	// (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html)
	// object that indicates if the profiling group is enabled for profiled or not.
	AgentOrchestrationConfig *AgentOrchestrationConfig

	// The Amazon Resource Name (ARN) identifying the profiling group resource.
	Arn *string

	// The compute platform of the profiling group. If it is set to AWSLambda, then the
	// profiled application runs on AWS Lambda. If it is set to Default, then the
	// profiled application runs on a compute platform that is not AWS Lambda, such an
	// Amazon EC2 instance, an on-premises server, or a different platform. The default
	// is Default.
	ComputePlatform ComputePlatform

	// The time when the profiling group was created. Specify using the ISO 8601
	// format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June
	// 1, 2020 1:15:02 PM UTC.
	CreatedAt *time.Time

	// The name of the profiling group.
	Name *string

	// A ProfilingStatus
	// (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html)
	// object that includes information about the last time a profile agent pinged
	// back, the last time a profile was received, and the aggregation period and start
	// time for the most recent aggregated profile.
	ProfilingStatus *ProfilingStatus

	// A list of the tags that belong to this profiling group.
	Tags map[string]string

	// The date and time when the profiling group was last updated. Specify using the
	// ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond
	// past June 1, 2020 1:15:02 PM UTC.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Profiling status includes information about the last time a profile agent pinged
// back, the last time a profile was received, and the aggregation period and start
// time for the most recent aggregated profile.
type ProfilingStatus struct {

	// The date and time when the profiling agent most recently pinged back. Specify
	// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
	// millisecond past June 1, 2020 1:15:02 PM UTC.
	LatestAgentOrchestratedAt *time.Time

	// The date and time when the most recent profile was received. Specify using the
	// ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond
	// past June 1, 2020 1:15:02 PM UTC.
	LatestAgentProfileReportedAt *time.Time

	// An AggregatedProfileTime
	// (https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html)
	// object that contains the aggregation period and start time for an aggregated
	// profile.
	LatestAggregatedProfile *AggregatedProfileTime

	noSmithyDocumentSerde
}

// A potential improvement that was found from analyzing the profiling data.
type Recommendation struct {

	// How many different places in the profile graph triggered a match.
	//
	// This member is required.
	AllMatchesCount *int32

	// How much of the total sample count is potentially affected.
	//
	// This member is required.
	AllMatchesSum *float64

	// End time of the profile that was used by this analysis. This is specified using
	// the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
	// millisecond past June 1, 2020 1:15:02 PM UTC.
	//
	// This member is required.
	EndTime *time.Time

	// The pattern that analysis recognized in the profile to make this recommendation.
	//
	// This member is required.
	Pattern *Pattern

	// The start time of the profile that was used by this analysis. This is specified
	// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
	// millisecond past June 1, 2020 1:15:02 PM UTC.
	//
	// This member is required.
	StartTime *time.Time

	// List of the matches with most impact.
	//
	// This member is required.
	TopMatches []Match

	noSmithyDocumentSerde
}

// A data type that contains a Timestamp object. This is specified using the ISO
// 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past
// June 1, 2020 1:15:02 PM UTC.
type TimestampStructure struct {

	// A Timestamp. This is specified using the ISO 8601 format. For example,
	// 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM
	// UTC.
	//
	// This member is required.
	Value *time.Time

	noSmithyDocumentSerde
}

// Feedback that can be submitted for each instance of an anomaly by the user.
// Feedback is be used for improvements in generating recommendations for the
// application.
type UserFeedback struct {

	// Optional Positive or Negative feedback submitted by the user about whether the
	// recommendation is useful or not.
	//
	// This member is required.
	Type FeedbackType

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
