// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Information about an alarm.
type Alarm struct {

	// The name of the alarm. Maximum length is 255 characters. Each alarm name can be
	// used only once in a list of alarms.
	Name *string

	noSmithyDocumentSerde
}

// Information about alarms associated with a deployment or deployment group.
type AlarmConfiguration struct {

	// A list of alarms configured for the deployment or deployment group. A maximum of
	// 10 alarms can be added.
	Alarms []Alarm

	// Indicates whether the alarm configuration is enabled.
	Enabled bool

	// Indicates whether a deployment should continue if information about the current
	// state of alarms cannot be retrieved from Amazon CloudWatch. The default value is
	// false.
	//
	// * true: The deployment proceeds even if alarm status information can't
	// be retrieved from Amazon CloudWatch.
	//
	// * false: The deployment stops if alarm
	// status information can't be retrieved from Amazon CloudWatch.
	IgnorePollAlarmFailure bool

	noSmithyDocumentSerde
}

// Information about an application.
type ApplicationInfo struct {

	// The application ID.
	ApplicationId *string

	// The application name.
	ApplicationName *string

	// The destination platform type for deployment of the application (Lambda or
	// Server).
	ComputePlatform ComputePlatform

	// The time at which the application was created.
	CreateTime *time.Time

	// The name for a connection to a GitHub account.
	GitHubAccountName *string

	// True if the user has authenticated with GitHub for the specified application.
	// Otherwise, false.
	LinkedToGitHub bool

	noSmithyDocumentSerde
}

// A revision for an Lambda or Amazon ECS deployment that is a YAML-formatted or
// JSON-formatted string. For Lambda and Amazon ECS deployments, the revision is
// the same as the AppSpec file. This method replaces the deprecated RawString data
// type.
type AppSpecContent struct {

	// The YAML-formatted or JSON-formatted revision string. For an Lambda deployment,
	// the content includes a Lambda function name, the alias for its original version,
	// and the alias for its replacement version. The deployment shifts traffic from
	// the original version of the Lambda function to the replacement version. For an
	// Amazon ECS deployment, the content includes the task name, information about the
	// load balancer that serves traffic to the container, and more. For both types of
	// deployments, the content can specify Lambda functions that run at specified
	// hooks, such as BeforeInstall, during a deployment.
	Content *string

	// The SHA256 hash value of the revision content.
	Sha256 *string

	noSmithyDocumentSerde
}

// Information about a configuration for automatically rolling back to a previous
// version of an application revision when a deployment is not completed
// successfully.
type AutoRollbackConfiguration struct {

	// Indicates whether a defined automatic rollback configuration is currently
	// enabled.
	Enabled bool

	// The event type or types that trigger a rollback.
	Events []AutoRollbackEvent

	noSmithyDocumentSerde
}

// Information about an Auto Scaling group.
type AutoScalingGroup struct {

	// An Auto Scaling lifecycle event hook name.
	Hook *string

	// The Auto Scaling group name.
	Name *string

	noSmithyDocumentSerde
}

// Information about blue/green deployment options for a deployment group.
type BlueGreenDeploymentConfiguration struct {

	// Information about the action to take when newly provisioned instances are ready
	// to receive traffic in a blue/green deployment.
	DeploymentReadyOption *DeploymentReadyOption

	// Information about how instances are provisioned for a replacement environment in
	// a blue/green deployment.
	GreenFleetProvisioningOption *GreenFleetProvisioningOption

	// Information about whether to terminate instances in the original fleet during a
	// blue/green deployment.
	TerminateBlueInstancesOnDeploymentSuccess *BlueInstanceTerminationOption

	noSmithyDocumentSerde
}

// Information about whether instances in the original environment are terminated
// when a blue/green deployment is successful. BlueInstanceTerminationOption does
// not apply to Lambda deployments.
type BlueInstanceTerminationOption struct {

	// The action to take on instances in the original environment after a successful
	// blue/green deployment.
	//
	// * TERMINATE: Instances are terminated after a specified
	// wait time.
	//
	// * KEEP_ALIVE: Instances are left running after they are deregistered
	// from the load balancer and removed from the deployment group.
	Action InstanceAction

	// For an Amazon EC2 deployment, the number of minutes to wait after a successful
	// blue/green deployment before terminating instances from the original
	// environment. For an Amazon ECS deployment, the number of minutes before deleting
	// the original (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts
	// traffic from the original (blue) task set to a replacement (green) task set. The
	// maximum setting is 2880 minutes (2 days).
	TerminationWaitTimeInMinutes int32

	noSmithyDocumentSerde
}

// Information about the target to be updated by an CloudFormation blue/green
// deployment. This target type is used for all deployments initiated by a
// CloudFormation stack update.
type CloudFormationTarget struct {

	// The unique ID of an CloudFormation blue/green deployment.
	DeploymentId *string

	// The date and time when the target application was updated by an CloudFormation
	// blue/green deployment.
	LastUpdatedAt *time.Time

	// The lifecycle events of the CloudFormation blue/green deployment to this target
	// application.
	LifecycleEvents []LifecycleEvent

	// The resource type for the CloudFormation blue/green deployment.
	ResourceType *string

	// The status of an CloudFormation blue/green deployment's target application.
	Status TargetStatus

	// The unique ID of a deployment target that has a type of CloudFormationTarget.
	TargetId *string

	// The percentage of production traffic that the target version of an
	// CloudFormation blue/green deployment receives.
	TargetVersionWeight float64

	noSmithyDocumentSerde
}

// Information about a deployment configuration.
type DeploymentConfigInfo struct {

	// The destination platform type for the deployment (Lambda, Server, or ECS).
	ComputePlatform ComputePlatform

	// The time at which the deployment configuration was created.
	CreateTime *time.Time

	// The deployment configuration ID.
	DeploymentConfigId *string

	// The deployment configuration name.
	DeploymentConfigName *string

	// Information about the number or percentage of minimum healthy instance.
	MinimumHealthyHosts *MinimumHealthyHosts

	// The configuration that specifies how the deployment traffic is routed. Used for
	// deployments with a Lambda or Amazon ECS compute platform only.
	TrafficRoutingConfig *TrafficRoutingConfig

	noSmithyDocumentSerde
}

// Information about a deployment group.
type DeploymentGroupInfo struct {

	// A list of alarms associated with the deployment group.
	AlarmConfiguration *AlarmConfiguration

	// The application name.
	ApplicationName *string

	// Information about the automatic rollback configuration associated with the
	// deployment group.
	AutoRollbackConfiguration *AutoRollbackConfiguration

	// A list of associated Auto Scaling groups.
	AutoScalingGroups []AutoScalingGroup

	// Information about blue/green deployment options for a deployment group.
	BlueGreenDeploymentConfiguration *BlueGreenDeploymentConfiguration

	// The destination platform type for the deployment (Lambda, Server, or ECS).
	ComputePlatform ComputePlatform

	// The deployment configuration name.
	DeploymentConfigName *string

	// The deployment group ID.
	DeploymentGroupId *string

	// The deployment group name.
	DeploymentGroupName *string

	// Information about the type of deployment, either in-place or blue/green, you
	// want to run and whether to route deployment traffic behind a load balancer.
	DeploymentStyle *DeploymentStyle

	// The Amazon EC2 tags on which to filter. The deployment group includes EC2
	// instances with any of the specified tags.
	Ec2TagFilters []EC2TagFilter

	// Information about groups of tags applied to an Amazon EC2 instance. The
	// deployment group includes only Amazon EC2 instances identified by all of the tag
	// groups. Cannot be used in the same call as ec2TagFilters.
	Ec2TagSet *EC2TagSet

	// The target Amazon ECS services in the deployment group. This applies only to
	// deployment groups that use the Amazon ECS compute platform. A target Amazon ECS
	// service is specified as an Amazon ECS cluster and service name pair using the
	// format :.
	EcsServices []ECSService

	// Information about the most recent attempted deployment to the deployment group.
	LastAttemptedDeployment *LastDeploymentInfo

	// Information about the most recent successful deployment to the deployment group.
	LastSuccessfulDeployment *LastDeploymentInfo

	// Information about the load balancer to use in a deployment.
	LoadBalancerInfo *LoadBalancerInfo

	// The on-premises instance tags on which to filter. The deployment group includes
	// on-premises instances with any of the specified tags.
	OnPremisesInstanceTagFilters []TagFilter

	// Information about groups of tags applied to an on-premises instance. The
	// deployment group includes only on-premises instances identified by all the tag
	// groups. Cannot be used in the same call as onPremisesInstanceTagFilters.
	OnPremisesTagSet *OnPremisesTagSet

	// Indicates what happens when new Amazon EC2 instances are launched mid-deployment
	// and do not receive the deployed application revision. If this option is set to
	// UPDATE or is unspecified, CodeDeploy initiates one or more 'auto-update outdated
	// instances' deployments to apply the deployed application revision to the new
	// Amazon EC2 instances. If this option is set to IGNORE, CodeDeploy does not
	// initiate a deployment to update the new Amazon EC2 instances. This may result in
	// instances having different revisions.
	OutdatedInstancesStrategy OutdatedInstancesStrategy

	// A service role Amazon Resource Name (ARN) that grants CodeDeploy permission to
	// make calls to Amazon Web Services services on your behalf. For more information,
	// see Create a Service Role for CodeDeploy
	// (https://docs.aws.amazon.com/codedeploy/latest/userguide/getting-started-create-service-role.html)
	// in the CodeDeploy User Guide.
	ServiceRoleArn *string

	// Information about the deployment group's target revision, including type and
	// location.
	TargetRevision *RevisionLocation

	// Information about triggers associated with the deployment group.
	TriggerConfigurations []TriggerConfig

	noSmithyDocumentSerde
}

// Information about a deployment.
type DeploymentInfo struct {

	// Provides information about the results of a deployment, such as whether
	// instances in the original environment in a blue/green deployment were not
	// terminated.
	//
	// Deprecated: AdditionalDeploymentStatusInfo is deprecated, use
	// DeploymentStatusMessageList instead.
	AdditionalDeploymentStatusInfo *string

	// The application name.
	ApplicationName *string

	// Information about the automatic rollback configuration associated with the
	// deployment.
	AutoRollbackConfiguration *AutoRollbackConfiguration

	// Information about blue/green deployment options for this deployment.
	BlueGreenDeploymentConfiguration *BlueGreenDeploymentConfiguration

	// A timestamp that indicates when the deployment was complete.
	CompleteTime *time.Time

	// The destination platform type for the deployment (Lambda, Server, or ECS).
	ComputePlatform ComputePlatform

	// A timestamp that indicates when the deployment was created.
	CreateTime *time.Time

	// The means by which the deployment was created:
	//
	// * user: A user created the
	// deployment.
	//
	// * autoscaling: Amazon EC2 Auto Scaling created the deployment.
	//
	// *
	// codeDeployRollback: A rollback process created the deployment.
	//
	// *
	// CodeDeployAutoUpdate: An auto-update process created the deployment when it
	// detected outdated Amazon EC2 instances.
	Creator DeploymentCreator

	// The deployment configuration name.
	DeploymentConfigName *string

	// The deployment group name.
	DeploymentGroupName *string

	// The unique ID of a deployment.
	DeploymentId *string

	// A summary of the deployment status of the instances in the deployment.
	DeploymentOverview *DeploymentOverview

	// Messages that contain information about the status of a deployment.
	DeploymentStatusMessages []string

	// Information about the type of deployment, either in-place or blue/green, you
	// want to run and whether to route deployment traffic behind a load balancer.
	DeploymentStyle *DeploymentStyle

	// A comment about the deployment.
	Description *string

	// Information about any error associated with this deployment.
	ErrorInformation *ErrorInformation

	// The unique ID for an external resource (for example, a CloudFormation stack ID)
	// that is linked to this deployment.
	ExternalId *string

	// Information about how CodeDeploy handles files that already exist in a
	// deployment target location but weren't part of the previous successful
	// deployment.
	//
	// * DISALLOW: The deployment fails. This is also the default behavior
	// if no option is specified.
	//
	// * OVERWRITE: The version of the file from the
	// application revision currently being deployed replaces the version already on
	// the instance.
	//
	// * RETAIN: The version of the file already on the instance is kept
	// and used as part of the new deployment.
	FileExistsBehavior FileExistsBehavior

	// If true, then if an ApplicationStop, BeforeBlockTraffic, or AfterBlockTraffic
	// deployment lifecycle event to an instance fails, then the deployment continues
	// to the next deployment lifecycle event. For example, if ApplicationStop fails,
	// the deployment continues with DownloadBundle. If BeforeBlockTraffic fails, the
	// deployment continues with BlockTraffic. If AfterBlockTraffic fails, the
	// deployment continues with ApplicationStop. If false or not specified, then if a
	// lifecycle event fails during a deployment to an instance, that deployment fails.
	// If deployment to that instance is part of an overall deployment and the number
	// of healthy hosts is not less than the minimum number of healthy hosts, then a
	// deployment to the next instance is attempted. During a deployment, the
	// CodeDeploy agent runs the scripts specified for ApplicationStop,
	// BeforeBlockTraffic, and AfterBlockTraffic in the AppSpec file from the previous
	// successful deployment. (All other scripts are run from the AppSpec file in the
	// current deployment.) If one of these scripts contains an error and does not run
	// successfully, the deployment can fail. If the cause of the failure is a script
	// from the last successful deployment that will never run successfully, create a
	// new deployment and use ignoreApplicationStopFailures to specify that the
	// ApplicationStop, BeforeBlockTraffic, and AfterBlockTraffic failures should be
	// ignored.
	IgnoreApplicationStopFailures bool

	// Indicates whether the wait period set for the termination of instances in the
	// original environment has started. Status is 'false' if the KEEP_ALIVE option is
	// specified. Otherwise, 'true' as soon as the termination wait period starts.
	InstanceTerminationWaitTimeStarted bool

	// Information about the load balancer used in the deployment.
	LoadBalancerInfo *LoadBalancerInfo

	// Information about alarms associated with a deployment or deployment group.
	OverrideAlarmConfiguration *AlarmConfiguration

	// Information about the application revision that was deployed to the deployment
	// group before the most recent successful deployment.
	PreviousRevision *RevisionLocation

	// Information about deployments related to the specified deployment.
	RelatedDeployments *RelatedDeployments

	// Information about the location of stored application artifacts and the service
	// from which to retrieve them.
	Revision *RevisionLocation

	// Information about a deployment rollback.
	RollbackInfo *RollbackInfo

	// A timestamp that indicates when the deployment was deployed to the deployment
	// group. In some cases, the reported value of the start time might be later than
	// the complete time. This is due to differences in the clock settings of backend
	// servers that participate in the deployment process.
	StartTime *time.Time

	// The current state of the deployment as a whole.
	Status DeploymentStatus

	// Information about the instances that belong to the replacement environment in a
	// blue/green deployment.
	TargetInstances *TargetInstances

	// Indicates whether only instances that are not running the latest application
	// revision are to be deployed to.
	UpdateOutdatedInstancesOnly bool

	noSmithyDocumentSerde
}

// Information about the deployment status of the instances in the deployment.
type DeploymentOverview struct {

	// The number of instances in the deployment in a failed state.
	Failed int64

	// The number of instances in which the deployment is in progress.
	InProgress int64

	// The number of instances in the deployment in a pending state.
	Pending int64

	// The number of instances in a replacement environment ready to receive traffic in
	// a blue/green deployment.
	Ready int64

	// The number of instances in the deployment in a skipped state.
	Skipped int64

	// The number of instances in the deployment to which revisions have been
	// successfully deployed.
	Succeeded int64

	noSmithyDocumentSerde
}

// Information about how traffic is rerouted to instances in a replacement
// environment in a blue/green deployment.
type DeploymentReadyOption struct {

	// Information about when to reroute traffic from an original environment to a
	// replacement environment in a blue/green deployment.
	//
	// * CONTINUE_DEPLOYMENT:
	// Register new instances with the load balancer immediately after the new
	// application revision is installed on the instances in the replacement
	// environment.
	//
	// * STOP_DEPLOYMENT: Do not register new instances with a load
	// balancer unless traffic rerouting is started using ContinueDeployment. If
	// traffic rerouting is not started before the end of the specified wait period,
	// the deployment status is changed to Stopped.
	ActionOnTimeout DeploymentReadyAction

	// The number of minutes to wait before the status of a blue/green deployment is
	// changed to Stopped if rerouting is not started manually. Applies only to the
	// STOP_DEPLOYMENT option for actionOnTimeout.
	WaitTimeInMinutes int32

	noSmithyDocumentSerde
}

// Information about the type of deployment, either in-place or blue/green, you
// want to run and whether to route deployment traffic behind a load balancer.
type DeploymentStyle struct {

	// Indicates whether to route deployment traffic behind a load balancer.
	DeploymentOption DeploymentOption

	// Indicates whether to run an in-place deployment or a blue/green deployment.
	DeploymentType DeploymentType

	noSmithyDocumentSerde
}

// Information about the deployment target.
type DeploymentTarget struct {

	// Information about the target to be updated by an CloudFormation blue/green
	// deployment. This target type is used for all deployments initiated by a
	// CloudFormation stack update.
	CloudFormationTarget *CloudFormationTarget

	// The deployment type that is specific to the deployment's compute platform or
	// deployments initiated by a CloudFormation stack update.
	DeploymentTargetType DeploymentTargetType

	// Information about the target for a deployment that uses the Amazon ECS compute
	// platform.
	EcsTarget *ECSTarget

	// Information about the target for a deployment that uses the EC2/On-premises
	// compute platform.
	InstanceTarget *InstanceTarget

	// Information about the target for a deployment that uses the Lambda compute
	// platform.
	LambdaTarget *LambdaTarget

	noSmithyDocumentSerde
}

// Diagnostic information about executable scripts that are part of a deployment.
type Diagnostics struct {

	// The associated error code:
	//
	// * Success: The specified script ran.
	//
	// *
	// ScriptMissing: The specified script was not found in the specified location.
	//
	// *
	// ScriptNotExecutable: The specified script is not a recognized executable file
	// type.
	//
	// * ScriptTimedOut: The specified script did not finish running in the
	// specified time period.
	//
	// * ScriptFailed: The specified script failed to run as
	// expected.
	//
	// * UnknownError: The specified script did not run for an unknown
	// reason.
	ErrorCode LifecycleErrorCode

	// The last portion of the diagnostic log. If available, CodeDeploy returns up to
	// the last 4 KB of the diagnostic log.
	LogTail *string

	// The message associated with the error.
	Message *string

	// The name of the script.
	ScriptName *string

	noSmithyDocumentSerde
}

// Information about an EC2 tag filter.
type EC2TagFilter struct {

	// The tag filter key.
	Key *string

	// The tag filter type:
	//
	// * KEY_ONLY: Key only.
	//
	// * VALUE_ONLY: Value only.
	//
	// *
	// KEY_AND_VALUE: Key and value.
	Type EC2TagFilterType

	// The tag filter value.
	Value *string

	noSmithyDocumentSerde
}

// Information about groups of Amazon EC2 instance tags.
type EC2TagSet struct {

	// A list that contains other lists of Amazon EC2 instance tag groups. For an
	// instance to be included in the deployment group, it must be identified by all of
	// the tag groups in the list.
	Ec2TagSetList [][]EC2TagFilter

	noSmithyDocumentSerde
}

// Contains the service and cluster names used to identify an Amazon ECS
// deployment's target.
type ECSService struct {

	// The name of the cluster that the Amazon ECS service is associated with.
	ClusterName *string

	// The name of the target Amazon ECS service.
	ServiceName *string

	noSmithyDocumentSerde
}

// Information about the target of an Amazon ECS deployment.
type ECSTarget struct {

	// The unique ID of a deployment.
	DeploymentId *string

	// The date and time when the target Amazon ECS application was updated by a
	// deployment.
	LastUpdatedAt *time.Time

	// The lifecycle events of the deployment to this target Amazon ECS application.
	LifecycleEvents []LifecycleEvent

	// The status an Amazon ECS deployment's target ECS application.
	Status TargetStatus

	// The Amazon Resource Name (ARN) of the target.
	TargetArn *string

	// The unique ID of a deployment target that has a type of ecsTarget.
	TargetId *string

	// The ECSTaskSet objects associated with the ECS target.
	TaskSetsInfo []ECSTaskSet

	noSmithyDocumentSerde
}

// Information about a set of Amazon ECS tasks in an CodeDeploy deployment. An
// Amazon ECS task set includes details such as the desired number of tasks, how
// many tasks are running, and whether the task set serves production traffic. An
// CodeDeploy application that uses the Amazon ECS compute platform deploys a
// containerized application in an Amazon ECS service as a task set.
type ECSTaskSet struct {

	// The number of tasks in a task set. During a deployment that uses the Amazon ECS
	// compute type, CodeDeploy instructs Amazon ECS to create a new task set and uses
	// this value to determine how many tasks to create. After the updated task set is
	// created, CodeDeploy shifts traffic to the new task set.
	DesiredCount int64

	// A unique ID of an ECSTaskSet.
	Identifer *string

	// The number of tasks in the task set that are in the PENDING status during an
	// Amazon ECS deployment. A task in the PENDING state is preparing to enter the
	// RUNNING state. A task set enters the PENDING status when it launches for the
	// first time, or when it is restarted after being in the STOPPED state.
	PendingCount int64

	// The number of tasks in the task set that are in the RUNNING status during an
	// Amazon ECS deployment. A task in the RUNNING state is running and ready for use.
	RunningCount int64

	// The status of the task set. There are three valid task set statuses:
	//
	// * PRIMARY:
	// Indicates the task set is serving production traffic.
	//
	// * ACTIVE: Indicates the
	// task set is not serving production traffic.
	//
	// * DRAINING: Indicates the tasks in
	// the task set are being stopped and their corresponding targets are being
	// deregistered from their target group.
	Status *string

	// The target group associated with the task set. The target group is used by
	// CodeDeploy to manage traffic to a task set.
	TargetGroup *TargetGroupInfo

	// A label that identifies whether the ECS task set is an original target (BLUE) or
	// a replacement target (GREEN).
	TaskSetLabel TargetLabel

	// The percentage of traffic served by this task set.
	TrafficWeight float64

	noSmithyDocumentSerde
}

// Information about a load balancer in Elastic Load Balancing to use in a
// deployment. Instances are registered directly with a load balancer, and traffic
// is routed to the load balancer.
type ELBInfo struct {

	// For blue/green deployments, the name of the load balancer that is used to route
	// traffic from original instances to replacement instances in a blue/green
	// deployment. For in-place deployments, the name of the load balancer that
	// instances are deregistered from so they are not serving traffic during a
	// deployment, and then re-registered with after the deployment is complete.
	Name *string

	noSmithyDocumentSerde
}

// Information about a deployment error.
type ErrorInformation struct {

	// For more information, see Error Codes for CodeDeploy
	// (https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html) in
	// the CodeDeploy User Guide
	// (https://docs.aws.amazon.com/codedeploy/latest/userguide). The error code:
	//
	// *
	// APPLICATION_MISSING: The application was missing. This error code is most likely
	// raised if the application is deleted after the deployment is created, but before
	// it is started.
	//
	// * DEPLOYMENT_GROUP_MISSING: The deployment group was missing.
	// This error code is most likely raised if the deployment group is deleted after
	// the deployment is created, but before it is started.
	//
	// * HEALTH_CONSTRAINTS: The
	// deployment failed on too many instances to be successfully deployed within the
	// instance health constraints specified.
	//
	// * HEALTH_CONSTRAINTS_INVALID: The
	// revision cannot be successfully deployed within the instance health constraints
	// specified.
	//
	// * IAM_ROLE_MISSING: The service role cannot be accessed.
	//
	// *
	// IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
	//
	// *
	// INTERNAL_ERROR: There was an internal error.
	//
	// * NO_EC2_SUBSCRIPTION: The calling
	// account is not subscribed to Amazon EC2.
	//
	// * NO_INSTANCES: No instances were
	// specified, or no instances can be found.
	//
	// * OVER_MAX_INSTANCES: The maximum
	// number of instances was exceeded.
	//
	// * THROTTLED: The operation was throttled
	// because the calling account exceeded the throttling limits of one or more Amazon
	// Web Services services.
	//
	// * TIMEOUT: The deployment has timed out.
	//
	// *
	// REVISION_MISSING: The revision ID was missing. This error code is most likely
	// raised if the revision is deleted after the deployment is created, but before it
	// is started.
	Code ErrorCode

	// An accompanying error message.
	Message *string

	noSmithyDocumentSerde
}

// Information about an application revision.
type GenericRevisionInfo struct {

	// The deployment groups for which this is the current target revision.
	DeploymentGroups []string

	// A comment about the revision.
	Description *string

	// When the revision was first used by CodeDeploy.
	FirstUsedTime *time.Time

	// When the revision was last used by CodeDeploy.
	LastUsedTime *time.Time

	// When the revision was registered with CodeDeploy.
	RegisterTime *time.Time

	noSmithyDocumentSerde
}

// Information about the location of application artifacts stored in GitHub.
type GitHubLocation struct {

	// The SHA1 commit ID of the GitHub commit that represents the bundled artifacts
	// for the application revision.
	CommitId *string

	// The GitHub account and repository pair that stores a reference to the commit
	// that represents the bundled artifacts for the application revision. Specified as
	// account/repository.
	Repository *string

	noSmithyDocumentSerde
}

// Information about the instances that belong to the replacement environment in a
// blue/green deployment.
type GreenFleetProvisioningOption struct {

	// The method used to add instances to a replacement environment.
	//
	// *
	// DISCOVER_EXISTING: Use instances that already exist or will be created
	// manually.
	//
	// * COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling
	// group to define and create instances in a new Auto Scaling group.
	Action GreenFleetProvisioningAction

	noSmithyDocumentSerde
}

// Information about an on-premises instance.
type InstanceInfo struct {

	// If the on-premises instance was deregistered, the time at which the on-premises
	// instance was deregistered.
	DeregisterTime *time.Time

	// The ARN of the IAM session associated with the on-premises instance.
	IamSessionArn *string

	// The IAM user ARN associated with the on-premises instance.
	IamUserArn *string

	// The ARN of the on-premises instance.
	InstanceArn *string

	// The name of the on-premises instance.
	InstanceName *string

	// The time at which the on-premises instance was registered.
	RegisterTime *time.Time

	// The tags currently associated with the on-premises instance.
	Tags []Tag

	noSmithyDocumentSerde
}

// Information about an instance in a deployment.
type InstanceSummary struct {

	// The unique ID of a deployment.
	DeploymentId *string

	// The instance ID.
	InstanceId *string

	// Information about which environment an instance belongs to in a blue/green
	// deployment.
	//
	// * BLUE: The instance is part of the original environment.
	//
	// * GREEN:
	// The instance is part of the replacement environment.
	InstanceType InstanceType

	// A timestamp that indicates when the instance information was last updated.
	LastUpdatedAt *time.Time

	// A list of lifecycle events for this instance.
	LifecycleEvents []LifecycleEvent

	// The deployment status for this instance:
	//
	// * Pending: The deployment is pending
	// for this instance.
	//
	// * In Progress: The deployment is in progress for this
	// instance.
	//
	// * Succeeded: The deployment has succeeded for this instance.
	//
	// *
	// Failed: The deployment has failed for this instance.
	//
	// * Skipped: The deployment
	// has been skipped for this instance.
	//
	// * Unknown: The deployment status is unknown
	// for this instance.
	//
	// Deprecated: InstanceStatus is deprecated, use TargetStatus instead.
	Status InstanceStatus

	noSmithyDocumentSerde
}

// A target Amazon EC2 or on-premises instance during a deployment that uses the
// EC2/On-premises compute platform.
type InstanceTarget struct {

	// The unique ID of a deployment.
	DeploymentId *string

	// A label that identifies whether the instance is an original target (BLUE) or a
	// replacement target (GREEN).
	InstanceLabel TargetLabel

	// The date and time when the target instance was updated by a deployment.
	LastUpdatedAt *time.Time

	// The lifecycle events of the deployment to this target instance.
	LifecycleEvents []LifecycleEvent

	// The status an EC2/On-premises deployment's target instance.
	Status TargetStatus

	// The Amazon Resource Name (ARN) of the target.
	TargetArn *string

	// The unique ID of a deployment target that has a type of instanceTarget.
	TargetId *string

	noSmithyDocumentSerde
}

// Information about a Lambda function specified in a deployment.
type LambdaFunctionInfo struct {

	// The version of a Lambda function that production traffic points to.
	CurrentVersion *string

	// The alias of a Lambda function. For more information, see Lambda Function
	// Aliases (https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html) in the
	// Lambda Developer Guide.
	FunctionAlias *string

	// The name of a Lambda function.
	FunctionName *string

	// The version of a Lambda function that production traffic points to after the
	// Lambda function is deployed.
	TargetVersion *string

	// The percentage of production traffic that the target version of a Lambda
	// function receives.
	TargetVersionWeight float64

	noSmithyDocumentSerde
}

// Information about the target Lambda function during an Lambda deployment.
type LambdaTarget struct {

	// The unique ID of a deployment.
	DeploymentId *string

	// A LambdaFunctionInfo object that describes a target Lambda function.
	LambdaFunctionInfo *LambdaFunctionInfo

	// The date and time when the target Lambda function was updated by a deployment.
	LastUpdatedAt *time.Time

	// The lifecycle events of the deployment to this target Lambda function.
	LifecycleEvents []LifecycleEvent

	// The status an Lambda deployment's target Lambda function.
	Status TargetStatus

	// The Amazon Resource Name (ARN) of the target.
	TargetArn *string

	// The unique ID of a deployment target that has a type of lambdaTarget.
	TargetId *string

	noSmithyDocumentSerde
}

// Information about the most recent attempted or successful deployment to a
// deployment group.
type LastDeploymentInfo struct {

	// A timestamp that indicates when the most recent deployment to the deployment
	// group started.
	CreateTime *time.Time

	// The unique ID of a deployment.
	DeploymentId *string

	// A timestamp that indicates when the most recent deployment to the deployment
	// group was complete.
	EndTime *time.Time

	// The status of the most recent deployment.
	Status DeploymentStatus

	noSmithyDocumentSerde
}

// Information about a deployment lifecycle event.
type LifecycleEvent struct {

	// Diagnostic information about the deployment lifecycle event.
	Diagnostics *Diagnostics

	// A timestamp that indicates when the deployment lifecycle event ended.
	EndTime *time.Time

	// The deployment lifecycle event name, such as ApplicationStop, BeforeInstall,
	// AfterInstall, ApplicationStart, or ValidateService.
	LifecycleEventName *string

	// A timestamp that indicates when the deployment lifecycle event started.
	StartTime *time.Time

	// The deployment lifecycle event status:
	//
	// * Pending: The deployment lifecycle
	// event is pending.
	//
	// * InProgress: The deployment lifecycle event is in
	// progress.
	//
	// * Succeeded: The deployment lifecycle event ran successfully.
	//
	// *
	// Failed: The deployment lifecycle event has failed.
	//
	// * Skipped: The deployment
	// lifecycle event has been skipped.
	//
	// * Unknown: The deployment lifecycle event is
	// unknown.
	Status LifecycleEventStatus

	noSmithyDocumentSerde
}

// Information about the Elastic Load Balancing load balancer or target group used
// in a deployment.
type LoadBalancerInfo struct {

	// An array that contains information about the load balancer to use for load
	// balancing in a deployment. In Elastic Load Balancing, load balancers are used
	// with Classic Load Balancers. Adding more than one load balancer to the array is
	// not supported.
	ElbInfoList []ELBInfo

	// An array that contains information about the target group to use for load
	// balancing in a deployment. In Elastic Load Balancing, target groups are used
	// with Application Load Balancers. Adding more than one target group to the array
	// is not supported.
	TargetGroupInfoList []TargetGroupInfo

	// The target group pair information. This is an array of TargeGroupPairInfo
	// objects with a maximum size of one.
	TargetGroupPairInfoList []TargetGroupPairInfo

	noSmithyDocumentSerde
}

// Information about minimum healthy instance.
type MinimumHealthyHosts struct {

	// The minimum healthy instance type:
	//
	// * HOST_COUNT: The minimum number of healthy
	// instances as an absolute value.
	//
	// * FLEET_PERCENT: The minimum number of healthy
	// instances as a percentage of the total number of instances in the
	// deployment.
	//
	// In an example of nine instances, if a HOST_COUNT of six is
	// specified, deploy to up to three instances at a time. The deployment is
	// successful if six or more instances are deployed to successfully. Otherwise, the
	// deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five
	// instances at a time. The deployment is successful if four or more instances are
	// deployed to successfully. Otherwise, the deployment fails. In a call to the
	// GetDeploymentConfig, CodeDeployDefault.OneAtATime returns a minimum healthy
	// instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to
	// only one instance at a time. (You cannot set the type to MOST_CONCURRENCY, only
	// to HOST_COUNT or FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime,
	// CodeDeploy attempts to ensure that all instances but one are kept in a healthy
	// state during the deployment. Although this allows one instance at a time to be
	// taken offline for a new deployment, it also means that if the deployment to the
	// last instance fails, the overall deployment is still successful. For more
	// information, see CodeDeploy Instance Health
	// (https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html)
	// in the CodeDeploy User Guide.
	Type MinimumHealthyHostsType

	// The minimum healthy instance value.
	Value int32

	noSmithyDocumentSerde
}

// Information about groups of on-premises instance tags.
type OnPremisesTagSet struct {

	// A list that contains other lists of on-premises instance tag groups. For an
	// instance to be included in the deployment group, it must be identified by all of
	// the tag groups in the list.
	OnPremisesTagSetList [][]TagFilter

	noSmithyDocumentSerde
}

// A revision for an Lambda deployment that is a YAML-formatted or JSON-formatted
// string. For Lambda deployments, the revision is the same as the AppSpec file.
type RawString struct {

	// The YAML-formatted or JSON-formatted revision string. It includes information
	// about which Lambda function to update and optional Lambda functions that
	// validate deployment lifecycle events.
	Content *string

	// The SHA256 hash value of the revision content.
	Sha256 *string

	noSmithyDocumentSerde
}

// Information about deployments related to the specified deployment.
type RelatedDeployments struct {

	// The deployment IDs of 'auto-update outdated instances' deployments triggered by
	// this deployment.
	AutoUpdateOutdatedInstancesDeploymentIds []string

	// The deployment ID of the root deployment that triggered this deployment.
	AutoUpdateOutdatedInstancesRootDeploymentId *string

	noSmithyDocumentSerde
}

// Information about an application revision.
type RevisionInfo struct {

	// Information about an application revision, including usage details and
	// associated deployment groups.
	GenericRevisionInfo *GenericRevisionInfo

	// Information about the location and type of an application revision.
	RevisionLocation *RevisionLocation

	noSmithyDocumentSerde
}

// Information about the location of an application revision.
type RevisionLocation struct {

	// The content of an AppSpec file for an Lambda or Amazon ECS deployment. The
	// content is formatted as JSON or YAML and stored as a RawString.
	AppSpecContent *AppSpecContent

	// Information about the location of application artifacts stored in GitHub.
	GitHubLocation *GitHubLocation

	// The type of application revision:
	//
	// * S3: An application revision stored in
	// Amazon S3.
	//
	// * GitHub: An application revision stored in GitHub (EC2/On-premises
	// deployments only).
	//
	// * String: A YAML-formatted or JSON-formatted string (Lambda
	// deployments only).
	//
	// * AppSpecContent: An AppSpecContent object that contains the
	// contents of an AppSpec file for an Lambda or Amazon ECS deployment. The content
	// is formatted as JSON or YAML stored as a RawString.
	RevisionType RevisionLocationType

	// Information about the location of a revision stored in Amazon S3.
	S3Location *S3Location

	// Information about the location of an Lambda deployment revision stored as a
	// RawString.
	//
	// Deprecated: RawString and String revision type are deprecated, use
	// AppSpecContent type instead.
	String_ *RawString

	noSmithyDocumentSerde
}

// Information about a deployment rollback.
type RollbackInfo struct {

	// The ID of the deployment rollback.
	RollbackDeploymentId *string

	// Information that describes the status of a deployment rollback (for example,
	// whether the deployment can't be rolled back, is in progress, failed, or
	// succeeded).
	RollbackMessage *string

	// The deployment ID of the deployment that was underway and triggered a rollback
	// deployment because it failed or was stopped.
	RollbackTriggeringDeploymentId *string

	noSmithyDocumentSerde
}

// Information about the location of application artifacts stored in Amazon S3.
type S3Location struct {

	// The name of the Amazon S3 bucket where the application revision is stored.
	Bucket *string

	// The file type of the application revision. Must be one of the following:
	//
	// * tar:
	// A tar archive file.
	//
	// * tgz: A compressed tar archive file.
	//
	// * zip: A zip archive
	// file.
	BundleType BundleType

	// The ETag of the Amazon S3 object that represents the bundled artifacts for the
	// application revision. If the ETag is not specified as an input parameter, ETag
	// validation of the object is skipped.
	ETag *string

	// The name of the Amazon S3 object that represents the bundled artifacts for the
	// application revision.
	Key *string

	// A specific version of the Amazon S3 object that represents the bundled artifacts
	// for the application revision. If the version is not specified, the system uses
	// the most recent version by default.
	Version *string

	noSmithyDocumentSerde
}

// Information about a tag.
type Tag struct {

	// The tag's key.
	Key *string

	// The tag's value.
	Value *string

	noSmithyDocumentSerde
}

// Information about an on-premises instance tag filter.
type TagFilter struct {

	// The on-premises instance tag filter key.
	Key *string

	// The on-premises instance tag filter type:
	//
	// * KEY_ONLY: Key only.
	//
	// * VALUE_ONLY:
	// Value only.
	//
	// * KEY_AND_VALUE: Key and value.
	Type TagFilterType

	// The on-premises instance tag filter value.
	Value *string

	noSmithyDocumentSerde
}

// Information about a target group in Elastic Load Balancing to use in a
// deployment. Instances are registered as targets in a target group, and traffic
// is routed to the target group.
type TargetGroupInfo struct {

	// For blue/green deployments, the name of the target group that instances in the
	// original environment are deregistered from, and instances in the replacement
	// environment are registered with. For in-place deployments, the name of the
	// target group that instances are deregistered from, so they are not serving
	// traffic during a deployment, and then re-registered with after the deployment is
	// complete.
	Name *string

	noSmithyDocumentSerde
}

// Information about two target groups and how traffic is routed during an Amazon
// ECS deployment. An optional test traffic route can be specified.
type TargetGroupPairInfo struct {

	// The path used by a load balancer to route production traffic when an Amazon ECS
	// deployment is complete.
	ProdTrafficRoute *TrafficRoute

	// One pair of target groups. One is associated with the original task set. The
	// second is associated with the task set that serves traffic after the deployment
	// is complete.
	TargetGroups []TargetGroupInfo

	// An optional path used by a load balancer to route test traffic after an Amazon
	// ECS deployment. Validation can occur while test traffic is served during a
	// deployment.
	TestTrafficRoute *TrafficRoute

	noSmithyDocumentSerde
}

// Information about the instances to be used in the replacement environment in a
// blue/green deployment.
type TargetInstances struct {

	// The names of one or more Auto Scaling groups to identify a replacement
	// environment for a blue/green deployment.
	AutoScalingGroups []string

	// Information about the groups of Amazon EC2 instance tags that an instance must
	// be identified by in order for it to be included in the replacement environment
	// for a blue/green deployment. Cannot be used in the same call as tagFilters.
	Ec2TagSet *EC2TagSet

	// The tag filter key, type, and value used to identify Amazon EC2 instances in a
	// replacement environment for a blue/green deployment. Cannot be used in the same
	// call as ec2TagSet.
	TagFilters []EC2TagFilter

	noSmithyDocumentSerde
}

// A configuration that shifts traffic from one version of a Lambda function or
// Amazon ECS task set to another in two increments. The original and target Lambda
// function versions or ECS task sets are specified in the deployment's AppSpec
// file.
type TimeBasedCanary struct {

	// The number of minutes between the first and second traffic shifts of a
	// TimeBasedCanary deployment.
	CanaryInterval int32

	// The percentage of traffic to shift in the first increment of a TimeBasedCanary
	// deployment.
	CanaryPercentage int32

	noSmithyDocumentSerde
}

// A configuration that shifts traffic from one version of a Lambda function or ECS
// task set to another in equal increments, with an equal number of minutes between
// each increment. The original and target Lambda function versions or ECS task
// sets are specified in the deployment's AppSpec file.
type TimeBasedLinear struct {

	// The number of minutes between each incremental traffic shift of a
	// TimeBasedLinear deployment.
	LinearInterval int32

	// The percentage of traffic that is shifted at the start of each increment of a
	// TimeBasedLinear deployment.
	LinearPercentage int32

	noSmithyDocumentSerde
}

// Information about a time range.
type TimeRange struct {

	// The end time of the time range. Specify null to leave the end time open-ended.
	End *time.Time

	// The start time of the time range. Specify null to leave the start time
	// open-ended.
	Start *time.Time

	noSmithyDocumentSerde
}

// Information about a listener. The listener contains the path used to route
// traffic that is received from the load balancer to a target group.
type TrafficRoute struct {

	// The Amazon Resource Name (ARN) of one listener. The listener identifies the
	// route between a target group and a load balancer. This is an array of strings
	// with a maximum size of one.
	ListenerArns []string

	noSmithyDocumentSerde
}

// The configuration that specifies how traffic is shifted from one version of a
// Lambda function to another version during an Lambda deployment, or from one
// Amazon ECS task set to another during an Amazon ECS deployment.
type TrafficRoutingConfig struct {

	// A configuration that shifts traffic from one version of a Lambda function or ECS
	// task set to another in two increments. The original and target Lambda function
	// versions or ECS task sets are specified in the deployment's AppSpec file.
	TimeBasedCanary *TimeBasedCanary

	// A configuration that shifts traffic from one version of a Lambda function or
	// Amazon ECS task set to another in equal increments, with an equal number of
	// minutes between each increment. The original and target Lambda function versions
	// or Amazon ECS task sets are specified in the deployment's AppSpec file.
	TimeBasedLinear *TimeBasedLinear

	// The type of traffic shifting (TimeBasedCanary or TimeBasedLinear) used by a
	// deployment configuration.
	Type TrafficRoutingType

	noSmithyDocumentSerde
}

// Information about notification triggers for the deployment group.
type TriggerConfig struct {

	// The event type or types for which notifications are triggered.
	TriggerEvents []TriggerEventType

	// The name of the notification trigger.
	TriggerName *string

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic
	// through which notifications about deployment or instance events are sent.
	TriggerTargetArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
