// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The maximum number of alarms for a deployment group (10) was exceeded.
type AlarmsLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *AlarmsLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AlarmsLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AlarmsLimitExceededException) ErrorCode() string             { return "AlarmsLimitExceededException" }
func (e *AlarmsLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An application with the specified name with the IAM user or Amazon Web Services
// account already exists.
type ApplicationAlreadyExistsException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ApplicationAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApplicationAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApplicationAlreadyExistsException) ErrorCode() string {
	return "ApplicationAlreadyExistsException"
}
func (e *ApplicationAlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The application does not exist with the IAM user or Amazon Web Services account.
type ApplicationDoesNotExistException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ApplicationDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApplicationDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApplicationDoesNotExistException) ErrorCode() string {
	return "ApplicationDoesNotExistException"
}
func (e *ApplicationDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// More applications were attempted to be created than are allowed.
type ApplicationLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ApplicationLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApplicationLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApplicationLimitExceededException) ErrorCode() string {
	return "ApplicationLimitExceededException"
}
func (e *ApplicationLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The minimum number of required application names was not specified.
type ApplicationNameRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ApplicationNameRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ApplicationNameRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ApplicationNameRequiredException) ErrorCode() string {
	return "ApplicationNameRequiredException"
}
func (e *ApplicationNameRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified ARN is not supported. For example, it might be an ARN for a
// resource that is not expected.
type ArnNotSupportedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ArnNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ArnNotSupportedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ArnNotSupportedException) ErrorCode() string             { return "ArnNotSupportedException" }
func (e *ArnNotSupportedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum number of names or IDs allowed for this request (100) was exceeded.
type BatchLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *BatchLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BatchLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BatchLimitExceededException) ErrorCode() string             { return "BatchLimitExceededException" }
func (e *BatchLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A bucket name is required, but was not provided.
type BucketNameFilterRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *BucketNameFilterRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BucketNameFilterRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BucketNameFilterRequiredException) ErrorCode() string {
	return "BucketNameFilterRequiredException"
}
func (e *BucketNameFilterRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The deployment is already complete.
type DeploymentAlreadyCompletedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentAlreadyCompletedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentAlreadyCompletedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentAlreadyCompletedException) ErrorCode() string {
	return "DeploymentAlreadyCompletedException"
}
func (e *DeploymentAlreadyCompletedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A deployment configuration with the specified name with the IAM user or Amazon
// Web Services account already exists.
type DeploymentConfigAlreadyExistsException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentConfigAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentConfigAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentConfigAlreadyExistsException) ErrorCode() string {
	return "DeploymentConfigAlreadyExistsException"
}
func (e *DeploymentConfigAlreadyExistsException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The deployment configuration does not exist with the IAM user or Amazon Web
// Services account.
type DeploymentConfigDoesNotExistException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentConfigDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentConfigDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentConfigDoesNotExistException) ErrorCode() string {
	return "DeploymentConfigDoesNotExistException"
}
func (e *DeploymentConfigDoesNotExistException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The deployment configuration is still in use.
type DeploymentConfigInUseException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentConfigInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentConfigInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentConfigInUseException) ErrorCode() string             { return "DeploymentConfigInUseException" }
func (e *DeploymentConfigInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The deployment configurations limit was exceeded.
type DeploymentConfigLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentConfigLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentConfigLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentConfigLimitExceededException) ErrorCode() string {
	return "DeploymentConfigLimitExceededException"
}
func (e *DeploymentConfigLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The deployment configuration name was not specified.
type DeploymentConfigNameRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentConfigNameRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentConfigNameRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentConfigNameRequiredException) ErrorCode() string {
	return "DeploymentConfigNameRequiredException"
}
func (e *DeploymentConfigNameRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The deployment with the IAM user or Amazon Web Services account does not exist.
type DeploymentDoesNotExistException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentDoesNotExistException) ErrorCode() string {
	return "DeploymentDoesNotExistException"
}
func (e *DeploymentDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A deployment group with the specified name with the IAM user or Amazon Web
// Services account already exists.
type DeploymentGroupAlreadyExistsException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentGroupAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentGroupAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentGroupAlreadyExistsException) ErrorCode() string {
	return "DeploymentGroupAlreadyExistsException"
}
func (e *DeploymentGroupAlreadyExistsException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The named deployment group with the IAM user or Amazon Web Services account does
// not exist.
type DeploymentGroupDoesNotExistException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentGroupDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentGroupDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentGroupDoesNotExistException) ErrorCode() string {
	return "DeploymentGroupDoesNotExistException"
}
func (e *DeploymentGroupDoesNotExistException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The deployment groups limit was exceeded.
type DeploymentGroupLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentGroupLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentGroupLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentGroupLimitExceededException) ErrorCode() string {
	return "DeploymentGroupLimitExceededException"
}
func (e *DeploymentGroupLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The deployment group name was not specified.
type DeploymentGroupNameRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentGroupNameRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentGroupNameRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentGroupNameRequiredException) ErrorCode() string {
	return "DeploymentGroupNameRequiredException"
}
func (e *DeploymentGroupNameRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// At least one deployment ID must be specified.
type DeploymentIdRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentIdRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentIdRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentIdRequiredException) ErrorCode() string             { return "DeploymentIdRequiredException" }
func (e *DeploymentIdRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The deployment does not have a status of Ready and can't continue yet.
type DeploymentIsNotInReadyStateException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentIsNotInReadyStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentIsNotInReadyStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentIsNotInReadyStateException) ErrorCode() string {
	return "DeploymentIsNotInReadyStateException"
}
func (e *DeploymentIsNotInReadyStateException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of allowed deployments was exceeded.
type DeploymentLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentLimitExceededException) ErrorCode() string {
	return "DeploymentLimitExceededException"
}
func (e *DeploymentLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified deployment has not started.
type DeploymentNotStartedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentNotStartedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentNotStartedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentNotStartedException) ErrorCode() string             { return "DeploymentNotStartedException" }
func (e *DeploymentNotStartedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The provided target ID does not belong to the attempted deployment.
type DeploymentTargetDoesNotExistException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentTargetDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentTargetDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentTargetDoesNotExistException) ErrorCode() string {
	return "DeploymentTargetDoesNotExistException"
}
func (e *DeploymentTargetDoesNotExistException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A deployment target ID was not provided.
type DeploymentTargetIdRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentTargetIdRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentTargetIdRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentTargetIdRequiredException) ErrorCode() string {
	return "DeploymentTargetIdRequiredException"
}
func (e *DeploymentTargetIdRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The maximum number of targets that can be associated with an Amazon ECS or
// Lambda deployment was exceeded. The target list of both types of deployments
// must have exactly one item. This exception does not apply to EC2/On-premises
// deployments.
type DeploymentTargetListSizeExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DeploymentTargetListSizeExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeploymentTargetListSizeExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeploymentTargetListSizeExceededException) ErrorCode() string {
	return "DeploymentTargetListSizeExceededException"
}
func (e *DeploymentTargetListSizeExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The description is too long.
type DescriptionTooLongException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DescriptionTooLongException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DescriptionTooLongException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DescriptionTooLongException) ErrorCode() string             { return "DescriptionTooLongException" }
func (e *DescriptionTooLongException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Amazon ECS service is associated with more than one deployment groups. An
// Amazon ECS service can be associated with only one deployment group.
type ECSServiceMappingLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ECSServiceMappingLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ECSServiceMappingLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ECSServiceMappingLimitExceededException) ErrorCode() string {
	return "ECSServiceMappingLimitExceededException"
}
func (e *ECSServiceMappingLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// No GitHub account connection exists with the named specified in the call.
type GitHubAccountTokenDoesNotExistException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *GitHubAccountTokenDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *GitHubAccountTokenDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *GitHubAccountTokenDoesNotExistException) ErrorCode() string {
	return "GitHubAccountTokenDoesNotExistException"
}
func (e *GitHubAccountTokenDoesNotExistException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The call is missing a required GitHub account connection name.
type GitHubAccountTokenNameRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *GitHubAccountTokenNameRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *GitHubAccountTokenNameRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *GitHubAccountTokenNameRequiredException) ErrorCode() string {
	return "GitHubAccountTokenNameRequiredException"
}
func (e *GitHubAccountTokenNameRequiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// No IAM ARN was included in the request. You must use an IAM session ARN or IAM
// user ARN in the request.
type IamArnRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *IamArnRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IamArnRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IamArnRequiredException) ErrorCode() string             { return "IamArnRequiredException" }
func (e *IamArnRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request included an IAM session ARN that has already been used to register a
// different instance.
type IamSessionArnAlreadyRegisteredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *IamSessionArnAlreadyRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IamSessionArnAlreadyRegisteredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IamSessionArnAlreadyRegisteredException) ErrorCode() string {
	return "IamSessionArnAlreadyRegisteredException"
}
func (e *IamSessionArnAlreadyRegisteredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified IAM user ARN is already registered with an on-premises instance.
type IamUserArnAlreadyRegisteredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *IamUserArnAlreadyRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IamUserArnAlreadyRegisteredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IamUserArnAlreadyRegisteredException) ErrorCode() string {
	return "IamUserArnAlreadyRegisteredException"
}
func (e *IamUserArnAlreadyRegisteredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An IAM user ARN was not specified.
type IamUserArnRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *IamUserArnRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IamUserArnRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IamUserArnRequiredException) ErrorCode() string             { return "IamUserArnRequiredException" }
func (e *IamUserArnRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified instance does not exist in the deployment group.
type InstanceDoesNotExistException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InstanceDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InstanceDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InstanceDoesNotExistException) ErrorCode() string             { return "InstanceDoesNotExistException" }
func (e *InstanceDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The instance ID was not specified.
type InstanceIdRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InstanceIdRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InstanceIdRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InstanceIdRequiredException) ErrorCode() string             { return "InstanceIdRequiredException" }
func (e *InstanceIdRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum number of allowed on-premises instances in a single call was
// exceeded.
type InstanceLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InstanceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InstanceLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InstanceLimitExceededException) ErrorCode() string             { return "InstanceLimitExceededException" }
func (e *InstanceLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified on-premises instance name is already registered.
type InstanceNameAlreadyRegisteredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InstanceNameAlreadyRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InstanceNameAlreadyRegisteredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InstanceNameAlreadyRegisteredException) ErrorCode() string {
	return "InstanceNameAlreadyRegisteredException"
}
func (e *InstanceNameAlreadyRegisteredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An on-premises instance name was not specified.
type InstanceNameRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InstanceNameRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InstanceNameRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InstanceNameRequiredException) ErrorCode() string             { return "InstanceNameRequiredException" }
func (e *InstanceNameRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified on-premises instance is not registered.
type InstanceNotRegisteredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InstanceNotRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InstanceNotRegisteredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InstanceNotRegisteredException) ErrorCode() string             { return "InstanceNotRegisteredException" }
func (e *InstanceNotRegisteredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The format of the alarm configuration is invalid. Possible causes include:
//
// *
// The alarm list is null.
//
// * The alarm object is null.
//
// * The alarm name is empty
// or null or exceeds the limit of 255 characters.
//
// * Two alarms with the same name
// have been specified.
//
// * The alarm configuration is enabled, but the alarm list
// is empty.
type InvalidAlarmConfigException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidAlarmConfigException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAlarmConfigException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAlarmConfigException) ErrorCode() string             { return "InvalidAlarmConfigException" }
func (e *InvalidAlarmConfigException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The application name was specified in an invalid format.
type InvalidApplicationNameException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidApplicationNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidApplicationNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidApplicationNameException) ErrorCode() string {
	return "InvalidApplicationNameException"
}
func (e *InvalidApplicationNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified ARN is not in a valid format.
type InvalidArnException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidArnException) ErrorCode() string             { return "InvalidArnException" }
func (e *InvalidArnException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The automatic rollback configuration was specified in an invalid format. For
// example, automatic rollback is enabled, but an invalid triggering event type or
// no event types were listed.
type InvalidAutoRollbackConfigException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidAutoRollbackConfigException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAutoRollbackConfigException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAutoRollbackConfigException) ErrorCode() string {
	return "InvalidAutoRollbackConfigException"
}
func (e *InvalidAutoRollbackConfigException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The Auto Scaling group was specified in an invalid format or does not exist.
type InvalidAutoScalingGroupException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidAutoScalingGroupException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAutoScalingGroupException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAutoScalingGroupException) ErrorCode() string {
	return "InvalidAutoScalingGroupException"
}
func (e *InvalidAutoScalingGroupException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The configuration for the blue/green deployment group was provided in an invalid
// format. For information about deployment configuration format, see
// CreateDeploymentConfig.
type InvalidBlueGreenDeploymentConfigurationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidBlueGreenDeploymentConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidBlueGreenDeploymentConfigurationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidBlueGreenDeploymentConfigurationException) ErrorCode() string {
	return "InvalidBlueGreenDeploymentConfigurationException"
}
func (e *InvalidBlueGreenDeploymentConfigurationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The bucket name either doesn't exist or was specified in an invalid format.
type InvalidBucketNameFilterException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidBucketNameFilterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidBucketNameFilterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidBucketNameFilterException) ErrorCode() string {
	return "InvalidBucketNameFilterException"
}
func (e *InvalidBucketNameFilterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The computePlatform is invalid. The computePlatform should be Lambda, Server, or
// ECS.
type InvalidComputePlatformException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidComputePlatformException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidComputePlatformException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidComputePlatformException) ErrorCode() string {
	return "InvalidComputePlatformException"
}
func (e *InvalidComputePlatformException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The deployed state filter was specified in an invalid format.
type InvalidDeployedStateFilterException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidDeployedStateFilterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeployedStateFilterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeployedStateFilterException) ErrorCode() string {
	return "InvalidDeployedStateFilterException"
}
func (e *InvalidDeployedStateFilterException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The deployment configuration name was specified in an invalid format.
type InvalidDeploymentConfigNameException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidDeploymentConfigNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeploymentConfigNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeploymentConfigNameException) ErrorCode() string {
	return "InvalidDeploymentConfigNameException"
}
func (e *InvalidDeploymentConfigNameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The deployment group name was specified in an invalid format.
type InvalidDeploymentGroupNameException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidDeploymentGroupNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeploymentGroupNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeploymentGroupNameException) ErrorCode() string {
	return "InvalidDeploymentGroupNameException"
}
func (e *InvalidDeploymentGroupNameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// At least one of the deployment IDs was specified in an invalid format.
type InvalidDeploymentIdException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidDeploymentIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeploymentIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeploymentIdException) ErrorCode() string             { return "InvalidDeploymentIdException" }
func (e *InvalidDeploymentIdException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An instance type was specified for an in-place deployment. Instance types are
// supported for blue/green deployments only.
type InvalidDeploymentInstanceTypeException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidDeploymentInstanceTypeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeploymentInstanceTypeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeploymentInstanceTypeException) ErrorCode() string {
	return "InvalidDeploymentInstanceTypeException"
}
func (e *InvalidDeploymentInstanceTypeException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified deployment status doesn't exist or cannot be determined.
type InvalidDeploymentStatusException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidDeploymentStatusException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeploymentStatusException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeploymentStatusException) ErrorCode() string {
	return "InvalidDeploymentStatusException"
}
func (e *InvalidDeploymentStatusException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An invalid deployment style was specified. Valid deployment types include
// "IN_PLACE" and "BLUE_GREEN." Valid deployment options include
// "WITH_TRAFFIC_CONTROL" and "WITHOUT_TRAFFIC_CONTROL."
type InvalidDeploymentStyleException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidDeploymentStyleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeploymentStyleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeploymentStyleException) ErrorCode() string {
	return "InvalidDeploymentStyleException"
}
func (e *InvalidDeploymentStyleException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The target ID provided was not valid.
type InvalidDeploymentTargetIdException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidDeploymentTargetIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeploymentTargetIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeploymentTargetIdException) ErrorCode() string {
	return "InvalidDeploymentTargetIdException"
}
func (e *InvalidDeploymentTargetIdException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The wait type is invalid.
type InvalidDeploymentWaitTypeException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidDeploymentWaitTypeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDeploymentWaitTypeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDeploymentWaitTypeException) ErrorCode() string {
	return "InvalidDeploymentWaitTypeException"
}
func (e *InvalidDeploymentWaitTypeException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A call was submitted that specified both Ec2TagFilters and Ec2TagSet, but only
// one of these data types can be used in a single call.
type InvalidEC2TagCombinationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidEC2TagCombinationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidEC2TagCombinationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidEC2TagCombinationException) ErrorCode() string {
	return "InvalidEC2TagCombinationException"
}
func (e *InvalidEC2TagCombinationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The tag was specified in an invalid format.
type InvalidEC2TagException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidEC2TagException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidEC2TagException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidEC2TagException) ErrorCode() string             { return "InvalidEC2TagException" }
func (e *InvalidEC2TagException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Amazon ECS service identifier is not valid.
type InvalidECSServiceException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidECSServiceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidECSServiceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidECSServiceException) ErrorCode() string             { return "InvalidECSServiceException" }
func (e *InvalidECSServiceException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The external ID was specified in an invalid format.
type InvalidExternalIdException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidExternalIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidExternalIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidExternalIdException) ErrorCode() string             { return "InvalidExternalIdException" }
func (e *InvalidExternalIdException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An invalid fileExistsBehavior option was specified to determine how CodeDeploy
// handles files or directories that already exist in a deployment target location,
// but weren't part of the previous successful deployment. Valid values include
// "DISALLOW," "OVERWRITE," and "RETAIN."
type InvalidFileExistsBehaviorException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidFileExistsBehaviorException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidFileExistsBehaviorException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidFileExistsBehaviorException) ErrorCode() string {
	return "InvalidFileExistsBehaviorException"
}
func (e *InvalidFileExistsBehaviorException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The GitHub token is not valid.
type InvalidGitHubAccountTokenException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidGitHubAccountTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidGitHubAccountTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidGitHubAccountTokenException) ErrorCode() string {
	return "InvalidGitHubAccountTokenException"
}
func (e *InvalidGitHubAccountTokenException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The format of the specified GitHub account connection name is invalid.
type InvalidGitHubAccountTokenNameException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidGitHubAccountTokenNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidGitHubAccountTokenNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidGitHubAccountTokenNameException) ErrorCode() string {
	return "InvalidGitHubAccountTokenNameException"
}
func (e *InvalidGitHubAccountTokenNameException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The IAM session ARN was specified in an invalid format.
type InvalidIamSessionArnException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidIamSessionArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidIamSessionArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidIamSessionArnException) ErrorCode() string             { return "InvalidIamSessionArnException" }
func (e *InvalidIamSessionArnException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The IAM user ARN was specified in an invalid format.
type InvalidIamUserArnException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidIamUserArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidIamUserArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidIamUserArnException) ErrorCode() string             { return "InvalidIamUserArnException" }
func (e *InvalidIamUserArnException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The IgnoreApplicationStopFailures value is invalid. For Lambda deployments,
// false is expected. For EC2/On-premises deployments, true or false is expected.
type InvalidIgnoreApplicationStopFailuresValueException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidIgnoreApplicationStopFailuresValueException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidIgnoreApplicationStopFailuresValueException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidIgnoreApplicationStopFailuresValueException) ErrorCode() string {
	return "InvalidIgnoreApplicationStopFailuresValueException"
}
func (e *InvalidIgnoreApplicationStopFailuresValueException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The input was specified in an invalid format.
type InvalidInputException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInputException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInputException) ErrorCode() string             { return "InvalidInputException" }
func (e *InvalidInputException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The on-premises instance name was specified in an invalid format.
type InvalidInstanceNameException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidInstanceNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInstanceNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInstanceNameException) ErrorCode() string             { return "InvalidInstanceNameException" }
func (e *InvalidInstanceNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified instance status does not exist.
type InvalidInstanceStatusException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidInstanceStatusException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInstanceStatusException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInstanceStatusException) ErrorCode() string             { return "InvalidInstanceStatusException" }
func (e *InvalidInstanceStatusException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An invalid instance type was specified for instances in a blue/green deployment.
// Valid values include "Blue" for an original environment and "Green" for a
// replacement environment.
type InvalidInstanceTypeException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidInstanceTypeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInstanceTypeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInstanceTypeException) ErrorCode() string             { return "InvalidInstanceTypeException" }
func (e *InvalidInstanceTypeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified key prefix filter was specified in an invalid format.
type InvalidKeyPrefixFilterException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidKeyPrefixFilterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidKeyPrefixFilterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidKeyPrefixFilterException) ErrorCode() string {
	return "InvalidKeyPrefixFilterException"
}
func (e *InvalidKeyPrefixFilterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A lifecycle event hook is invalid. Review the hooks section in your AppSpec file
// to ensure the lifecycle events and hooks functions are valid.
type InvalidLifecycleEventHookExecutionIdException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidLifecycleEventHookExecutionIdException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidLifecycleEventHookExecutionIdException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidLifecycleEventHookExecutionIdException) ErrorCode() string {
	return "InvalidLifecycleEventHookExecutionIdException"
}
func (e *InvalidLifecycleEventHookExecutionIdException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The result of a Lambda validation function that verifies a lifecycle event is
// invalid. It should return Succeeded or Failed.
type InvalidLifecycleEventHookExecutionStatusException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidLifecycleEventHookExecutionStatusException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidLifecycleEventHookExecutionStatusException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidLifecycleEventHookExecutionStatusException) ErrorCode() string {
	return "InvalidLifecycleEventHookExecutionStatusException"
}
func (e *InvalidLifecycleEventHookExecutionStatusException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An invalid load balancer name, or no load balancer name, was specified.
type InvalidLoadBalancerInfoException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidLoadBalancerInfoException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidLoadBalancerInfoException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidLoadBalancerInfoException) ErrorCode() string {
	return "InvalidLoadBalancerInfoException"
}
func (e *InvalidLoadBalancerInfoException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The minimum healthy instance value was specified in an invalid format.
type InvalidMinimumHealthyHostValueException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidMinimumHealthyHostValueException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidMinimumHealthyHostValueException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidMinimumHealthyHostValueException) ErrorCode() string {
	return "InvalidMinimumHealthyHostValueException"
}
func (e *InvalidMinimumHealthyHostValueException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The next token was specified in an invalid format.
type InvalidNextTokenException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidNextTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidNextTokenException) ErrorCode() string             { return "InvalidNextTokenException" }
func (e *InvalidNextTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A call was submitted that specified both OnPremisesTagFilters and
// OnPremisesTagSet, but only one of these data types can be used in a single call.
type InvalidOnPremisesTagCombinationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidOnPremisesTagCombinationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOnPremisesTagCombinationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOnPremisesTagCombinationException) ErrorCode() string {
	return "InvalidOnPremisesTagCombinationException"
}
func (e *InvalidOnPremisesTagCombinationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An invalid operation was detected.
type InvalidOperationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOperationException) ErrorCode() string             { return "InvalidOperationException" }
func (e *InvalidOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The registration status was specified in an invalid format.
type InvalidRegistrationStatusException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidRegistrationStatusException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRegistrationStatusException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRegistrationStatusException) ErrorCode() string {
	return "InvalidRegistrationStatusException"
}
func (e *InvalidRegistrationStatusException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The revision was specified in an invalid format.
type InvalidRevisionException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidRevisionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRevisionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRevisionException) ErrorCode() string             { return "InvalidRevisionException" }
func (e *InvalidRevisionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The service role ARN was specified in an invalid format. Or, if an Auto Scaling
// group was specified, the specified service role does not grant the appropriate
// permissions to Amazon EC2 Auto Scaling.
type InvalidRoleException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidRoleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRoleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRoleException) ErrorCode() string             { return "InvalidRoleException" }
func (e *InvalidRoleException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The column name to sort by is either not present or was specified in an invalid
// format.
type InvalidSortByException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidSortByException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSortByException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSortByException) ErrorCode() string             { return "InvalidSortByException" }
func (e *InvalidSortByException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The sort order was specified in an invalid format.
type InvalidSortOrderException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidSortOrderException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSortOrderException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSortOrderException) ErrorCode() string             { return "InvalidSortOrderException" }
func (e *InvalidSortOrderException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The tag was specified in an invalid format.
type InvalidTagException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidTagException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTagException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTagException) ErrorCode() string             { return "InvalidTagException" }
func (e *InvalidTagException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The tag filter was specified in an invalid format.
type InvalidTagFilterException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidTagFilterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTagFilterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTagFilterException) ErrorCode() string             { return "InvalidTagFilterException" }
func (e *InvalidTagFilterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified tags are not valid.
type InvalidTagsToAddException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidTagsToAddException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTagsToAddException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTagsToAddException) ErrorCode() string             { return "InvalidTagsToAddException" }
func (e *InvalidTagsToAddException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The target filter name is invalid.
type InvalidTargetFilterNameException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidTargetFilterNameException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTargetFilterNameException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTargetFilterNameException) ErrorCode() string {
	return "InvalidTargetFilterNameException"
}
func (e *InvalidTargetFilterNameException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A target group pair associated with this deployment is not valid.
type InvalidTargetGroupPairException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidTargetGroupPairException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTargetGroupPairException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTargetGroupPairException) ErrorCode() string {
	return "InvalidTargetGroupPairException"
}
func (e *InvalidTargetGroupPairException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The target instance configuration is invalid. Possible causes include:
//
// *
// Configuration data for target instances was entered for an in-place
// deployment.
//
// * The limit of 10 tags for a tag type was exceeded.
//
// * The combined
// length of the tag names exceeded the limit.
//
// * A specified tag is not currently
// applied to any instances.
type InvalidTargetInstancesException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidTargetInstancesException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTargetInstancesException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTargetInstancesException) ErrorCode() string {
	return "InvalidTargetInstancesException"
}
func (e *InvalidTargetInstancesException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified time range was specified in an invalid format.
type InvalidTimeRangeException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidTimeRangeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTimeRangeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTimeRangeException) ErrorCode() string             { return "InvalidTimeRangeException" }
func (e *InvalidTimeRangeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The configuration that specifies how traffic is routed during a deployment is
// invalid.
type InvalidTrafficRoutingConfigurationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidTrafficRoutingConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTrafficRoutingConfigurationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTrafficRoutingConfigurationException) ErrorCode() string {
	return "InvalidTrafficRoutingConfigurationException"
}
func (e *InvalidTrafficRoutingConfigurationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The trigger was specified in an invalid format.
type InvalidTriggerConfigException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidTriggerConfigException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidTriggerConfigException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidTriggerConfigException) ErrorCode() string             { return "InvalidTriggerConfigException" }
func (e *InvalidTriggerConfigException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The UpdateOutdatedInstancesOnly value is invalid. For Lambda deployments, false
// is expected. For EC2/On-premises deployments, true or false is expected.
type InvalidUpdateOutdatedInstancesOnlyValueException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidUpdateOutdatedInstancesOnlyValueException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidUpdateOutdatedInstancesOnlyValueException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidUpdateOutdatedInstancesOnlyValueException) ErrorCode() string {
	return "InvalidUpdateOutdatedInstancesOnlyValueException"
}
func (e *InvalidUpdateOutdatedInstancesOnlyValueException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An attempt to return the status of an already completed lifecycle event
// occurred.
type LifecycleEventAlreadyCompletedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *LifecycleEventAlreadyCompletedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LifecycleEventAlreadyCompletedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LifecycleEventAlreadyCompletedException) ErrorCode() string {
	return "LifecycleEventAlreadyCompletedException"
}
func (e *LifecycleEventAlreadyCompletedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The limit for lifecycle hooks was exceeded.
type LifecycleHookLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *LifecycleHookLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LifecycleHookLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LifecycleHookLimitExceededException) ErrorCode() string {
	return "LifecycleHookLimitExceededException"
}
func (e *LifecycleHookLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Both an IAM user ARN and an IAM session ARN were included in the request. Use
// only one ARN type.
type MultipleIamArnsProvidedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MultipleIamArnsProvidedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MultipleIamArnsProvidedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MultipleIamArnsProvidedException) ErrorCode() string {
	return "MultipleIamArnsProvidedException"
}
func (e *MultipleIamArnsProvidedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The API used does not support the deployment.
type OperationNotSupportedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *OperationNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationNotSupportedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationNotSupportedException) ErrorCode() string             { return "OperationNotSupportedException" }
func (e *OperationNotSupportedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The ARN of a resource is required, but was not found.
type ResourceArnRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceArnRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceArnRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceArnRequiredException) ErrorCode() string             { return "ResourceArnRequiredException" }
func (e *ResourceArnRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified resource could not be validated.
type ResourceValidationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceValidationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceValidationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceValidationException) ErrorCode() string             { return "ResourceValidationException" }
func (e *ResourceValidationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The named revision does not exist with the IAM user or Amazon Web Services
// account.
type RevisionDoesNotExistException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *RevisionDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RevisionDoesNotExistException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RevisionDoesNotExistException) ErrorCode() string             { return "RevisionDoesNotExistException" }
func (e *RevisionDoesNotExistException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The revision ID was not specified.
type RevisionRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *RevisionRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RevisionRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RevisionRequiredException) ErrorCode() string             { return "RevisionRequiredException" }
func (e *RevisionRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The role ID was not specified.
type RoleRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *RoleRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RoleRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RoleRequiredException) ErrorCode() string             { return "RoleRequiredException" }
func (e *RoleRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum allowed number of tags was exceeded.
type TagLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TagLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagLimitExceededException) ErrorCode() string             { return "TagLimitExceededException" }
func (e *TagLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A tag was not specified.
type TagRequiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TagRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagRequiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagRequiredException) ErrorCode() string             { return "TagRequiredException" }
func (e *TagRequiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of tag groups included in the tag set list exceeded the maximum
// allowed limit of 3.
type TagSetListLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TagSetListLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagSetListLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagSetListLimitExceededException) ErrorCode() string {
	return "TagSetListLimitExceededException"
}
func (e *TagSetListLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An API function was called too frequently.
type ThrottlingException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottlingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottlingException) ErrorCode() string             { return "ThrottlingException" }
func (e *ThrottlingException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum allowed number of triggers was exceeded.
type TriggerTargetsLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TriggerTargetsLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TriggerTargetsLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TriggerTargetsLimitExceededException) ErrorCode() string {
	return "TriggerTargetsLimitExceededException"
}
func (e *TriggerTargetsLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A call was submitted that is not supported for the specified deployment type.
type UnsupportedActionForDeploymentTypeException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *UnsupportedActionForDeploymentTypeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedActionForDeploymentTypeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedActionForDeploymentTypeException) ErrorCode() string {
	return "UnsupportedActionForDeploymentTypeException"
}
func (e *UnsupportedActionForDeploymentTypeException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}
