// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

type AccessDeniedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedException) ErrorCode() string             { return "AccessDeniedException" }
func (e *AccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Non-retryable exception. Attempted to create already existing object or chunk.
// This message contains a checksum of already presented data.
type DataAlreadyExistsException struct {
	Message *string

	Checksum          *string
	ChecksumAlgorithm *string

	noSmithyDocumentSerde
}

func (e *DataAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DataAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DataAlreadyExistsException) ErrorCode() string             { return "DataAlreadyExistsException" }
func (e *DataAlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Non-retryable exception, indicates client error (wrong argument passed to API).
// See exception message for details.
type IllegalArgumentException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *IllegalArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalArgumentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalArgumentException) ErrorCode() string             { return "IllegalArgumentException" }
func (e *IllegalArgumentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Non-retryable exception. Indicates the KMS key usage is incorrect. See exception
// message for details.
type KMSInvalidKeyUsageException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *KMSInvalidKeyUsageException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSInvalidKeyUsageException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSInvalidKeyUsageException) ErrorCode() string             { return "KMSInvalidKeyUsageException" }
func (e *KMSInvalidKeyUsageException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Retryalble exception. Indicated issues while reading an input stream due to the
// networking issues or connection drop on the client side.
type NotReadableInputStreamException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *NotReadableInputStreamException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NotReadableInputStreamException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NotReadableInputStreamException) ErrorCode() string {
	return "NotReadableInputStreamException"
}
func (e *NotReadableInputStreamException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Non-retryable exception. Attempted to make an operation on non-existing or
// expired resource.
type ResourceNotFoundException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string             { return "ResourceNotFoundException" }
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Retryable exception. In general indicates internal failure that can be fixed by
// retry.
type RetryableException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *RetryableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RetryableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RetryableException) ErrorCode() string             { return "RetryableException" }
func (e *RetryableException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Deprecated. To be removed from the model.
type ServiceInternalException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ServiceInternalException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceInternalException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceInternalException) ErrorCode() string             { return "ServiceInternalException" }
func (e *ServiceInternalException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Retryable exception, indicates internal server error.
type ServiceUnavailableException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceUnavailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceUnavailableException) ErrorCode() string             { return "ServiceUnavailableException" }
func (e *ServiceUnavailableException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Increased rate over throttling limits. Can be retried with exponential backoff.
type ThrottlingException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottlingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottlingException) ErrorCode() string             { return "ThrottlingException" }
func (e *ThrottlingException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
