/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn client.
 * Copyright (C) 2008 - 2012 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/




#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
/* For tolower.. */
#include <ctype.h>
#include "widgets.h"
#include "allocate.h"
#include "functions.h"
#include "show_info.h"
#include "commands.h"

#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE
#endif

#if ! defined USE_DARWIN
    #ifndef _CRYPT_H
      #include <crypt.h>
    #endif
#endif


/* Compare strings in lower case */
int cmplowercase(char *buf, char *cmpstring)
{
    char *p, *newbuf;
    int retval = 0;

    if( buf==NULL )
        return retval;

    /* Ignore single newline chars */
    if( strlen(buf) < 2 )
        return retval;

    newbuf = allocate(strlen(buf)+1);
    /* Exits if it cant allocate */
    sprintf(newbuf, "%s", buf);

    for(p = newbuf; *p!='\0'; ++p)
        *p = tolower(*p);

    if( strstr(newbuf, cmpstring) )
      retval = 1;

    free(newbuf);

    return retval;
}

char *encrypt_password(G_CONST_RETURN gchar *password)
{
    /* Make an encrypted password using the MD5 algoritm */
    int i=0, where=0, randlen=8; /* The max MD5 random string size is 8 */
    char *rnd_string;
    char salt[13]=""; /* The total salt length is 12 */

    /* 64 chars */
    char *arr[]={"A","B","C","D","E","F","G","H","I","J","K",
         "L","M","N","O","P","Q","R","S","T","U","V",
         "W","X","Y","Z","a","b","c","d","e","f","g",
         "h","i","j","k","l","m","n","o","p","q","r",
         "s","t","u","v","w","x","y","z","0","1","2",
         "3","4","5","6","7","8","9",".","/"};
    
    srand((unsigned)time(NULL));

    rnd_string = allocate(9);
    
    while( i < randlen )
    {
        where=rand()%64;
        strcat(rnd_string, arr[where]);
        i++;
    }

#if defined HAVE_CRYPT
    /* For this to work it must have linked with -lcrypt */
    sprintf(salt, "$1$%s$", rnd_string);
#else
    /* We cant use MD5 salting and the salt can only be 2 chars */
    sprintf(salt, "%s", &rnd_string[6]);
#endif

    free(rnd_string);

    return crypt(password, salt);
}

void make_dir_chmod(gchar *directory, char perm[128])
{
    gchar *command;

    command = g_strdup_printf("mkdir -p %s && chmod %s %s", directory, perm, directory);
    if( ! run_command(command) )
        printf("Error running command: %s\n", command);    

    g_free(command);
}

void chmod_file(gchar *filepath, char perm[128])
{
    gchar *cmd;

    cmd = g_strdup_printf("chmod %s %s", perm, filepath);
    if( ! run_command(cmd) )
        printf("Error running command: %s\n", cmd);    

    g_free(cmd);
}

int commented(char *line)
{
    int i, ret = 0;

    if( line!=NULL && strlen(line) > 0 )
    {
        for(i=0; line[i]!='\0'; i++)
        {
            if( i > 9000 )
            {
                ret = 1;
                break;
            }

            /* Skip whitespace */
            if( line[i]==' ' || line[i]=='\t' )
                continue;
            
            /* If the first char thats not whitespace is '#' or ';'
               then the line is commented out */
            if( line[i]=='#' || line[i]==';' )
              ret = 1;
            else
              ret = 0;

            break;
        }
    }
    return ret;
}

int chars_are_digits(char *buf)
{
    int i=0, match=0;

    for(i=0; buf[i]!='\0'; i++)
    {
        if( buf[i]=='\n' || buf[i]=='\r')
        {
            i--;
            break;
        }
        if( buf[i]=='0' || buf[i]=='1' || buf[i]=='2' || buf[i]=='3' || buf[i]=='4' 
        ||  buf[i]=='5' || buf[i]=='6' || buf[i]=='7' || buf[i]=='8' || buf[i]=='9' )
            match++;	 
    }
    if( match && match==i )
       return 1;
    else
       return 0;    
}

