# pylint: disable=all
# flake8: noqa
from typing import Any
from typing import Iterable
from typing import List
from typing import Optional
from typing import Tuple
from typing import Union

from beancount.core.data import Directive
from beancount.core.data import Entries
from beancount.core.data import Posting
from beancount.core.data import TxnPosting
from beancount.core.inventory import Inventory

TxnPostingList = List[Union[Directive, TxnPosting]]

class RealAccount(dict):
    account: str = ...
    txn_postings: TxnPostingList = ...
    balance: None = ...
    def __init__(
        self, account_name: Any, *args: Any, **kwargs: Any
    ) -> None: ...
    def __setitem__(self, key: Any, value: Any): ...
    def copy(self): ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...

# def iter_children(real_account: , leaf_only: bool = ...) -> None: ...
# def get(
#     real_account: , account_name: , default: Optional[] = ...
# ): ...
def get_or_create(
    real_account: RealAccount, account_name: str
) -> RealAccount: ...

# def contains(real_account: , account_name: ): ...
def realize(
    entries: Entries,
    min_accounts: Optional[Iterable[str]] = ...,
    compute_balance: bool = ...,
) -> RealAccount: ...

# def postings_by_account(entries: ): ...
# def filter(real_account: , predicate: ): ...
def get_postings(real_account: RealAccount) -> TxnPostingList: ...
def iterate_with_balance(
    txn_postings: TxnPostingList,
) -> List[Tuple[Directive, List[Posting], Inventory, Inventory]]: ...

# def compute_balance(real_account: ): ...
def find_last_active_posting(txn_postings: TxnPostingList) -> Directive: ...

# def index_key(sequence: , value: , key: , cmp: ): ...
# def dump(root_account: ): ...
#
# PREFIX_CHILD_1: str
# PREFIX_CHILD_C: str
# PREFIX_LEAF_1: str
# PREFIX_LEAF_C: str
#
# def dump_balances(
#     real_root: ,
#     dformat: ,
#     at_cost: bool = ...,
#     fullnames: bool = ...,
#     file: Optional[] = ...,
# ): ...
# def compute_postings_balance(txn_postings: ): ...
