
# How to benchmark FAUST generated code # 

This folder contains what is needed to benchmark the efficiency of programs generated by the Faust compiler on Intel processors. Several options are considered, scalar code, vector code and parallel code (OpenMP and Sch). The C++ compiler used and their options are also considered.

The elements to produce the benchmarks are the following :

- you can either use the .dsp files already in the folder or replace them with your own .dsp files.

- `alsa-gtk-bench.cpp` is the architecture file used for the benchmarks on Linux. It corresponds to an alsa GTK application specially equipped to measure the time it takes to process the samples. The application will do 600 measurements before quitting automatically. The mean value of the 10 best measurements will be retained. Instead of being expressed in seconds this value will be converted in throughput in MB/s, that is the number of bytes of samples the application is able to process per seconds. 

- `coreaudio-gtk-bench` is the architecture file used for the benchmarks on OSX. It corresponds to an CoreAudio GTK application specially equipped to measure the time it takes to process the samples. The application will do 600 measurements before quitting automatically. The mean value of the 10 best measurements will be retained. Instead of being expressed in seconds this value will be converted in throughput in MB/s, that is the number of bytes of samples the application is able to process per seconds. 
Note: `alsa-gtk-bench.cpp` and `coreaudio-gtk-bench` uses rdtsc as a wall clock. It is therefore specific to x86 processors and must be adapted for other processors. In order to convert clocks to seconds the code measure the number of clocks per seconds unless the the environment variable CLOCKSPERSEC is set with the exact value to use for the conversion.

- the file Makefile contains the various combinations of Faust options and gcc or icc options you may want to test. If you have gcc and icc installed you can just do a `make`. If you have only gcc installed do a `make gcc`. For icc do a `make icc`. This will produce several variants of audio applications in separate directories : {i,g}alsa{scal,vec,omp,sch,..}dir, or {i,g}coreaudio{scal,vec,omp,sch,..}dir. Check the Makefile for possible targets.

- the script `bench.sh` will run all the binaries of all the directories and collect their results in a single `results-yymmdd.hhmmss` file. Run bench.sh several times to be sure of the stability of the results.



 
