/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.datamodel.SequenceI;

public class Comparison {
    public static final String GapChars = " .-";
    static final int caseShift = 32;

    public static final float compare(SequenceI ii, SequenceI jj) {
        return Comparison.compare(ii, jj, 0, ii.getLength() - 1);
    }

    public static float compare(SequenceI ii, SequenceI jj, int start, int end) {
        String si = ii.getSequenceAsString();
        String sj = jj.getSequenceAsString();
        int ilen = si.length() - 1;
        int jlen = sj.length() - 1;
        while (Comparison.isGap(si.charAt(start + ilen))) {
            --ilen;
        }
        while (Comparison.isGap(sj.charAt(start + jlen))) {
            --jlen;
        }
        int count = 0;
        int match = 0;
        float pid = -1.0f;
        if (ilen > jlen) {
            for (int j = 0; j < jlen; ++j) {
                if (si.substring(start + j, start + j + 1).equals(sj.substring(start + j, start + j + 1))) {
                    ++match;
                }
                ++count;
            }
            pid = (float)match / (float)ilen * 100.0f;
        } else {
            for (int j = 0; j < jlen; ++j) {
                if (si.substring(start + j, start + j + 1).equals(sj.substring(start + j, start + j + 1))) {
                    ++match;
                }
                ++count;
            }
            pid = (float)match / (float)jlen * 100.0f;
        }
        return pid;
    }

    public static final float PID(String seq1, String seq2) {
        return Comparison.PID(seq1, seq2, 0, seq1.length());
    }

    public static final float PID(String seq1, String seq2, int start, int end) {
        int s2len;
        int s1len = seq1.length();
        int len = Math.min(s1len, s2len = seq2.length());
        if (end < len) {
            len = end;
        }
        if (len < start) {
            start = len - 1;
        }
        int bad = 0;
        for (int i = start; i < len; ++i) {
            char chr1 = seq1.charAt(i);
            char chr2 = seq2.charAt(i);
            if ('a' <= chr1 && chr1 <= 'z') {
                chr1 = (char)(chr1 - 32);
            }
            if ('a' <= chr2 && chr2 <= 'z') {
                chr2 = (char)(chr2 - 32);
            }
            if (chr1 == chr2 || Comparison.isGap(chr1) || Comparison.isGap(chr2)) continue;
            ++bad;
        }
        return 100.0f * (float)(len - bad) / (float)len;
    }

    public static final boolean isGap(char c) {
        return c == '-' || c == '.' || c == ' ';
    }

    public static final boolean isNucleotide(SequenceI[] seqs) {
        int iSize = seqs.length;
        float nt = 0.0f;
        float aa = 0.0f;
        for (int i = 0; i < iSize; ++i) {
            int jSize = seqs[i].getLength();
            for (int j = 0; j < jSize; ++j) {
                char c = seqs[i].getCharAt(j);
                if ('a' <= c && c <= 'z') {
                    c = (char)(c - 32);
                }
                if (c == 'A' || c == 'G' || c == 'C' || c == 'T' || c == 'U') {
                    nt += 1.0f;
                    continue;
                }
                if (Comparison.isGap(seqs[i].getCharAt(j))) continue;
                aa += 1.0f;
            }
        }
        return nt / (nt + aa) > 0.85f;
    }
}

