//  Copyright 2016 John Maddock. Distributed under the Boost
//  Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

static const boost::array<boost::array<typename table_type<T>::type, 3>, 42> gamma_1_2 = {{{SC_(1.00000143051147460937500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.99999174288391999092757871949960760944599692334161113632612001448234829888352099654097074654344285708898686038400924243326257000995473599459860412189476206535957778861551088462375468578938240500307167618043731787467573306745319965463132052615688418631316435531309275145303892395341676733095522386701856522207240447267708668301329563326443831046210450368179263405643106444973478994275343456845976754204700528622443064906871609264433329448562184863557194334628845647631027980086626707202034219860132039e-01), SC_(-8.25711948900924692597299306183832574130326734078524848537366321722804959189414089321374321487571322916700881394838168937675017756067526027059906924659380618507813551107141661082752510377407448366888067712646753094821383103251070103298799663269077425948810538745741157050557462080083874347930605957984000258314264095908394093097201357665227991167061298266665567091332898437498972810629979744483195488186797207794753595348181654435055140261537588799716884603608921499148980999953580901141143177940912987e-07)},
                                                                                           {SC_(1.00000190734863281250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.99998899052088870556298015139749114669312651159953142848295392815303317500016029969635974482718991700497816055817263571292901954688370348906253549005287861083171410201406647883485474421222649893000205148346129113166971062186410799748091336730057656052509954292585979817626028277775407407112537788176094920236533009104994139384430523864665582176691381647483160502797293814016280767994802120063648051546796192887146643586658388925305855542153022171696856252158767172309183370455258068376853535216362470e-01), SC_(-1.10094851717304002712268894099127595921487972573933586334689334527229248323934919014638550108524145553527405840273344353639000207218741487766297554573091476469480049905558271838458052416000410785954618163762239772914309942293307957081996934083616872743593791436745000684254951241300456576383726667911197040993317728453157236842228209877681100498209542136619826560930165076125847234456840374995616717759747291279589613997037378064178672114262185168274084948288257929977168303768505416039428474173888808e-06)},
                                                                                           {SC_(1.00000715255737304687500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.99995871482439030123562974470516145713394424812766636877383802416011979320279049083203112581733456099995683282738209665836532102308697025612534875128891666457345958520964130243018916433692201391748875528601051438277602513487355536872792386028259758535373151611332556663150738220804194424251848920431250539383936484964316068698893034940814586752406503829065074575875145977149630424770495659102034695665964258237898580634499483188073724936730054003089085359012125236558137262535083336056587140852800456e-01), SC_(-4.12852608332195851691203735959218082583309360270436920767851544796916430110170536266576060329474456009336058048427569309546294249770163912414335808655484082224000396074276450271816190829739395101572464054265620776265007334847480163917450671956548131916218767194273440313568874946498741895154818277265159531908173961864655218297464043731661102093299016819229971909322404880656592327408588191219928932127624518196151869557514361114934732089059682453199895851884381325844177861206907545771018319777526395e-06)},
                                                                                           {SC_(1.00001382827758789062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.99992018290683797846000226935056171185859936503128820835471750919976663152444739936675800355406606711512157240239127384452319098942674657017897817468120805836926848121657068423652761200611382709254842088377275403963217241357409925817025690122325186353402737193791739281574809393066322820848698863824029214072384456058169355314312772713088236719681578106869264305967664276510843791749709913005299240434221449190581606080546735845029507633743966156522363875224608869485434247381577247694136841387337506e-01), SC_(-7.98174117021345792583197715106148864099769997469814968659586924923411082051309399423820083379003398574828706106026847702771900443355053076333928564661934959347977543844422372354610528704694194514369673005031394800075820697954595056265037686466809758696282814462959586452027325510485481129596043614869818722579861830854885232173045580402917981131629803571485201158990471407846736365894690896340575434314344665619486163529114866521238533471912104264466874277993839991170047144881087379199096956344930374e-06)},
                                                                                           {SC_(1.00001716613769531250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.99990091727863163325242222177264151557699017886575216984231288977651535626638346381310234072695038675659981791249420691007156006802164340387989178169488325851634552002703894997675940814211199538881805758913622490627980631399097588920415763179341948229307099650348008989816592713813726915109074989891788978965796994913538811183413860908256492363372407238104866387595665466503765367010396538799223340678265221385147175632220501459281016668716802117533163355282958056372905167080533658897792045054410079e-01), SC_(-9.90832122408929040408559547336655735086172539547473819642814546268213452104179698046816192544343649213516276050992499286077179633065711247130052986266586612792198019407011580703718749973206816410430099598884696898621732263753199017370635170322352068229418089019905571698341346767171969043521773124763386169098538786284978144876183616053588253360709161373130687567240750392131068350600396793696828309634567406848106245558829741030294161625454805367042624975175240236006902139797188269658688359388850604e-06)},
                                                                                           {SC_(1.00006008148193359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.99965323597539602107075328547761587261019813359390369760751109252264732839906671037031518875134968012136696641174447037803904262082887969976109296285684390252157866836780186592932702237009167943025982890755934376143300721600433843080584322613515975251145176495194038059333781579482810573482380992838639055654464946705171224947543458455875016762570976299577906723146773198425090625559656009265422616400519050536628957500842705209930585910280037352659669895054043861427070231539351464283935980884908931e-01), SC_(-3.46770037007409655757667178857746223190711811787178225776104706289662004501688838200316229177747817138199803885280303413474034927454764780105040241282675413678168958627420206298519414644689489796825217807297340862467260672318740929958999360584422503219415448595860007050952381087378585257254009183598634422465183290108846220184440918709834134414756286915640039850168914802758353098152897222212865686814139570252607648258247174783738621351343846323154823824135361645528936757373238593936453258830559626e-05)},
                                                                                           {SC_(1.00011682510375976562500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.99932580217349322111022028953617401331744333751403970060804097152155125562795257245209990189244390955065622803586974115564775452579165277800679992202499294033532574731584142945934294435673450155960678373595954883991435191422966953073303251361033522456325375489064785213746192226948204738894305982149533115149748405385850564842587242123139516721576059297438931817529512643270863422808208534475683331512001048644854819051058927620674300198483640232556173168539289960682363209643255386743487137951435608e-01), SC_(-6.74220554663799556877310402772443112760157761571902023463311635516217433897770295691084680383277023834238210219871774978089885153707718168224025213708002539939323526485458159206065857983075309830686070983216968357999309570523171700990741684698946763301064392077432210536224126429808942160450023453639044757019826692163047432599057748754815292572362647469482812022241942671262055942485364235176211540596083535537009938706493439634976520904423708619194103147768525477352233702757523202626115873106021273e-05)},
                                                                                           {SC_(1.00014877319335937500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.99914147670522157119990095816051182525869285752191570299986635498915136588896493248365257759438213001482731183963093196649233881218040818957792374396660936598196305684819148527571896894670840843075654286835564773000594859074473690225403830688350354252139596396883469105131902182804954743787255215002586550458745855022390733700033552487189754708762505434494766042941772545691183075216127229908050031032252997777058211897547918467712668931901682746348165792889219319764070713850889628242784768424868130e-01), SC_(-8.58560150000232182840017338970199207015444462387386607649752923794156356753324749863484023674482826368894211048585691962413851546114269579480065761062341760434702534740992077291531596054368583871596159082563812571726762650773153069310637429285445540476388286200085615639301380104059851185751956992083481298692217441089203287067778907940777696367340030092049574459913524572177529000648022805010658269187678613395820117311947653348295570171839424515238720298923295035866057993641637438770886487510361427e-05)},
                                                                                           {SC_(1.00039815902709960937500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.99770333110831492808746107899166135280142203963707103455559351498353730379622819894763111240763432539056047936359580766442659319921652358936987966214938950939435663301222127947502411131332209082447717639899925306161185533504539560696196046757852273728024849898337683541947420067193081937907625447769106391972105734465495304033409391663299515305873457058683377675271966433428080840182451133769485259668772279477913835172938605800816170644204743795319739336290349933820409636830617776722200662226423410e-01), SC_(-2.29693266647263659905267506634368150483626461773464138564883162577609178712280408452312056570476352591647966867985753773286072034838577415545063255615155600715276129983764450847384254995243544335451212874166249277514712689608517250431900213708104149683916395785770433269863454207362975420101202621074988088246180747303492773111501326915687144736749558273211568644678725198708337441028102186739131006289732732451411357227579446820937346539059417079097069904499656657749370706773592719032343614925133271e-04)},
                                                                                           {SC_(1.00063848495483398437500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.99631859447795538102193086350466626797653070729794205440800520055636280763885061673862015030796869853893789243475736071832934110880676018608126876844999256516872278028164486551902037327521458584687257382213309438429801326762332746780555937892390377489762791671064874927604230957617846733925263989858598196284959978561705689127705026814246454264077811405090206416845460825762177518652427086599576814868159221508338773364149774888148314871107526895227752545125757315695610947566263171638714842858738272e-01), SC_(-3.68208332573195956331210081624594239749394416803950908768685933543093626633451555793231113756331335425963182990684777112954271367958172970283738601921956301734980965046021109384234366447704543598220974149455699644080458292345192792596261425685403086325921370880394538207189224801004010561669507034655239854624541613368723129243328830529900319847443342058489559670277958326928917863667680577628031005468470452675568722782294683578292536699572826364160501920571986429433940804663506127245264105983664301e-04)},
                                                                                           {SC_(1.00107145309448242187500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.99382674822601667403239575382618951458893199251301947146215993352196283762341237298698231312941265613694903447679790369281559605314211409159830913156190622044924254885952656386521417492543976139615818498174187287133742132249380106828717540300112779917059538337849851096305151233791188029858916028445980753589436609863762082166374840070247490176396648225666182221677814131865874707658977935654371728304366144253753158711600380365080650129423678311958337349802342329016782920332415801360758065052764693e-01), SC_(-6.17515801040877325131151232919778004462797029509263756439665376295049986314719517615619416044020139941656219729463770419342221308377598718445537314327839397064675755119235423378203363475348607407689849591829201234719170773126477412940229835868424119423489707620954508876185462076594438172323119672045609009061662915362180538360149343723949200326445809001654182581777638480231628275052706847821672195497723988024572921599072175197242142212195116944762930191378376328084045634116582617540525060723552551e-04)},
                                                                                           {SC_(1.00302171707153320312500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.98264823461931536749416512755660281120989924865707625229833257960645264035500100250336898184907448998921042036230368188091708046504522273427794078979113111960829807534456665305177251159579747032678402428834297225115471239166750815621846487365110340243197886307308000837905364975250652215207125797086578339200177075082274308974522430592585814094736901318362632618659922741288815306432900856791717414156527945120488582581537806945315376665198216838443054961618230007143995001406730984367520071959292714e-01), SC_(-1.73668370059196286526539979196054130140895376467504060472269120641199689896392717833308713991174930707390895685228964418616313569936348016118980224344687827465558226448493405115419933128303920683280943663247672453726972961437611838482173177548854889388730797437720783444466661451141517724151590371105457213113919681710114442333257409145438562709571297072489258507270738823389529512161726965101165499837215710030502282466952003769887407843034316530688055949633407900696533642354006548208448645662316917e-03)},
                                                                                           {SC_(1.00499391555786132812500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.97141987555054340304313176463811884706264975589409907711234106560058609393271957307055082872891129410102083699500728283618347812653629468281551207846668700643470399586576624117253612700605418076832930868289087002572928070786756405137053359765443944765968271908912062956518242691227870162853819197340367908118996679846253679049356114011183750259927716203480089987629318935061831663652778532993830636783378403442682358220843386678860533265544542528384278621171051277427390347574579492853577100128619407e-01), SC_(-2.86210436087086001219787203735569562421372152373863548640068045829675888249714024869717239721994061219165785957749026372538378678509251738859065487118286167323424304865392614274250231752411862994497835172325480685039413276552426722185380374001250774890081771218253381634489468447683838615323458562556132390816770034833055105238636360789783990787873918822664133911201583322251908688863597569845687382260426660773087641598696053109034352095877056488917071635782120160167491767030736813586543030924751972e-03)},
                                                                                           {SC_(1.00928401947021484375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.94725649294890404479691100544964299212951704478613530903971822806017329877156708018465369324189948798034254635780503202894085998084733850371417658768318005687261606936611555053869547658745148804444802910439708812910773154353420286199364712053375318222724588767021914345493933709903167527793547413249855259854089366858866896664154070656991436736886582807429735741274943744190439486793177574882112810679231693943021915551996830675255244876341153517755183653646041518858296397522796201891082052630011680e-01), SC_(-5.28830919574000394857298213309555217277552558169501942679144421480630307191430194474561267421233056506945756642955882873960771251210761377932729055199230933294031635221988391115425824318672303823777879654381369427266345995275947337336618588685415927144581932003652590401257458835032565848265828024191566846037511249492915676767412627621261275712261144003161259984311425096376028822716363239133708904326402490271273591177695515131973061269294472455115171077929366425109455097808718265759636660823511773e-03)},
                                                                                           {SC_(1.02416992187500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.86614048062602117123406311118908657526377765145590897833523630975503363209176138538389943023236553603567032030295329814866052858161398959719488439602760043127493599629647790910368650401083097710387444443112945732297448026376057799816375936299971289892260452026548899140129220485002888583419955984239574912694509374491745016651528016606029396150839935179771239942510295480902170767514068781705260053508993213902538634255145495226403542335065511017877104815179205392647102946016289317357707173178319778e-01), SC_(-1.34763514204995372109520288412048333775377813106008243000148150918296004262962726414132914028794577353429614250975299694173700835973336120904901398475019010957711015087496744076484212085372674226997687893794106127390983166014459284671204531469581065659308636723155764096816681418792159648003075197102825097837643825841085478699904544782275291790410274144152650577672862729352423481593131480537858719681819399045310180592496365519546516973520373011933766484977458014591739445077700073769103597250567667e-02)},
                                                                                           {SC_(1.06227731704711914062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.67683284737636217813685234156898327768051602711302285901829303009936564635927633847791905521633600182260778451883080067109265151115529992925211612926715722203426431025001128565716170432011945340670439807499803976561841973814640123513684707855300283766826345586152363103902831064307590922557520983011890727883861293257299222429489009382052966333548186633019471937742818976913809802674997409468133243009640443196713199007760299064535991343883139271256226294904557987948005599961383926203112142304751891e-01), SC_(-3.28504304307040642219585079239267415655387519327605107558648615710409468862569859227455978653146395616102834823083140570843368962391564290326611187884817002376245922067354288141538130729190429210727139841839276253448391616940778575204647813069308428390814330462539441519296405032309130029624726521666062066510420118474939973861641972779471516623719555431865569868101377367606319715633947259100590108593611531959008242872074641637498065015954588974509068119809908143583335322131919999217251753951186048e-02)},
                                                                                           {SC_(1.12234401702880859375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.42719540443721868609002739661970901317374072285768379447466866954674796223379001999201565264677947553367307391082852503202607769289913522567688887058955685132616165787742839855998640874824219137049123198709821760747886535404924436193564823937315970827009692703009325365564932429177420389197235892443670127598813072041078050012898789236697316107241881629714345634175264626532960435557492555881063944965513891366901261370042103809394595612230568364837051250994297966981292812529454999511053648268266764e-01), SC_(-5.89864526271249351144556212579822618917436335049065095559579674127451726947716815647990915471041353567929075619948343725717548053442557223884779131419367919157584133387553223567375506176942960614314964694763936598785587324632686320182733715386907383114749720665798633555874573366724394801004742262541189978425319883592782254726978670759080718710838718774274176068877873338044184550009341943947599806101348846632287258040041525848381664958987160401558865553412301389282414760154376012162803848258086080e-02)},
                                                                                           {SC_(1.24955749511718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.06493816701717652070796129681189279368155581078682075820670134311300664131805878872586560909347774849547077856785642913530318887990663829885598997306430503539463747760384445798729628986584285556511189918203631381512642237968267976800749340764140551780790213440489556072013302545763169764814551474864925015186841329299201026352946069132722200522135595378262960918915145172163243476478068099324456198209609874843860356636542021486098870105783313973496928190246231924822313645766881423162228482926452743e-01), SC_(-9.81710698786497220376429335539270291577202696321668505055577023289661137227566055993679749549766918458699591847594920910105255828822634290141131935936546209147240316032812525952523382179180640249028818445846744545617651819215028796677831516376847157547306218459444490819966549093798582410582121073841724280247709105859157726125972512495037490263556773941212263105105345816502885995240534301400324958919560073963596185728670816181963867297997989630900958703732881856633201726987832993395543288655355655e-02)},
                                                                                           {SC_(1.49122190475463867187500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(8.85975092788991742528041047924561577192733154188411771443460511494016648390575001890695683272836236515321056943442804539359597265274910084710921603660396269156598507728775879061867953195401830327778287272821941688982147004473011352892866957493463356307424660232522691594801771101120466915823926551028340522696126815833575982012695964065305355745762363170848885276046624884963565926602220756773747996380869706730672003309814235399043910590132770511920234964269726502103389367669862235505150898557966263e-01), SC_(-1.21066440748512404475024426968054339220139475801816468185017851452260119203818813132939295220966959576860336864073002283446059920152906043012149024456589573987061299654713751597706989918988719559690035557918832819457973675159107009641096292984585286590294204090882255710857113184702854471283701290417226824298947728969222795981705252849942735333352549341821313583386938754136637061655567217513693143381971281132686015952311886746414259153818520215140430872206179626007079632596580406780773162650910071e-01)},
                                                                                           {SC_(1.98384714126586914062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(9.93277940863746060094197659735027757230706286917741917762496289768909973927152319136925826790987137836060306879047113080832050742214997883337058606749529722735374603438145977294427160833784267011312076909076550541477208463886596934763667375400780519791449104728834334555489059974684968690493160617288828111978728838786866301310864555490911074901146366512699766804528603943358823947495513863982273895087758009700096077066283343694119497087163296220588369077116759749556165607389286281631813045097817428e-01), SC_(-6.74475393680727792069762024270330812537700489703053013284255062343350182439674474578730149516053038676811013704009948324320350047574120923780989626605300836004879573275984536698779115493092794651554687907372115587742289911340235342079018983733618420038276859524379547071361323963477361912857826074181438032171394433343549277630241247535256024056315554535944762558500606719649195939605908602554320144187923405070267451743300647279690038646110638038235596246122379284569329673191480466839566772904937236e-03)},
                                                                                           {SC_(2.00000095367431640625000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00000040319893632897083396218235250442687645120641744558071205705190318147242371991332042156751805833852697631957330509506196708584945266641045457660989815172203541816266426236940069173585211589763128871697578680808418618594108833421417980995744773022193915847912330485683365230207586357094671604272787550530903600224806658987408719323099820976084511227529072261830260642708557524072773978716369615012122132057589880483944058104433222796365791263393617076632690550955298233611068528870707089364095396e+00), SC_(4.03198855044301554816172072614225033788691505795611432584438613689610292824028384688095043674471559124897800612350231064864096087718457160639337450525089464591496773979407785076356708014174129536539640532615095723967138046302232419186403372347709059543748470408896810291291180015648613156670374402027509167511951650054983758492567575324143010258003034809361205157135224850913835714293416750775594448006015222943082316111780423579293934013166760093499975251633169677773646504254854198727344120013504365e-07)},
                                                                                           {SC_(2.00000190734863281250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00000080639862179156320749294205460277721263993072638189466465607403289991143399112081618390192080963070354362886119327646176199516603660937826302901159928779494258019082124712407057933583908441496121322063683259318008058781175829274964725273678817450354460034581300882836023853249853243649983467946063352515390711748246817082161654458328562433974332388415775058145731044093471875681157457108697886142238279184839101146584613813640533770816777389788965810315717293167650115988276824457403595566759389e+00), SC_(8.06398296652369388346753570212806293434617232720966725801587802276808064585926804588184187043135604602686396171466242066554348032404711308797270594130241494161534533864038783147874657175104558077883552634080070849598914179245766012967264457383839298001666035383180768607693646745391307544328709128695266429891189065277448225084990453870685304089249021637700855765025758836941010684469612390178013299005220982859478280091515998345131481699299506763765052696832472588629108234998520472751599705762862356e-07)},
                                                                                           {SC_(2.00000667572021484375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00000282240828612370720432797341957422445599590783120191598452050016192718431252156475433521025107815241299689727688190713762804692078252171442580070457989886811171740362147708150897847246521021353648087384510766114323922511042794780794963611368596831842470145084109206592297151053427050373627219979831633894688588291555439270912595000568295516884494034186513041322990336045552200687704404122041643387206167556427413751475495475766262400293533115355573835729416036577460770575506761724680166442542205e+00), SC_(2.82240430313693482259741002317161344692584090816350421570061439040390205793534184180679012494641343828056263558002807243971560338327014657463162594242259880851334402250020991610342925766542062329630756367550321323211687945637272726042075205149190416983911272664024992320980212857811481896974987286244636574782770763547904245074167747630014211411345847779432353677900379896876560812240587252030790328354166673314806061716097732347525218908223708776924400221206951936181129323023407095316462578683205523e-06)},
                                                                                           {SC_(2.00001335144042968750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00000564485327991968668594609717588743187620334387669560320925683608138323706505379186671848228233776630265493443006782405469373155950681711638198173774648872464328767774535861493087995322216857536320454566762040450313550698727293463258463329821616727965930447601219959984721044168618580561296210950745646574464740623985999575897298077649444083254875738139464502197343599936704712558359823411346914202036213419554769879303409746624911821501582952260886957328885985322110392828234082593263639947413253e+00), SC_(5.64483734779536708386785894934199777725964876845433467264447717112994234556972534192218656188108493669337126323346525968019986211081211701648787471584545174938623855070199540574827647819065018548603418529971801560701167562341186495748315805711171811817613909853725214174720409287402657526024192981129576773427177060556261477821785713896316233730786535929598718603282821984633658641971448620591249698834069603542821378964494629888597814475264502798958300823972230397309547512496385402948011659018612308e-06)},
                                                                                           {SC_(2.00001716613769531250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00000725769547171200167564651655781339501747509170098598324110434935716090095444696937906607363088739878177923814143661505313658313437339243393242291780132442290199415466622168654728458608339173247740576549746614640956566066866430011407322576072587095409588704181386960856222173704985729295910394663867051373449414642750484101682727247737150988891422843497594286426018641870789465070238089390338211030500873713792516468514692736358005370399134292567498197113950550095013629986729155685259947938135536e+00), SC_(7.25766913476765189195943994441059059063931591396766321180095950635741905767289274108973144158196620893048522962182368196336453133307209215602635345230143943859407773807168277575281927389367146545537872394784276831689726825577222687305283368915549011001823219543451522711095115473870948208010149514574062931974517483036146556187182145659391171551431216570623340783643192270760300569668149898941633206468627648411118821538870638769588745778143031469232973340074226512043471253590740081694584319298530296e-06)},
                                                                                           {SC_(2.00006008148193359375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00002540299606354791065346284198395071392875295770431323580196614759982793856324349365396015329614421966458647642567726829113804005273586077478149065754298525775201160607751664030681223021989523182566039331380106760457489528499350049417578075515249135149538682436349952364131677792289256760214855379993211811298605656429676833893492196246177835739676095563228276086226377489403591966271602430351591781580342925613408409569377283919944732510580834336822851093251943664838933995360754027866586976925851e+00), SC_(2.54026734129075920683292497513548989135470818393407385853298137294395173713099726839012404342665592243399085416582332060628801690208097983739002406025934607527022791719818585971188300777024910785735796519500643466487320162076429378768121348997496169212590642570240123161578934167744566979249172495862343250947755453958462282871032707952094614466497359897253881671158104674131343402296124478766617373684005972841762744006880609634714505140811507944847363892081962397928329908133631675224301028449247209e-05)},
                                                                                           {SC_(2.00011634826660156250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00004919579971274987085172264051528477688620257556098733179199797634993006055608473993509011423580085655400431431748032522949606654990020016568322885459038549486931421278268572942503971061688380325649937281598614721987287749832098883394446271542552887155227649358981358083752285904573279825696370210973258395291081843521899210367510309139360759318429085870041933795710719739751402675370645882893834096485696907489845929951714564265042472412399767903286958066978690375487334358793398429830456561541246e+00), SC_(4.91945896390820475195370970645602094808037804377590418877034537519903014145963070050094790711325337883992554088808760086026030902259009588513453547405813184039270067427528313371078524967343062809805890477343634441228005677940570227333130604677886144106807165848097649545352137718974323948752964644308680893166137837610910555163484988859334163045674658729040392892717423042002979632823737182738830808717162341432139261825185824243512121766256143995598535133134723195587750262495436621336439795174387835e-05)},
                                                                                           {SC_(2.00014877319335937500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00006290809135631836010117832694910884162897852465378752121504232411219503893527713522395467812648391482447399141309991293749270126109922804569579351974393592882118993134665992128136689581102395919839579729236175109716400885285467347857304588838104602389799424028052742153471950528851108394765447248467693160600801279958904164762839085292385657809249863560539720701829052485256749042278246123879349245502162062142354267095491755531429549626456789964981518584088969769936886585070722733145919395422821e+00), SC_(6.29061127253201440487758474836373805783136286628744476010931129298030354555338078339617930326707541807536724443762505067268693291418747671368044733699672217831004599282343529717810773460926922006823045900978640697730593796486796292597553994448182322203424673613673826679553245785071474823905571747970217285633939851724732886368648977212490174113663820136503886232944614523399811332727124466745548877384069974675038479667681516039717424797860050660126927295087191793263665124491531011381265079322510497e-05)},
                                                                                           {SC_(2.00039863586425781250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00016860244976056265274104250042339264795490885298408767683185991260848173515982048063530097499917171148194931029349352640670782785724424106239359449491337847227802622585196405678868931956700176591838250468804948749651418462210706999940223229935053155558688743886448270973803464416218977188135288871521807292536522613240793899596571718868959233786678163988748880988951672966050324443415049581691737548496916730217092347107982502603129665491416261845625192330758149843287258281523770384959803934715742e+00), SC_(1.68588237964936617725573866192084801300187025488573449723958905292528558677560307939136401071488780012664616755906250008647359831845341046315862971508236868311850624153598433932470170707220423511352555441028287147256686322654153696151693628355062766009121440388562309459578300783864351215367098079641124426125653492611009828966768679542829405019789539978282261729619815161598550862768014752088779305148355628992689441225448919902699678811993936710593983239834116001627961033784077675665187451904779153e-04)},
                                                                                           {SC_(2.00063800811767578125000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00026990750041852421765366910628431973474865306478493810159708621323870871973118744454114814939325483626647062327232431721609165735997428833979053416183622439983621245874940645789317173396881439394408015656296494647112371565895925809887772690783846745411149877139730876519000006744104903586271269698152110744658555649922874109964207178521955852588404483178141111968812445948355284551749269795546643581115097967186393797452722030686805063649653415569480391265099835897962993260240130068971271304727487e+00), SC_(2.69871081942065723897833099470995487800158997999008998347813401241773943654131765184972285158614214641749498196406392645505184508075530625363890023930226819460655785021303840797155528371522530911358371088155260193772440453024087940353600470087063993834537412713544819005646799581180031366714889866852653659503836096784982086654775806436187485934147132190078275537650223336741258760920441829149880313735373118931133566363904035798043218143706480154098407247747391184674434380504850962356703140842776482e-04)},
                                                                                           {SC_(2.00107192993164062500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00045366850244676328437925811291073214721976041570836260525501664695528715250408575145931378349350227688837316676868254719113597414318217870885844613229100808084497215923555968306851384139377823756137707740468543389970979577970623128733809962698992633941000918916641725087330663136277097326315490132382010503633074057199260098276330149620295467434128041592429716319985644497132929559777710003514847010029779221896564946779046395621309674719671941599041158491221996485551059405243097093577110261783446e+00), SC_(4.53565626005065278926467940737642886605249081041802313480807335050258790272115953359716522668419818080599307266053631904431521057302273515725629853746800638510488383571198722159231860540917028344994514956013946808052183595119710018510329469789737703176433796292351366450813161229871010564403903786056927568689158871830933860651600507487702193264045530383700007441066684051740039536729108634765214756819077820262508689114004651424406631533658945395417870161936749479421943272531385382088836918042945083e-04)},
                                                                                           {SC_(2.00302124023437500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00128109453382675805173992936811235013623574400347864620287586318438309294296665771775467445713658191501098042317502832687005143325478326763307131985706554101553485442510186534211913551363194311510651662998641180078528045675828899947117843797072061127185592558360128674206812796658575963285754372198258684165702376177309610909388042634428491075001412861942564107042409560615729123629146679339990196142809886924437774615022430018387187232103447017447004392918496134872896723476265006537164632595098140e+00), SC_(1.28027463239724483573557591805281156031783786455407331932724556092523281693077215723336812242738030575971419315597244134798471470509239217931886729204522846233287533744777134652447761428596469288172600899533917013300359587696649805109934740082670700437170661671201465552822434017620867488841178011239797068554314139917114166483646378072990776989847016014395621598620280894638628718729791912651882959514839837935385891368255358441348171707916587078365790333842092452342852422428006539026507499595286123e-03)},
                                                                                           {SC_(2.00499343872070312500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00212142687656938141755270267953218765354768440933747494815728726712151222070491619095448970333895393102444381708475627275738580419453523195048052196379247915358684398503757315017141406139047336197575310525733968756298578987992499076885165365084990221306522699178292450185978338864665272953117267614937180452725496381985816195572219564378217691076292404788320272952577105820443381455242824711291502490670740124425205103598528630778954594116895950873773335330424825150256890064566932046528756803850377e+00), SC_(2.11917982797806522188180583003778103974751450356379656023292543359724208118117325946572388778921904109959311356271811647949638546545148491244584564070484155125952798837608461639766227062066344856863585936876232794773824375120613111140413086769458486596098060127417623954442102532030333552359584958516332878683424121585275505850970921650425493840174528373209639623509936585019571702003296293023302489480387225826279840718692043287032926120545307827287470013099533025763093667172429225118318113870786208e-03)},
                                                                                           {SC_(2.00928401947021484375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.00396070159046626935511242705234690901218236095282169771624882103505993499719962388966570231900481119384425168785810482517055802032380367843668498408199062053383972024792891639768193707683013646734312421126399867391625714088146455431741320398132294311867702699910710257806208656164296257925674148222338444701332204049088886668733363978488089027829282411338212114532892893682282276507146315808397645071291768383839937827086383616329198213608310939839268318908099732004589321018099591371493619747249631e+00), SC_(3.95287866131048848362949332955482809813076597121930182265468445712788358294143596058339399774748227605315495370143056461809371109597058293347314059761260952541527829461615326949940335043617147241318395774085607956500413456369858807011840974780701301554326183297359957043339930077882451930283804249507686065739672454172144114535956579235090987261573105806998672929894099870037590014574603650514557889886665766715585784345883317933151789624097968432728774013964196082834709374955951419821387012151249400e-03)},
                                                                                           {SC_(2.02416992187500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.01046043252505270540348864139253462361405144648089692783487100389214760953674167508997700463439388241380949691579319056966872356933278042871661474710292440940425675059725890695043859580872646359743050035128388851244819200943544005620842213202597157253369936431918277145821339842153005800963054574069458416961754561181466561153641602286677082930975916212869637489229264881405874178948279261212245261827886389949246815690926156066278390139052729949218614616691327310111196212366658537263564003698316686e+00), SC_(1.04061007614633015888506552864890187300424291776713882118559537231037896435738358627458345297202553217351350725032661791909644351751312758522401030616953479527240248501544067448116919217029247318494741938200819289498451100715539693480677760858450468487286554749460935161181430847180062573510341370004226635188701720062386639582275639420676796347377428587899902624464686139266483219004395187251433297865892676882328269889806653848707748007936999905330214536016979834048012739320965030439429057045382243e-02)},
                                                                                           {SC_(2.06227684020996093750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.02794777691629049193504390235516903904685488713247685582519603512105260522463735818554622361453962807292107231999993865443863636016422482468073136921333975898098163990514820931936483699455271677262446764306240533746033838338608816064501896947661274923124993994172638131485369377970739578593544353021087099305294127230319375266951896578913720592622847270176439826888386290790930789539393963150979413129440604185373077854075465693083153485136923946684182484672155068069363826098702103238635420489190320e+00), SC_(2.75643650774888061670685649048190767794082581488473953554589507676339470495854150371718710075080407758280379482617006492575884521367017539656756513515621826253686899723946040513136318257344014516389163303047441444416452076515352022257721695414093144578314213761291012013465662826539298879963192579050341577937021219782512691210616431141692894047421455586943199613536641000412200192791271919535732465144076608722082755046949411524847483821817449723308031951964499163351930528842227963221257503313906453e-02)},
                                                                                           {SC_(2.12234401702880859375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.05805563595315918870620421524696928104121094020123122438591403908241219015868614428499827547272175158643580386943048386142399843901618528166730694455229164550039869186159172224183094834887338162067894198894809433633712767764687117266852119387945316827334128187517324798364147479381468438290770208748715873468048281517169879643662462978121501305190754179038096804244270749490304891307019935778794914003748853181431342998479066888373904416656160676722262062683000801879454155276475143345792496648973201e+00), SC_(5.64329180205833189457202528539405980451202615961305194101203405759309850646470129298871261850384869366086721140086742612879750402334731484485411214841852903126716872739314918112243534983931682696927881636448720345394093622904476579243712320772347374338360965150249665935072437073635189766843122322561564241771470220052390739248148539657800012921462649571509627481171784835330155295559197243566391110694212531989990104509951797406602267883991910533467933935868541283958081404580151382316102798202818663e-02)},
                                                                                           {SC_(2.15761280059814453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.07723244020951674736879024409015567278674737427280181790958191485280131080304291237276361807466338094341891840492656978367711727637106416679804070829852978008261215431888758036898775633940482292123134601737585845696200859486998264872046143555878009818620345847733547045237356831681855942609725505498410349738410778577001739079204840229118046714852909334644202624686546361760524439047857738766396297664386891608925813105226195741601654256704110771917895237804372499638318366040599062738662549672075233e+00), SC_(7.43951968096078567450169038225671190608692238403345259369787919244023060889967195591743644105668461468324843850667686453041016494846928923754334711387649093526562013857192333261291836182288952913133602463831698851059598556266445835039363674561701274012167017363825904055449988055678519606988903967580415182626339877700624724471311093486364881415001248271337139615419880940596287705173710534987910042007765327377593821618312773836917297573770845920102032310648380234431643136775836112724418122395944148e-02)},
                                                                                           {SC_(2.24955749511718750000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.13271614293701721566359811181216844599514203933890310472153469801157718942898125040824868865093076523138824085647633489733751440515813372334536113721345367989120827892830875626989392162079427686322414937731343959752581459822783558484176886389947866708191972913902481439656435178795000816666303153729497641630043980861878770826826639629131704289181832948488360798051269765157501482440590629153105228466160831086484632057682895937375064959461519416204280008586813626946447886299889658545193561852005221e+00), SC_(1.24618414855135508767735862376307617769086138922393052111180412177914174153912067255243690888418634491489827308484772844885839836965633854624454396599801250844003229947321063187141240211496575790700669319652484948080298117038544086335592701606904389673878974576502676541776966818151447737115996064285788233106715666059725339111146196422616638378704568975707438135210898185649605602870819709122240260077954056652903506653003017718439923455933787418857732758136503190158208436673133318059105277181156412e-01)},
                                                                                           {SC_(2.49122142791748046875000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.32118502516972019933515927336103098702121708295751105812488772605156911772365536897112612268098693177769841152502858397420026350114877465933729535497144281541135352932345376700618048099509451546579901663817269885709441847417283354768740949858195062449544534092668839707066796039624277249009376670869597887289998728613927141880549915613031747586675073174707758681855414360545031137199348021318900766417674431763100410455529404359261909164635053011626589643775277596465694320978005200845792741119134923e+00), SC_(2.78529080205747320956767680429427836727030590567393648909624132802498276501643152789574992070355469843620486053404278844738924735963376178005736900575827387449444173046088740850247064273970170875025909159212947254188496477090539228691270466260135938060766950587422809929080227478886503787218528163783429861153888831422036541043806448191088131552215464050108120064521772377215109248113444727286949161594653754349157193957064235785340374457082073732189833403792835120283596916983131946632783704229344885e-01)},
                                                                                           {SC_(2.98384761810302734375000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(1.97051246451251004874297221651138180345200782932645719112022459091787403373578707385755420465767533219748291242620211816297976513805852385613057268665258624866786329786770605380611756547438670824706673187364215059858745216541250405466404493859927324923837716320256664591098922123313952256060988714854976076730317786737382453301647556986241140930376187251202917157565110807687607281314119017889615728891326998507934487463676042713528408643485678529499707961566325046935529271977875583020481735625488347e+00), SC_(6.78293643191154116848661827621536468687319156088981302335984034354394098918670578514850294622645014725444282962568987918377119334481020922962448682614893199281184250591877900628340274535241952010329002672245246619180248418868815716112830856589649442068135409054374901175591316255625024021080534714749685122924217144697864262275559713954426478414234946523413370091910838172379349297462696560662622315457938241067416843354716162216438293199111251634403925999902117392283474387998693379008921611473955473e-01)},
                                                                                           {SC_(3.15761280059814453125000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e+00), SC_(2.32425050221562870893368319780797394502817705273594528358155653513258895338852991948442481762704658601512028960856664174705178007652730881053103452425905994757107112196568675848578038090243587386920465763852835375409931606980737782869414814138253290988781796906638316383011766510477539256606138027072161714425587703780135013131440824352265816084541543950839110895486794382401092016139119485089882925184402328205831095706309275623235851502520342823708778821762663111690734745040834591026561416904111976e+00), SC_(8.43397622430231011639234819630572061422916186592913090140786438989872494587211928954110495101933895495925703033051008272776118939841084357793355479541145156028164488321529335753503026225753481617089830803055726056893347536445132561599214506486246671154145383768011338983825577386537992051530467922693326426358214921270214143368096532528712261953843791787651479311894578525584043960413997661258765749538291326432123667367635267757124285917821294505087615185252902658005357658301585065221283038946577912e-01)}}};
//#undef SC_
