/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package eric.JSprogram;

import eric.GUI.themes;
import eric.GUI.window.myJMenuItem;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import rene.gui.Global;
import rene.util.xml.XmlTree;
import rene.zirkel.ZirkelCanvas;

/**
 *
 * @author erichake
 */
public class ScriptPanel extends JPanel implements MouseListener {

    private ZirkelCanvas ZC;
    private Vector<ScriptItem> items=new Vector<ScriptItem>();
    private static Image icon=themes.getImage("scripts.png");
    private int W=32, H=32, X=10, Y=10;

    public void paintComponent(Graphics g) {
        g.drawImage(icon, 0, 0, W, H, this);
    }

    public ScriptPanel(ZirkelCanvas zc) {
        ZC=zc;
        setBounds(X, Y, W, H);
        addMouseListener(this);
    }

    public void showPopup() {
        JPopupMenu popup=new JPopupMenu();
        // add Cancel Item :
        myJMenuItem item=new myJMenuItem(Global.Loc("JSmenu.cancel")) {

            @Override
            public void action() {
                JSRun.restore();
            }
        };
        item.setEnabled(JSRun.isBackup());
        popup.add(item);

        item=new myJMenuItem(Global.Loc("JSmenu.add")) {

            @Override
            public void action() {
                JSRun.newScriptInConstruction();
            }
        };
        popup.add(item);


        popup.add(new JSeparator());

        // add Run script items :
        for (int i=0; i<items.size(); i++) {
            popup.add(items.get(i));
        }
        popup.add(new JSeparator());

        // add Modify Menu :
        JMenu modifypopup=new JMenu(Global.Loc("JSmenu.modify"));
        for (int i=0; i<items.size(); i++) {
            final int itemnum=i;
            item=new myJMenuItem(items.get(i).getScriptName()) {

                @Override
                public void action() {
                    JSRun.openEmbeddedScript(items.get(itemnum).getScriptName(), items.get(itemnum).getScriptSource());
                }
            };
            modifypopup.add(item);
            modifypopup.setFont(themes.TabMenusFont);
        }
        popup.add(modifypopup);

        // add Delete Menu :
        JMenu deletepopup=new JMenu(Global.Loc("JSmenu.delete"));
        for (int i=0; i<items.size(); i++) {
            final int itemnum=i;
            item=new myJMenuItem(items.get(i).getScriptName()) {
                @Override
                public void action() {
                    removeScript(items.get(itemnum));
                }
            };
            deletepopup.add(item);
            deletepopup.setFont(themes.TabMenusFont);
        }
        popup.add(deletepopup);


        popup.show(this, W-10, H);
    }

    public Vector<ScriptItem> getScripts() {
        return items;
    }

    public void removeScript(ScriptItem si) {
        ZC.getConstruction().haveChanged();
        items.remove(si);
        if (items.size()==0) {
            ZC.remove(this);
            ZC.repaint();
        }
    }

    public void addScript(XmlTree tree) {
        items.add(new ScriptItem(tree));

        // at first added script, button must be drawn in the canvas :
        if (items.size()==1) {
            ZC.add(this);
        }
    }

    private ScriptItem findScript(String nme) {
        for (int i=0; i<items.size(); i++) {
            if (nme.equals(items.get(i).getScriptName())) {
                return items.get(i);
            }
        }
        return null;
    }

    public void removeScript(String nme) {
        ScriptItem si=findScript(nme);
        if (si!=null) {
            removeScript(si);
        }
    }

    public void saveScript(String nme, String source) {
        ScriptItem si=findScript(nme);
        if (si!=null) {
            si.setScriptSource(source);
        } else {
            items.add(new ScriptItem(nme, source));
        }

        // at first added script, button must be drawn in the canvas :
        if (items.size()==1) {
            ZC.add(this);
            ZC.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        showPopup();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }


}
