//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Core/Computation/GISASSpecularComputation.h
//! @brief     Defines class GISASSpecularComputation.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif

#ifndef USER_API
#ifndef BORNAGAIN_CORE_COMPUTATION_GISASSPECULARCOMPUTATION_H
#define BORNAGAIN_CORE_COMPUTATION_GISASSPECULARCOMPUTATION_H

class IFresnelMap;
class SimulationElement;

//! Computes the specular signal in the bin where q_parallel = 0. Used by DWBAComputation.
//! @ingroup algorithms_internal

class GISASSpecularComputation final {
public:
    GISASSpecularComputation(const IFresnelMap* p_fresnel_map);

    void compute(SimulationElement& elem) const;

private:
    const IFresnelMap* m_fresnel_map;
};

#endif // BORNAGAIN_CORE_COMPUTATION_GISASSPECULARCOMPUTATION_H
#endif // USER_API
