(* Copyright 1996-2003 John D. Polstra.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by John D. Polstra.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: RCSTag.i3,v 1.10 2003/03/04 19:26:27 jdp Exp $ *)

INTERFACE RCSTag;

IMPORT RCSRevNum;

CONST
  Brand = "RCSTag";

TYPE
  T = REF RECORD
    name: TEXT;
    revNum: RCSRevNum.T;
  END;

(* An "RCSTag.T" represents a symbolic tag in an RCS file.  Each tag
   consists of a name and an associated revision number. *)

PROCEDURE Compare(READONLY t1, t2: T): [-1..1];
(* Compares two tags alphabetically by name. *)

PROCEDURE Equal(READONLY t1, t2: T): BOOLEAN;
(* Tests whether two tags have the same name. *)

PROCEDURE IsCVSBranch(READONLY t: T): BOOLEAN;
(* <=> The revision number of this tag is a CVS branch number (like 1.1.1,
       2.1.4) or a magic CVS branch number (like 2.1.0.4, 4.3.3.2.0.8). *)
END RCSTag.
